/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FacedCubemapData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.loader.CubemapLoader;
import java.util.HashMap;
import java.util.Map;

public class OwnCubemap
extends GLTexture {
    static final Map<Application, Array<OwnCubemap>> managedCubemaps = new HashMap<Application, Array<OwnCubemap>>();
    private static AssetManager assetManager;
    protected CubemapData data;

    public OwnCubemap(CubemapData data) {
        super(34067);
        this.data = data;
        this.load(data);
        if (data.isManaged()) {
            OwnCubemap.addManagedCubemap(Gdx.app, this);
        }
    }

    public OwnCubemap(CubemapData data, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        super(34067);
        this.data = data;
        this.load(data, minFilter, magFilter);
        if (data.isManaged()) {
            OwnCubemap.addManagedCubemap(Gdx.app, this);
        }
    }

    public OwnCubemap(FileHandle positiveX, FileHandle negativeX, FileHandle positiveY, FileHandle negativeY, FileHandle positiveZ, FileHandle negativeZ) {
        this(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, false);
    }

    public OwnCubemap(FileHandle positiveX, FileHandle negativeX, FileHandle positiveY, FileHandle negativeY, FileHandle positiveZ, FileHandle negativeZ, boolean useMipMaps) {
        this(TextureData.Factory.loadFromFile((FileHandle)positiveX, (boolean)useMipMaps), TextureData.Factory.loadFromFile((FileHandle)negativeX, (boolean)useMipMaps), TextureData.Factory.loadFromFile((FileHandle)positiveY, (boolean)useMipMaps), TextureData.Factory.loadFromFile((FileHandle)negativeY, (boolean)useMipMaps), TextureData.Factory.loadFromFile((FileHandle)positiveZ, (boolean)useMipMaps), TextureData.Factory.loadFromFile((FileHandle)negativeZ, (boolean)useMipMaps));
    }

    public OwnCubemap(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ) {
        this(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ, false);
    }

    public OwnCubemap(Pixmap positiveX, Pixmap negativeX, Pixmap positiveY, Pixmap negativeY, Pixmap positiveZ, Pixmap negativeZ, boolean useMipMaps) {
        this((TextureData)(positiveX == null ? null : new PixmapTextureData(positiveX, null, useMipMaps, false)), (TextureData)(negativeX == null ? null : new PixmapTextureData(negativeX, null, useMipMaps, false)), (TextureData)(positiveY == null ? null : new PixmapTextureData(positiveY, null, useMipMaps, false)), (TextureData)(negativeY == null ? null : new PixmapTextureData(negativeY, null, useMipMaps, false)), (TextureData)(positiveZ == null ? null : new PixmapTextureData(positiveZ, null, useMipMaps, false)), (TextureData)(negativeZ == null ? null : new PixmapTextureData(negativeZ, null, useMipMaps, false)));
    }

    public OwnCubemap(int width, int height, int depth, Pixmap.Format format) {
        this((TextureData)new PixmapTextureData(new Pixmap(depth, height, format), null, false, true), (TextureData)new PixmapTextureData(new Pixmap(depth, height, format), null, false, true), (TextureData)new PixmapTextureData(new Pixmap(width, depth, format), null, false, true), (TextureData)new PixmapTextureData(new Pixmap(width, depth, format), null, false, true), (TextureData)new PixmapTextureData(new Pixmap(width, height, format), null, false, true), (TextureData)new PixmapTextureData(new Pixmap(width, height, format), null, false, true));
    }

    public OwnCubemap(TextureData positiveX, TextureData negativeX, TextureData positiveY, TextureData negativeY, TextureData positiveZ, TextureData negativeZ) {
        this((CubemapData)new FacedCubemapData(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ));
    }

    public OwnCubemap(TextureData positiveX, TextureData negativeX, TextureData positiveY, TextureData negativeY, TextureData positiveZ, TextureData negativeZ, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        this((CubemapData)new FacedCubemapData(positiveX, negativeX, positiveY, negativeY, positiveZ, negativeZ), minFilter, magFilter);
    }

    private static void addManagedCubemap(Application app, OwnCubemap cubemap) {
        Array managedCubemapArray = managedCubemaps.get(app);
        if (managedCubemapArray == null) {
            managedCubemapArray = new Array();
        }
        managedCubemapArray.add((Object)cubemap);
        managedCubemaps.put(app, (Array<OwnCubemap>)managedCubemapArray);
    }

    public static void clearAllCubemaps(Application app) {
        managedCubemaps.remove(app);
    }

    public static void invalidateAllCubemaps(Application app) {
        Array<OwnCubemap> managedCubemapArray = managedCubemaps.get(app);
        if (managedCubemapArray == null) {
            return;
        }
        if (assetManager == null) {
            for (int i = 0; i < managedCubemapArray.size; ++i) {
                OwnCubemap cubemap = (OwnCubemap)((Object)managedCubemapArray.get(i));
                cubemap.reload();
            }
        } else {
            assetManager.finishLoading();
            Array cubemaps = new Array(managedCubemapArray);
            for (OwnCubemap cubemap : cubemaps) {
                String fileName = assetManager.getAssetFileName((Object)cubemap);
                if (fileName == null) {
                    cubemap.reload();
                    continue;
                }
                final int refCount = assetManager.getReferenceCount(fileName);
                assetManager.setReferenceCount(fileName, 0);
                cubemap.glHandle = 0;
                CubemapLoader.CubemapParameter params = new CubemapLoader.CubemapParameter();
                params.cubemapData = cubemap.getCubemapData();
                params.minFilter = cubemap.getMinFilter();
                params.magFilter = cubemap.getMagFilter();
                params.wrapU = cubemap.getUWrap();
                params.wrapV = cubemap.getVWrap();
                params.cubemap = cubemap;
                params.loadedCallback = new AssetLoaderParameters.LoadedCallback(){

                    public void finishedLoading(AssetManager assetManager, String fileName, Class type) {
                        assetManager.setReferenceCount(fileName, refCount);
                    }
                };
                assetManager.unload(fileName);
                cubemap.glHandle = Gdx.gl.glGenTexture();
                assetManager.load(fileName, OwnCubemap.class, (AssetLoaderParameters)params);
            }
            managedCubemapArray.clear();
            managedCubemapArray.addAll(cubemaps);
        }
    }

    public static void setAssetManager(AssetManager manager) {
        assetManager = manager;
    }

    public static String getManagedStatus() {
        StringBuilder builder = new StringBuilder();
        builder.append("Managed cubemap/app: { ");
        for (Application app : managedCubemaps.keySet()) {
            builder.append(OwnCubemap.managedCubemaps.get((Object)app).size);
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public static int getNumManagedCubemaps() {
        return OwnCubemap.managedCubemaps.get((Object)Gdx.app).size;
    }

    public void load(CubemapData data) {
        if (!data.isPrepared()) {
            data.prepare();
        }
        this.bind();
        this.unsafeSetFilter(this.minFilter, this.magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        this.unsafeSetAnisotropicFilter(this.anisotropicFilterLevel, true);
        data.consumeCubemapData();
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    public void load(CubemapData data, Texture.TextureFilter minFilter, Texture.TextureFilter magFilter) {
        if (!data.isPrepared()) {
            data.prepare();
        }
        this.bind();
        Gdx.gl.glTexParameteri(34067, 33084, 0);
        Gdx.gl.glTexParameteri(34067, 33085, 8);
        this.minFilter = minFilter;
        this.magFilter = magFilter;
        this.unsafeSetFilter(minFilter, magFilter, true);
        this.unsafeSetWrap(this.uWrap, this.vWrap, true);
        this.unsafeSetAnisotropicFilter(this.anisotropicFilterLevel, true);
        data.consumeCubemapData();
        Gdx.gl.glGenerateMipmap(34067);
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    public CubemapData getCubemapData() {
        return this.data;
    }

    public boolean isManaged() {
        return this.data.isManaged();
    }

    protected void reload() {
        if (!this.isManaged()) {
            throw new GdxRuntimeException("Tried to reload an unmanaged Cubemap");
        }
        this.glHandle = Gdx.gl.glGenTexture();
        this.load(this.data);
    }

    public int getWidth() {
        return this.data.getWidth();
    }

    public int getHeight() {
        return this.data.getHeight();
    }

    public int getDepth() {
        return 0;
    }

    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedCubemaps.get(Gdx.app) != null) {
            managedCubemaps.get(Gdx.app).removeValue((Object)this, true);
        }
    }

    public static enum CubemapSide {
        PositiveX(0, 34069, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f),
        NegativeX(1, 34070, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f),
        PositiveY(2, 34071, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f),
        NegativeY(3, 34072, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f),
        PositiveZ(4, 34073, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f),
        NegativeZ(5, 34074, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);

        public final int index;
        public final int glEnum;
        public final Vector3 up;
        public final Vector3 direction;

        private CubemapSide(int index, int glEnum, float upX, float upY, float upZ, float directionX, float directionY, float directionZ) {
            this.index = index;
            this.glEnum = glEnum;
            this.up = new Vector3(upX, upY, upZ);
            this.direction = new Vector3(directionX, directionY, directionZ);
        }

        public int getGLEnum() {
            return this.glEnum;
        }

        public Vector3 getUp(Vector3 out) {
            return out.set(this.up);
        }

        public Vector3 getDirection(Vector3 out) {
            return out.set(this.direction);
        }
    }
}

