/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.ModelCreator;
import gaiasky.util.math.MathUtilsDouble;
import net.jafama.FastMath;

public class RingCreator
extends ModelCreator {
    float innerRadius;
    float outerRadius;
    float startAngle;
    float endAngle;

    public RingCreator() {
        this.name = "Ring";
    }

    public RingCreator create(int divisions, float innerRadius, float outerRadius, boolean flipNormals) {
        return this.create(divisions, innerRadius, outerRadius, flipNormals, 0.0f, 360.0f);
    }

    public RingCreator create(int divisions, float innerRadius, float outerRadius, boolean flipNormals, float startAngle, float endAngle) {
        this.innerRadius = innerRadius;
        this.outerRadius = outerRadius;
        this.startAngle = startAngle;
        this.endAngle = endAngle;
        float angleStep = (endAngle - startAngle) / (float)divisions;
        float angle = startAngle;
        int prev1 = this.addVertex(new Vector3(1.0f, 0.0f, 0.0f).scl(innerRadius).rotate(angle, 0.0f, 1.0f, 0.0f), angle);
        int prev2 = this.addVertex(new Vector3(1.0f, 0.0f, 0.0f).scl(outerRadius).rotate(angle, 0.0f, 1.0f, 0.0f), angle);
        for (angle = startAngle + angleStep; angle <= endAngle; angle += angleStep) {
            int i1 = this.addVertex(new Vector3(1.0f, 0.0f, 0.0f).scl(innerRadius).rotate(angle, 0.0f, 1.0f, 0.0f), angle);
            int i2 = this.addVertex(new Vector3(1.0f, 0.0f, 0.0f).scl(outerRadius).rotate(angle, 0.0f, 1.0f, 0.0f), angle);
            this.addFace(this.faces, flipNormals, prev1, prev2, i2, i1);
            prev1 = i1;
            prev2 = i2;
        }
        this.addNormals();
        return this;
    }

    protected int addVertex(Vector3 p, float angle) {
        this.addUV(p, angle);
        this.vertices.add(p);
        return this.index++;
    }

    protected void addUV(Vector3 p, float angle) {
        float u = MathUtilsDouble.lint(angle, this.startAngle, this.endAngle, 0.0f, 1.0f);
        float v = this.equals(p.len(), this.innerRadius) ? 0.0f : 1.0f;
        this.uv.add(new Vector2(u, v));
    }

    private boolean equals(float one, float two) {
        return FastMath.abs((float)(one - two)) < 1.0E-4f;
    }

    protected void addNormals() {
        for (ModelCreator.IFace face : this.faces) {
            Vector3 a = ((Vector3)this.vertices.get(face.v()[1] - 1)).cpy().sub((Vector3)this.vertices.get(face.v()[0] - 1));
            Vector3 b = ((Vector3)this.vertices.get(face.v()[2] - 1)).cpy().sub((Vector3)this.vertices.get(face.v()[1] - 1));
            this.normals.add(a.crs(b).nor());
            int idx = this.normals.size();
            face.setNormals(idx, idx, idx, idx);
        }
    }
}

