/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.IntArray;
import gaiasky.util.gdx.IntIntMeshBuilder;
import gaiasky.util.gdx.IntMeshPartBuilder;
import gaiasky.util.gdx.ModelCreator;

public class SphereCreator
extends ModelCreator {
    private static final Vector3 axisY = new Vector3();
    private static final Vector3 axisZ = new Vector3();
    private static final IntMeshPartBuilder.VertexInfo vertTmp3 = new IntMeshPartBuilder.VertexInfo();
    private static IntArray tmpIndices = new IntArray();

    public static void create(IntIntMeshBuilder builder, Matrix4 transform, float width, float height, float depth, int divisionsU, int divisionsV, boolean flipNormals, float angleUFrom, float angleUTo, float angleVFrom, float angleVTo) {
        axisY.set(0.0f, 1.0f, 0.0f);
        axisZ.set(0.0f, 0.0f, 1.0f);
        float hw = width * 0.5f;
        float hh = height * 0.5f;
        float hd = depth * 0.5f;
        float auo = (float)Math.PI / 180 * angleUFrom;
        float stepU = (float)Math.PI / 180 * (angleUTo - angleUFrom) / (float)divisionsU;
        float avo = (float)Math.PI / 180 * angleVFrom;
        float stepV = (float)Math.PI / 180 * (angleVTo - angleVFrom) / (float)divisionsV;
        float us = 1.0f / (float)divisionsU;
        float vs = 1.0f / (float)divisionsV;
        IntMeshPartBuilder.VertexInfo curr1 = vertTmp3.set(null, null, null, null);
        curr1.hasBinormal = true;
        curr1.hasTangent = true;
        curr1.hasNormal = true;
        curr1.hasPosition = true;
        curr1.hasUV = true;
        if (tmpIndices == null) {
            tmpIndices = new IntArray(divisionsU * 2);
        }
        int s = divisionsU + 3;
        tmpIndices.ensureCapacity(s);
        while (SphereCreator.tmpIndices.size > s) {
            tmpIndices.pop();
        }
        while (SphereCreator.tmpIndices.size < s) {
            tmpIndices.add(-1);
        }
        int tempOffset = 0;
        builder.ensureRectangles((divisionsV + 1) * (divisionsU + 1), divisionsV * divisionsU);
        for (int iv = 0; iv <= divisionsV; ++iv) {
            float angleV = avo + stepV * (float)iv;
            float v = vs * (float)iv;
            float t = MathUtils.sin((float)angleV);
            float h = MathUtils.cos((float)angleV) * hh;
            for (int iu = 0; iu <= divisionsU; ++iu) {
                float angleU = auo + stepU * (float)iu;
                float u = 1.0f - us * (float)iu;
                curr1.position.set(MathUtils.cos((float)angleU) * hw * t, h, MathUtils.sin((float)angleU) * hd * t).mul(transform);
                curr1.normal.set(curr1.position).nor();
                curr1.binormal.set(1.0f, 0.0f, 0.0f).rotateRad(axisZ, -angleV).rotateRad(axisY, -angleU).nor();
                curr1.tangent.set(curr1.normal).crs(curr1.binormal).nor();
                curr1.uv.set(u, v);
                tmpIndices.set(tempOffset, builder.vertex(curr1));
                int o = tempOffset + s;
                if (iv > 0 && iu > 0) {
                    if (!flipNormals) {
                        builder.rect(tmpIndices.get(tempOffset), tmpIndices.get((o - 1) % s), tmpIndices.get((o - (divisionsU + 2)) % s), tmpIndices.get((o - (divisionsU + 1)) % s));
                    } else {
                        builder.rect(tmpIndices.get(tempOffset), tmpIndices.get((o - (divisionsU + 1)) % s), tmpIndices.get((o - (divisionsU + 2)) % s), tmpIndices.get((o - 1) % s));
                    }
                }
                tempOffset = (tempOffset + 1) % SphereCreator.tmpIndices.size;
            }
        }
    }
}

