/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureArray;
import com.badlogic.gdx.graphics.TextureArrayData;
import com.badlogic.gdx.utils.Array;

public class TextureArrayLoader
extends AsynchronousAssetLoader<TextureArray, TextureArrayParameter> {
    private TextureArrayData data;

    public TextureArrayLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, TextureArrayParameter parameter) {
        if (parameter.files != null) {
            FileHandle[] textureFiles = new FileHandle[parameter.files.length];
            int i = 0;
            for (String f : parameter.files) {
                FileHandle fh = this.resolve(f);
                textureFiles[i++] = fh;
            }
            this.data = TextureArrayData.Factory.loadFromFiles((Pixmap.Format)Pixmap.Format.RGBA8888, (boolean)false, (FileHandle[])textureFiles);
        }
    }

    public TextureArray loadSync(AssetManager manager, String fileName, FileHandle file, TextureArrayParameter parameter) {
        if (this.data != null) {
            TextureArray ta = new TextureArray(this.data);
            ta.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
            return ta;
        }
        return null;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, TextureArrayParameter parameter) {
        return null;
    }

    public static class TextureArrayParameter
    extends AssetLoaderParameters<TextureArray> {
        public String[] files;

        public TextureArrayParameter(String[] files) {
            this.files = files;
        }

        public TextureArrayParameter(Array<String> files) {
            if (files != null && !files.isEmpty()) {
                this.files = new String[files.size];
                for (int i = 0; i < files.size; ++i) {
                    this.files[i] = (String)files.get(i);
                }
            }
        }
    }
}

