/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;
import gaiasky.util.gdx.g2d.BitmapFont;
import net.jafama.FastMath;

public class GlyphLayout
implements Pool.Poolable {
    public final Array<GlyphRun> runs = new Array();
    private final Array<Color> colorStack = new Array(4);
    public float width;
    public float height;

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont font, CharSequence str) {
        this.setText(font, str);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, color, targetWidth, halign, wrap);
    }

    public GlyphLayout(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        this.setText(font, str, start, end, color, targetWidth, halign, wrap, truncate);
    }

    public void setText(BitmapFont font, CharSequence str) {
        this.setText(font, str, 0, str.length(), font.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont font, CharSequence str, Color color, float targetWidth, int halign, boolean wrap) {
        this.setText(font, str, 0, str.length(), color, targetWidth, halign, wrap, null);
    }

    public void setText(BitmapFont font, CharSequence str, int start, int end, Color color, float targetWidth, int halign, boolean wrap, String truncate) {
        int n;
        BitmapFont.BitmapFontData fontData = font.data;
        if (truncate != null) {
            wrap = true;
        } else if (targetWidth <= fontData.spaceXadvance * 3.0f) {
            wrap = false;
        }
        boolean markupEnabled = fontData.markupEnabled;
        Pool glyphRunPool = Pools.get(GlyphRun::new);
        Array<GlyphRun> runs = this.runs;
        glyphRunPool.freeAll(runs);
        runs.clear();
        float x = 0.0f;
        float y = 0.0f;
        float width = 0.0f;
        int lines = 0;
        int blankLines = 0;
        BitmapFont.Glyph lastGlyph = null;
        Array<Color> colorStack = this.colorStack;
        Color nextColor = color;
        colorStack.add((Object)color);
        Pool colorPool = Pools.get(Color::new);
        int runStart = start;
        block4: while (true) {
            int runEnd = -1;
            boolean newline = false;
            if (start == end) {
                if (runStart == end) break;
                runEnd = end;
            } else {
                switch (str.charAt(start++)) {
                    case '\n': {
                        runEnd = start - 1;
                        newline = true;
                        break;
                    }
                    case '[': {
                        if (!markupEnabled) break;
                        int length = this.parseColorMarkup(str, start, end, (Pool<Color>)colorPool);
                        if (length >= 0) {
                            runEnd = start - 1;
                            start += length + 1;
                            nextColor = (Color)colorStack.peek();
                            break;
                        }
                        if (length != -2) break;
                        ++start;
                        continue block4;
                    }
                }
            }
            if (runEnd == -1) continue;
            if (runEnd != runStart) {
                GlyphRun run = (GlyphRun)glyphRunPool.obtain();
                run.color.set(color);
                fontData.getGlyphs(run, str, runStart, runEnd, lastGlyph);
                if (run.glyphs.size == 0) {
                    glyphRunPool.free((Object)run);
                } else {
                    if (lastGlyph != null) {
                        x -= lastGlyph.fixedWidth ? (float)lastGlyph.xadvance * fontData.scaleX : (float)(lastGlyph.width + lastGlyph.xoffset) * fontData.scaleX - fontData.padRight;
                    }
                    lastGlyph = (BitmapFont.Glyph)run.glyphs.peek();
                    run.x = x;
                    run.y = y;
                    if (newline || runEnd == end) {
                        this.adjustLastGlyph(fontData, run);
                    }
                    runs.add((Object)run);
                    float[] xAdvances = run.xAdvances.items;
                    n = run.xAdvances.size;
                    if (!wrap) {
                        float runWidth = 0.0f;
                        for (int i = 0; i < n; ++i) {
                            runWidth += xAdvances[i];
                        }
                        x += runWidth;
                        run.width = runWidth;
                    } else {
                        x += xAdvances[0];
                        run.width = xAdvances[0];
                        if (n >= 1) {
                            x += xAdvances[1];
                            run.width += xAdvances[1];
                            for (int i = 2; i < n; ++i) {
                                GlyphRun next;
                                BitmapFont.Glyph glyph = (BitmapFont.Glyph)run.glyphs.get(i - 1);
                                float glyphWidth = (float)(glyph.width + glyph.xoffset) * fontData.scaleX - fontData.padRight;
                                if (x + glyphWidth <= targetWidth) {
                                    x += xAdvances[i];
                                    run.width += xAdvances[i];
                                    continue;
                                }
                                if (truncate != null) {
                                    this.truncate(fontData, run, targetWidth, truncate, i, (Pool<GlyphRun>)glyphRunPool);
                                    x = run.x + run.width;
                                    break block4;
                                }
                                int wrapIndex = fontData.getWrapIndex(run.glyphs, i);
                                if (run.x == 0.0f && wrapIndex == 0 || wrapIndex >= run.glyphs.size) {
                                    wrapIndex = i - 1;
                                }
                                if (wrapIndex == 0) {
                                    next = run;
                                    run.width = 0.0f;
                                    int glyphCount = run.glyphs.size;
                                    while (wrapIndex < glyphCount && fontData.isWhitespace((char)((BitmapFont.Glyph)run.glyphs.get((int)wrapIndex)).id)) {
                                        ++wrapIndex;
                                    }
                                    if (wrapIndex > 0) {
                                        run.glyphs.removeRange(0, wrapIndex - 1);
                                        run.xAdvances.removeRange(1, wrapIndex);
                                    }
                                    run.xAdvances.set(0, (float)(-((BitmapFont.Glyph)run.glyphs.first()).xoffset) * fontData.scaleX - fontData.padLeft);
                                    if (runs.size > 1) {
                                        int lastIndex;
                                        GlyphRun previous = (GlyphRun)runs.get(runs.size - 2);
                                        for (lastIndex = previous.glyphs.size - 1; lastIndex > 0; --lastIndex) {
                                            BitmapFont.Glyph g = (BitmapFont.Glyph)previous.glyphs.get(lastIndex);
                                            if (!fontData.isWhitespace((char)g.id)) break;
                                            previous.width -= previous.xAdvances.get(lastIndex + 1);
                                        }
                                        previous.glyphs.truncate(lastIndex + 1);
                                        previous.xAdvances.truncate(lastIndex + 2);
                                        this.adjustLastGlyph(fontData, previous);
                                        width = FastMath.max((float)width, (float)(previous.x + previous.width));
                                    }
                                } else {
                                    next = this.wrap(fontData, run, (Pool<GlyphRun>)glyphRunPool, wrapIndex, i);
                                    width = FastMath.max((float)width, (float)(run.x + run.width));
                                    if (next == null) {
                                        x = 0.0f;
                                        y += fontData.down;
                                        ++lines;
                                        lastGlyph = null;
                                        break;
                                    }
                                    runs.add((Object)next);
                                }
                                n = next.xAdvances.size;
                                xAdvances = next.xAdvances.items;
                                x = xAdvances[0];
                                if (n > 1) {
                                    x += xAdvances[1];
                                }
                                next.width += x;
                                ++lines;
                                next.x = 0.0f;
                                next.y = y += fontData.down;
                                i = 1;
                                run = next;
                                lastGlyph = null;
                            }
                        }
                    }
                }
            }
            if (newline) {
                width = FastMath.max((float)width, (float)x);
                x = 0.0f;
                float down = fontData.down;
                if (runEnd == runStart) {
                    down *= fontData.blankLineScale;
                    ++blankLines;
                } else {
                    ++lines;
                }
                y += down;
                lastGlyph = null;
            }
            runStart = start;
            color = nextColor;
        }
        width = FastMath.max((float)width, (float)x);
        int n2 = colorStack.size;
        for (int i = 1; i < n2; ++i) {
            colorPool.free((Object)((Color)colorStack.get(i)));
        }
        colorStack.clear();
        if ((halign & 8) == 0) {
            boolean center = (halign & 1) != 0;
            float lineWidth = 0.0f;
            float lineY = -2.1474836E9f;
            int lineStart = 0;
            n = runs.size;
            for (int i = 0; i < n; ++i) {
                GlyphRun run = (GlyphRun)runs.get(i);
                if (run.y != lineY) {
                    lineY = run.y;
                    float shift = targetWidth - lineWidth;
                    if (center) {
                        shift /= 2.0f;
                    }
                    while (lineStart < i) {
                        ((GlyphRun)runs.get((int)lineStart++)).x += shift;
                    }
                    lineWidth = 0.0f;
                }
                lineWidth = FastMath.max((float)lineWidth, (float)(run.x + run.width));
            }
            float shift = targetWidth - lineWidth;
            if (center) {
                shift /= 2.0f;
            }
            while (lineStart < n) {
                ((GlyphRun)runs.get((int)lineStart++)).x += shift;
            }
        }
        this.width = width;
        this.height = fontData.capHeight - (float)lines * fontData.down - (float)blankLines * fontData.down * fontData.blankLineScale;
    }

    private void truncate(BitmapFont.BitmapFontData fontData, GlyphRun run, float targetWidth, String truncate, int widthIndex, Pool<GlyphRun> glyphRunPool) {
        int count;
        GlyphRun truncateRun = (GlyphRun)glyphRunPool.obtain();
        fontData.getGlyphs(truncateRun, truncate, 0, truncate.length(), null);
        float truncateWidth = 0.0f;
        if (truncateRun.xAdvances.size > 0) {
            this.adjustLastGlyph(fontData, truncateRun);
            int n = truncateRun.xAdvances.size;
            for (int i = 1; i < n; ++i) {
                truncateWidth += truncateRun.xAdvances.get(i);
            }
        }
        targetWidth -= truncateWidth;
        float width = run.x;
        for (count = 0; count < run.xAdvances.size; ++count) {
            float xAdvance = run.xAdvances.get(count);
            if (!((width += xAdvance) > targetWidth)) continue;
            run.width = width - run.x - xAdvance;
            break;
        }
        if (count > 1) {
            run.glyphs.truncate(count - 1);
            run.xAdvances.truncate(count);
            this.adjustLastGlyph(fontData, run);
            if (truncateRun.xAdvances.size > 0) {
                run.xAdvances.addAll(truncateRun.xAdvances, 1, truncateRun.xAdvances.size - 1);
            }
        } else {
            run.glyphs.clear();
            run.xAdvances.clear();
            run.xAdvances.addAll(truncateRun.xAdvances);
            if (truncateRun.xAdvances.size > 0) {
                run.width += truncateRun.xAdvances.get(0);
            }
        }
        run.glyphs.addAll(truncateRun.glyphs);
        run.width += truncateWidth;
        glyphRunPool.free((Object)truncateRun);
    }

    private GlyphRun wrap(BitmapFont.BitmapFontData fontData, GlyphRun first, Pool<GlyphRun> glyphRunPool, int wrapIndex, int widthIndex) {
        int secondStart;
        int firstEnd;
        Array<BitmapFont.Glyph> glyphs2 = first.glyphs;
        int glyphCount = first.glyphs.size;
        FloatArray xAdvances2 = first.xAdvances;
        for (firstEnd = wrapIndex; firstEnd > 0 && fontData.isWhitespace((char)((BitmapFont.Glyph)glyphs2.get((int)(firstEnd - 1))).id); --firstEnd) {
        }
        for (secondStart = wrapIndex; secondStart < glyphCount && fontData.isWhitespace((char)((BitmapFont.Glyph)glyphs2.get((int)secondStart)).id); ++secondStart) {
        }
        while (widthIndex < firstEnd) {
            first.width += xAdvances2.get(widthIndex++);
        }
        int n = firstEnd + 1;
        while (widthIndex > n) {
            first.width -= xAdvances2.get(--widthIndex);
        }
        GlyphRun second = null;
        if (secondStart < glyphCount) {
            second = (GlyphRun)glyphRunPool.obtain();
            second.color.set(first.color);
            Array<BitmapFont.Glyph> glyphs1 = second.glyphs;
            glyphs1.addAll(glyphs2, 0, firstEnd);
            glyphs2.removeRange(0, secondStart - 1);
            first.glyphs = glyphs1;
            second.glyphs = glyphs2;
            FloatArray xAdvances1 = second.xAdvances;
            xAdvances1.addAll(xAdvances2, 0, firstEnd + 1);
            xAdvances2.removeRange(1, secondStart);
            xAdvances2.set(0, (float)(-((BitmapFont.Glyph)glyphs2.first()).xoffset) * fontData.scaleX - fontData.padLeft);
            first.xAdvances = xAdvances1;
            second.xAdvances = xAdvances2;
        } else {
            glyphs2.truncate(firstEnd);
            xAdvances2.truncate(firstEnd + 1);
        }
        if (firstEnd == 0) {
            glyphRunPool.free((Object)first);
            this.runs.pop();
        } else {
            this.adjustLastGlyph(fontData, first);
        }
        return second;
    }

    private void adjustLastGlyph(BitmapFont.BitmapFontData fontData, GlyphRun run) {
        BitmapFont.Glyph last = (BitmapFont.Glyph)run.glyphs.peek();
        if (last.fixedWidth) {
            return;
        }
        float width = (float)(last.width + last.xoffset) * fontData.scaleX - fontData.padRight;
        run.width += width - run.xAdvances.peek();
        run.xAdvances.set(run.xAdvances.size - 1, width);
    }

    private int parseColorMarkup(CharSequence str, int start, int end, Pool<Color> colorPool) {
        if (start == end) {
            return -1;
        }
        switch (str.charAt(start)) {
            case '#': {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) break;
                        if (i - start <= 7) {
                            int nn = 9 - (i - start);
                            for (int ii = 0; ii < nn; ++ii) {
                                colorInt <<= 4;
                            }
                            colorInt |= 0xFF;
                        }
                        Color color = (Color)colorPool.obtain();
                        this.colorStack.add((Object)color);
                        Color.rgba8888ToColor((Color)color, (int)colorInt);
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    colorInt = colorInt * 16 + (ch - 55);
                }
                return -1;
            }
            case '[': {
                return -2;
            }
            case ']': {
                if (this.colorStack.size > 1) {
                    colorPool.free((Object)((Color)this.colorStack.pop()));
                }
                return 0;
            }
        }
        int colorStart = start;
        for (int i = start + 1; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch != ']') continue;
            Color namedColor = Colors.get((String)str.subSequence(colorStart, i).toString());
            if (namedColor == null) {
                return -1;
            }
            Color color = (Color)colorPool.obtain();
            this.colorStack.add((Object)color);
            color.set(namedColor);
            return i - start;
        }
        return -1;
    }

    public void reset() {
        Pools.get(GlyphRun::new).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.width);
        buffer.append('x');
        buffer.append(this.height);
        buffer.append('\n');
        int n = this.runs.size;
        for (int i = 0; i < n; ++i) {
            buffer.append(((GlyphRun)this.runs.get(i)).toString());
            buffer.append('\n');
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public final Color color = new Color();
        public Array<BitmapFont.Glyph> glyphs = new Array();
        public FloatArray xAdvances = new FloatArray();
        public float x;
        public float y;
        public float width;

        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> glyphs = this.glyphs;
            int n = glyphs.size;
            for (int i = 0; i < n; ++i) {
                BitmapFont.Glyph g = (BitmapFont.Glyph)glyphs.get(i);
                buffer.append((char)g.id);
            }
            buffer.append(", #");
            buffer.append(this.color);
            buffer.append(", ");
            buffer.append(this.x);
            buffer.append(", ");
            buffer.append(this.y);
            buffer.append(", ");
            buffer.append(this.width);
            return buffer.toString();
        }
    }
}

