/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.g3d.decals;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import java.util.Comparator;
import net.jafama.FastMath;

public class CameraGroupStrategy
implements GroupStrategy,
Disposable {
    private static final int GROUP_OPAQUE = 0;
    private static final int GROUP_BLEND = 1;
    private final Comparator<Decal> cameraSorter;
    Pool<Array<Decal>> arrayPool = new Pool<Array<Decal>>(this, 16){

        protected Array<Decal> newObject() {
            return new Array();
        }
    };
    Array<Array<Decal>> usedArrays = new Array();
    ObjectMap<DecalMaterial, Array<Decal>> materialGroups = new ObjectMap();
    Camera camera;
    ShaderProgram shader;

    public CameraGroupStrategy(Camera camera) {
        this(camera, (o1, o2) -> {
            float dist1 = camera.position.dst(o1.getPosition());
            float dist2 = camera.position.dst(o2.getPosition());
            return (int)FastMath.signum((float)(dist2 - dist1));
        });
    }

    public CameraGroupStrategy(Camera camera, Comparator<Decal> sorter) {
        this.camera = camera;
        this.cameraSorter = sorter;
        this.createDefaultShader();
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public int decideGroup(Decal decal) {
        return decal.getMaterial().isOpaque() ? 0 : 1;
    }

    public void beforeGroup(int group, Array<Decal> contents) {
        if (group == 1) {
            Gdx.gl.glEnable(3042);
            contents.sort(this.cameraSorter);
        } else {
            int n = contents.size;
            for (int i = 0; i < n; ++i) {
                Decal decal = (Decal)contents.get(i);
                Array materialGroup = (Array)this.materialGroups.get((Object)decal.getMaterial());
                if (materialGroup == null) {
                    materialGroup = (Array)this.arrayPool.obtain();
                    materialGroup.clear();
                    this.usedArrays.add((Object)materialGroup);
                    this.materialGroups.put((Object)decal.getMaterial(), (Object)materialGroup);
                }
                materialGroup.add((Object)decal);
            }
            contents.clear();
            for (Array materialGroup : this.materialGroups.values()) {
                contents.addAll(materialGroup);
            }
            this.materialGroups.clear();
            this.arrayPool.freeAll(this.usedArrays);
            this.usedArrays.clear();
        }
    }

    public void afterGroup(int group) {
        if (group == 1) {
            Gdx.gl.glDisable(3042);
        }
    }

    public void beforeGroups() {
        Gdx.gl.glEnable(2929);
        this.shader.bind();
        this.shader.setUniformMatrix("u_projectionViewMatrix", this.camera.combined);
        this.shader.setUniformi("u_texture", 0);
    }

    public void afterGroups() {
        Gdx.gl.glDisable(2929);
    }

    private void createDefaultShader() {
        String vertexShader = "#version 330 core\nuniform mat4 u_projectionViewMatrix;\nin vec4 a_position;\nin vec4 a_color;\nin vec2 a_texCoord0;\nout vec4 v_color;\nout vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n";
        String fragmentShader = "#version 330 core\nuniform sampler2D u_texture;\nin vec4 v_color;\nin vec2 v_texCoords;\nout vec4 color;\nvoid main()\n{\n  color = v_color * texture(u_texture, v_texCoords);\n}";
        this.shader = new ShaderProgram(vertexShader, fragmentShader);
        if (!this.shader.isCompiled()) {
            throw new IllegalArgumentException("couldn't compile shader: " + this.shader.getLog());
        }
    }

    public ShaderProgram getGroupShader(int group) {
        return this.shader;
    }

    public void dispose() {
        if (this.shader != null) {
            this.shader.dispose();
        }
    }
}

