/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.MipMapGenerator;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.Logger;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import javax.imageio.ImageIO;

public class BufferedImageTextureData
implements TextureData {
    private static final Logger.Log logger = Logger.getLogger(BufferedImageTextureData.class);
    private final FileHandle file;
    private final boolean useMipMaps;
    private BufferedImage image = null;
    int width = 0;
    int height = 0;

    public BufferedImageTextureData(FileHandle file, boolean useMipMaps) {
        this.file = file;
        this.useMipMaps = useMipMaps;
    }

    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    public boolean isPrepared() {
        return this.image != null;
    }

    public void prepare() {
        if (this.image != null) {
            throw new GdxRuntimeException("Already prepared");
        }
        try {
            this.image = ImageIO.read(this.file.read());
            if (this.image != null) {
                this.width = this.image.getWidth();
                this.height = this.image.getHeight();
            } else {
                logger.error("Error loading image file: " + this.file.file().getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.error(e, "Error loading image file: " + this.file.file().getAbsolutePath());
        }
    }

    public Pixmap consumePixmap() {
        return null;
    }

    public boolean disposePixmap() {
        return false;
    }

    public void consumeCustomData(int target) {
        if (this.image == null) {
            throw new GdxRuntimeException("Call prepare() before calling consumeCompressedData()");
        }
        Pixmap pixmap = new Pixmap(this.width, this.height, Pixmap.Format.RGBA8888);
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int argb = this.image.getRGB(x, y);
                int blue = argb & 0xFF;
                int green = argb >> 8 & 0xFF;
                int red = argb >> 16 & 0xFF;
                int alpha = argb >> 24 & 0xFF;
                pixmap.setColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
                pixmap.drawPixel(x, y);
            }
        }
        Gdx.gl.glTexImage2D(target, 0, pixmap.getGLInternalFormat(), this.width, this.height, 0, pixmap.getGLFormat(), pixmap.getGLType(), (Buffer)pixmap.getPixels());
        if (this.useMipMaps()) {
            MipMapGenerator.generateMipMap((int)target, (Pixmap)pixmap, (int)this.width, (int)this.height);
        }
        pixmap.dispose();
        this.image = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Pixmap.Format getFormat() {
        return Pixmap.Format.RGBA8888;
    }

    public boolean useMipMaps() {
        return this.useMipMaps;
    }

    public boolean isManaged() {
        return true;
    }
}

