/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.GLVersion;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class ShortTextureData
implements TextureData {
    int width = 0;
    int height = 0;
    int internalFormat;
    int format;
    int type;
    boolean isGpuOnly;
    boolean useMipMaps;
    boolean isPrepared = false;
    ShortBuffer buffer;

    public ShortTextureData(int w, int h, int internalFormat, int format, int type, boolean useMipMaps, boolean isGpuOnly) {
        this.width = w;
        this.height = h;
        this.internalFormat = internalFormat;
        this.format = format;
        this.type = type;
        this.useMipMaps = useMipMaps;
        this.isGpuOnly = isGpuOnly;
    }

    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void prepare() {
        if (this.isPrepared) {
            throw new GdxRuntimeException("Already prepared");
        }
        if (!this.isGpuOnly) {
            int amountOfShorts = 0;
            if (Gdx.graphics.getGLVersion().getType().equals((Object)GLVersion.Type.OpenGL)) {
                if (this.internalFormat == 34842 || this.internalFormat == 36232 || this.internalFormat == 36214) {
                    amountOfShorts = 4;
                }
                if (this.internalFormat == 34843 || this.internalFormat == 36233 || this.internalFormat == 36215) {
                    amountOfShorts = 3;
                }
                if (this.internalFormat == 33327 || this.internalFormat == 33337 || this.internalFormat == 33338) {
                    amountOfShorts = 2;
                }
                if (this.internalFormat == 33325 || this.internalFormat == 33331 || this.internalFormat == 33332) {
                    amountOfShorts = 1;
                }
            }
            this.buffer = BufferUtils.newShortBuffer((int)(this.width * this.height * amountOfShorts));
        }
        this.isPrepared = true;
    }

    public void consumeCustomData(int target) {
        if (!Gdx.graphics.isGL30Available() && !Gdx.graphics.supportsExtension("GL_ARB_texture_float")) {
            throw new GdxRuntimeException("Extension GL_ARB_texture_float not supported!");
        }
        Gdx.gl.glPixelStorei(3317, 1);
        if (this.useMipMaps()) {
            if (Gdx.graphics.supportsExtension("GL_ARB_framebuffer_object") || Gdx.graphics.supportsExtension("GL_EXT_framebuffer_object") || Gdx.gl20.getClass().getName().equals("com.badlogic.gdx.backends.lwjgl3.Lwjgl3GLES20") || Gdx.gl30 != null) {
                Gdx.gl.glTexImage2D(target, 0, this.internalFormat, this.width, this.height, 0, this.format, this.type, (Buffer)this.buffer);
                Gdx.gl20.glGenerateMipmap(target);
            } else {
                this.generateMipMapCPU(target, this.width, this.height);
            }
        } else {
            Gdx.gl.glTexImage2D(target, 0, this.internalFormat, this.width, this.height, 0, this.format, this.type, (Buffer)this.buffer);
        }
    }

    private void generateMipMapCPU(int target, int textureWidth, int textureHeight) {
        Gdx.gl.glTexImage2D(target, 0, this.internalFormat, this.width, this.height, 0, this.format, this.type, (Buffer)this.buffer);
        if (Gdx.gl20 == null && textureWidth != textureHeight) {
            throw new GdxRuntimeException("texture width and height must be square when using mipmapping.");
        }
        int currentWidth = this.width / 2;
        int currentHeight = this.height / 2;
        int level = 1;
        while (currentWidth > 0 && currentHeight > 0) {
            Gdx.gl.glTexImage2D(target, level, this.internalFormat, this.width, this.height, 0, this.format, this.type, (Buffer)this.buffer);
            currentWidth /= 2;
            currentHeight /= 2;
            ++level;
        }
    }

    public Pixmap consumePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    public boolean disposePixmap() {
        throw new GdxRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Pixmap.Format getFormat() {
        return Pixmap.Format.RGBA8888;
    }

    public boolean useMipMaps() {
        return true;
    }

    public boolean isManaged() {
        return false;
    }

    public ShortBuffer getBuffer() {
        return this.buffer;
    }
}

