/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.g2d.BitmapFont;
import gaiasky.util.gdx.g2d.TextureAtlas;
import gaiasky.util.gdx.g2d.TextureRegion;
import gaiasky.util.gdx.loader.OwnTextureLoader;

public class BitmapFontLoader
extends AsynchronousAssetLoader<BitmapFont, BitmapFontParameter> {
    BitmapFont.BitmapFontData data;

    public BitmapFontLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, BitmapFontParameter parameter) {
        Array deps = new Array();
        if (parameter != null && parameter.bitmapFontData != null) {
            this.data = parameter.bitmapFontData;
            return deps;
        }
        this.data = new BitmapFont.BitmapFontData(file, parameter != null && parameter.flip);
        if (parameter != null && parameter.atlasName != null) {
            deps.add((Object)new AssetDescriptor(parameter.atlasName, TextureAtlas.class));
        } else {
            for (int i = 0; i < this.data.getImagePaths().length; ++i) {
                String path = this.data.getImagePath(i);
                FileHandle resolved = this.resolve(path);
                OwnTextureLoader.OwnTextureParameter textureParams = new OwnTextureLoader.OwnTextureParameter();
                if (parameter != null) {
                    textureParams.genMipMaps = parameter.genMipMaps;
                    textureParams.minFilter = parameter.minFilter;
                    textureParams.magFilter = parameter.magFilter;
                }
                AssetDescriptor descriptor = new AssetDescriptor(resolved, Texture.class, (AssetLoaderParameters)textureParams);
                deps.add((Object)descriptor);
            }
        }
        return deps;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
    }

    public BitmapFont loadSync(AssetManager manager, String fileName, FileHandle file, BitmapFontParameter parameter) {
        if (parameter != null && parameter.atlasName != null) {
            String name;
            TextureAtlas atlas = (TextureAtlas)manager.get(parameter.atlasName, TextureAtlas.class);
            TextureAtlas.AtlasRegion region = atlas.findRegion(name = file.sibling(this.data.imagePaths[0]).nameWithoutExtension());
            if (region == null) {
                throw new GdxRuntimeException("Could not find font region " + name + " in atlas " + parameter.atlasName);
            }
            return new BitmapFont(file, region);
        }
        int n = this.data.getImagePaths().length;
        Array regs = new Array(n);
        for (int i = 0; i < n; ++i) {
            regs.add((Object)new TextureRegion((Texture)manager.get(this.data.getImagePath(i), Texture.class)));
        }
        return new BitmapFont(this.data, (Array<TextureRegion>)regs, true);
    }

    public static class BitmapFontParameter
    extends AssetLoaderParameters<BitmapFont> {
        public boolean flip = false;
        public boolean genMipMaps = false;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public BitmapFont.BitmapFontData bitmapFontData = null;
        public String atlasName = null;
    }
}

