/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.KTXTextureData;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.OwnCubemap;

public class CubemapLoader
extends AsynchronousAssetLoader<OwnCubemap, CubemapParameter> {
    CubemapLoaderInfo info = new CubemapLoaderInfo();

    public CubemapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, CubemapParameter parameter) {
        this.info.filename = fileName;
        if (parameter == null || parameter.cubemapData == null) {
            Pixmap.Format format = null;
            boolean genMipMaps = false;
            this.info.cubemap = null;
            if (parameter != null) {
                format = parameter.format;
                this.info.cubemap = parameter.cubemap;
            }
            if (fileName.contains(".ktx") || fileName.contains(".zktx")) {
                this.info.data = new KTXTextureData(file, genMipMaps);
            }
        } else {
            this.info.data = parameter.cubemapData;
            this.info.cubemap = parameter.cubemap;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    public OwnCubemap loadSync(AssetManager manager, String fileName, FileHandle file, CubemapParameter parameter) {
        if (this.info == null) {
            return null;
        }
        OwnCubemap cubemap = this.info.cubemap;
        if (cubemap != null) {
            cubemap.load(this.info.data);
        } else {
            cubemap = new OwnCubemap(this.info.data);
        }
        if (parameter != null) {
            cubemap.setFilter(parameter.minFilter, parameter.magFilter);
            cubemap.setWrap(parameter.wrapU, parameter.wrapV);
        }
        return cubemap;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, CubemapParameter parameter) {
        return null;
    }

    public static class CubemapLoaderInfo {
        String filename;
        CubemapData data;
        OwnCubemap cubemap;
    }

    public static class CubemapParameter
    extends AssetLoaderParameters<OwnCubemap> {
        public Pixmap.Format format = null;
        public OwnCubemap cubemap = null;
        public CubemapData cubemapData = null;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter magFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureWrap wrapU = Texture.TextureWrap.ClampToEdge;
        public Texture.TextureWrap wrapV = Texture.TextureWrap.ClampToEdge;
    }
}

