/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.data.IntModelData;
import gaiasky.util.gdx.model.data.OwnModelMaterial;
import java.util.Iterator;

public abstract class IntModelLoader<P extends IntModelParameters>
extends AsynchronousAssetLoader<IntModel, P> {
    protected final Array<ObjectMap.Entry<String, IntModelData>> items = new Array();
    protected IntModelParameters defaultParameters = new IntModelParameters();

    protected IntModelLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public abstract IntModelData loadModelData(FileHandle var1, P var2);

    public IntModelData loadModelData(FileHandle fileHandle) {
        return this.loadModelData(fileHandle, null);
    }

    public IntModel loadModel(FileHandle fileHandle, TextureProvider textureProvider, P parameters) {
        IntModelData data = this.loadModelData(fileHandle, parameters);
        return data == null ? null : new IntModel(data, textureProvider);
    }

    public IntModel loadModel(FileHandle fileHandle, P parameters) {
        return this.loadModel(fileHandle, (TextureProvider)new TextureProvider.FileTextureProvider(), parameters);
    }

    public IntModel loadModel(FileHandle fileHandle, TextureProvider textureProvider) {
        return this.loadModel(fileHandle, textureProvider, null);
    }

    public IntModel loadModel(FileHandle fileHandle) {
        if (fileHandle.exists()) {
            return this.loadModel(fileHandle, (TextureProvider)new TextureProvider.FileTextureProvider(), null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, P parameters) {
        Array deps = new Array();
        IntModelData data = this.loadModelData(file, parameters);
        if (data == null) {
            return deps;
        }
        ObjectMap.Entry item = new ObjectMap.Entry();
        item.key = fileName;
        item.value = data;
        Array<ObjectMap.Entry<String, IntModelData>> array = this.items;
        synchronized (array) {
            this.items.add((Object)item);
        }
        OwnTextureLoader.OwnTextureParameter textureParameter = parameters != null ? ((IntModelParameters)((Object)parameters)).textureParameter : this.defaultParameters.textureParameter;
        for (OwnModelMaterial modelMaterial : data.materials) {
            if (modelMaterial.textures == null) continue;
            for (ModelTexture modelTexture : modelMaterial.textures) {
                deps.add((Object)new AssetDescriptor(modelTexture.fileName, Texture.class, (AssetLoaderParameters)textureParameter));
            }
        }
        return deps;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, P parameters) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntModel loadSync(AssetManager manager, String fileName, FileHandle file, P parameters) {
        IntModelData data = null;
        Array<ObjectMap.Entry<String, IntModelData>> array = this.items;
        synchronized (array) {
            for (int i = 0; i < this.items.size; ++i) {
                if (!((String)((ObjectMap.Entry)this.items.get((int)i)).key).equals(fileName)) continue;
                data = (IntModelData)((ObjectMap.Entry)this.items.get((int)i)).value;
                this.items.removeIndex(i);
            }
        }
        if (data == null) {
            return null;
        }
        IntModel result = new IntModel(data, (TextureProvider)new TextureProvider.AssetTextureProvider(manager));
        Iterator<Disposable> disposables = result.getManagedDisposables().iterator();
        while (disposables.hasNext()) {
            Disposable disposable = disposables.next();
            if (!(disposable instanceof Texture)) continue;
            disposables.remove();
        }
        data = null;
        return result;
    }

    public static class IntModelParameters
    extends AssetLoaderParameters<IntModel> {
        public OwnTextureLoader.OwnTextureParameter textureParameter = new OwnTextureLoader.OwnTextureParameter();

        public IntModelParameters() {
            this.textureParameter.minFilter = this.textureParameter.magFilter = Texture.TextureFilter.Linear;
            this.textureParameter.wrapU = this.textureParameter.wrapV = Texture.TextureWrap.Repeat;
        }
    }
}

