/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Logger;
import gaiasky.util.color.ColorUtils;
import gaiasky.util.gdx.model.data.OwnModelMaterial;
import gaiasky.util.gdx.model.data.OwnModelTexture;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

public class OwnMtlLoader {
    private static final Logger.Log logger = Logger.getLogger(OwnMtlLoader.class);
    public Array<OwnModelMaterial> materials = new Array();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(FileHandle file) {
        String curMatName = "default";
        Color difcolor = Color.WHITE;
        Color speccolor = Color.WHITE;
        Color emicolor = Color.WHITE;
        Color metcolor = Color.BLACK;
        float opacity = 1.0f;
        float shininess = 0.0f;
        String texDiffuseFilename = null;
        String texEmissiveFilename = null;
        String texNormalFilename = null;
        String texSpecularFilename = null;
        String texRoughnessFilename = null;
        String texMetallicFilename = null;
        if (file == null || !file.exists()) {
            logger.error("ERROR: Material file not found: " + file.name());
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.read()), 4096);
        try {
            String line;
            block36: while ((line = reader.readLine()) != null) {
                String key;
                String[] tokens;
                if (!line.isEmpty() && line.charAt(0) == '\t') {
                    line = line.substring(1).trim();
                }
                if ((tokens = line.split("\\s+"))[0].isEmpty() || tokens[0].charAt(0) == '#') continue;
                switch (key = tokens[0].toLowerCase(Locale.ROOT)) {
                    case "newmtl": {
                        this.addCurrentMat(curMatName, difcolor, speccolor, emicolor, metcolor, opacity, shininess, texDiffuseFilename, texEmissiveFilename, texNormalFilename, texSpecularFilename, texRoughnessFilename, texMetallicFilename, this.materials);
                        if (tokens.length > 1) {
                            curMatName = tokens[1];
                            curMatName = curMatName.replace('.', '_');
                        } else {
                            curMatName = "default";
                        }
                        difcolor = Color.WHITE;
                        speccolor = Color.WHITE;
                        emicolor = Color.WHITE;
                        metcolor = Color.BLACK;
                        texDiffuseFilename = null;
                        texEmissiveFilename = null;
                        texNormalFilename = null;
                        texRoughnessFilename = null;
                        texMetallicFilename = null;
                        opacity = 1.0f;
                        shininess = 0.0f;
                        break;
                    }
                    case "kd": 
                    case "ks": 
                    case "ke": 
                    case "kr": 
                    case "km": {
                        float r = Float.parseFloat(tokens[1]);
                        float g = Float.parseFloat(tokens[2]);
                        float b = Float.parseFloat(tokens[3]);
                        float a = 1.0f;
                        if (tokens.length > 4) {
                            a = Float.parseFloat(tokens[4]);
                        }
                        if (tokens[0].equalsIgnoreCase("kd")) {
                            difcolor = new Color();
                            difcolor.set(r, g, b, a);
                            break;
                        }
                        if (tokens[0].equalsIgnoreCase("ks")) {
                            speccolor = new Color();
                            speccolor.set(r, g, b, a);
                            break;
                        }
                        if (tokens[0].equalsIgnoreCase("ke")) {
                            emicolor = new Color();
                            emicolor.set(r, g, b, a);
                            break;
                        }
                        if (!tokens[0].equalsIgnoreCase("kr") && !tokens[0].equalsIgnoreCase("km")) continue block36;
                        metcolor = new Color();
                        metcolor.set(r, g, b, a);
                        break;
                    }
                    case "tr": 
                    case "d": {
                        opacity = Float.parseFloat(tokens[1]);
                        break;
                    }
                    case "ns": {
                        shininess = MathUtils.clamp((float)Float.parseFloat(tokens[1]), (float)0.0f, (float)300.0f) / 300.0f;
                        break;
                    }
                    case "map_kd": {
                        texDiffuseFilename = file.parent().child(tokens[1]).path();
                        break;
                    }
                    case "map_ke": {
                        texEmissiveFilename = file.parent().child(tokens[1]).path();
                        break;
                    }
                    case "map_kn": 
                    case "map_bump": 
                    case "norm": {
                        texNormalFilename = file.parent().child(tokens[1]).path();
                        break;
                    }
                    case "map_ks": {
                        texSpecularFilename = file.parent().child(tokens[1]).path();
                        break;
                    }
                    case "map_kr": 
                    case "map_km": 
                    case "map_pm": {
                        texMetallicFilename = file.parent().child(tokens[1]).path();
                        break;
                    }
                    case "map_pr": 
                    case "map_ns": {
                        texRoughnessFilename = file.parent().child(tokens[1]).path();
                        continue block36;
                    }
                }
            }
            reader.close();
        }
        catch (IOException e) {
            return;
        }
        this.addCurrentMat(curMatName, difcolor, speccolor, emicolor, metcolor, opacity, shininess, texDiffuseFilename, texEmissiveFilename, texNormalFilename, texSpecularFilename, texRoughnessFilename, texMetallicFilename, this.materials);
    }

    private void addCurrentMat(String curMatName, Color difcolor, Color speccolor, Color emicolor, Color metcolor, float opacity, float shininess, String texDiffuseFilename, String texEmissiveFilename, String texNormalFilename, String texSpecularFilename, String texRoughnessFilename, String texMetallicFilename, Array<OwnModelMaterial> materials) {
        OwnModelTexture tex;
        OwnModelMaterial mat = new OwnModelMaterial();
        mat.id = curMatName;
        mat.diffuse = new Color(difcolor);
        if (!ColorUtils.isZero(speccolor)) {
            mat.specular = new Color(speccolor);
        }
        if (!ColorUtils.isZero(emicolor)) {
            mat.emissive = new Color(emicolor);
        }
        if (!ColorUtils.isZero(metcolor)) {
            mat.metallic = new Color(metcolor);
        }
        mat.opacity = opacity;
        mat.shininess = shininess;
        if (texDiffuseFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 2;
            tex.fileName = texDiffuseFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        if (texEmissiveFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 3;
            tex.fileName = texEmissiveFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        if (texNormalFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 7;
            tex.fileName = texNormalFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        if (texSpecularFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 5;
            tex.fileName = texSpecularFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        if (texRoughnessFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 13;
            tex.fileName = texRoughnessFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        if (texMetallicFilename != null) {
            tex = new OwnModelTexture();
            tex.usage = 11;
            tex.fileName = texMetallicFilename;
            if (mat.textures == null) {
                mat.textures = new Array(1);
            }
            mat.textures.add((Object)tex);
        }
        materials.add((Object)mat);
    }

    public OwnModelMaterial getMaterial(String name) {
        for (OwnModelMaterial m : this.materials) {
            if (!m.id.equals(name)) continue;
            return m;
        }
        OwnModelMaterial mat = new OwnModelMaterial();
        mat.id = name;
        mat.diffuse = new Color(Color.WHITE);
        this.materials.add((Object)mat);
        return mat;
    }
}

