/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import gaiasky.util.gdx.loader.IntModelLoader;
import gaiasky.util.gdx.loader.OwnMtlLoader;
import gaiasky.util.gdx.loader.is.InputStreamProvider;
import gaiasky.util.gdx.loader.is.RegularInputStreamProvider;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.data.IntModelData;
import gaiasky.util.gdx.model.data.IntModelMesh;
import gaiasky.util.gdx.model.data.IntModelMeshPart;
import gaiasky.util.gdx.model.data.IntModelNode;
import gaiasky.util.gdx.model.data.OwnModelMaterial;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;

public class OwnObjLoader
extends IntModelLoader<ObjLoaderParameters> {
    public static boolean logWarning = false;
    final FloatArray verts = new FloatArray(300);
    final FloatArray norms = new FloatArray(300);
    final FloatArray uvs = new FloatArray(200);
    final Array<Group> groups = new Array(10);
    final InputStreamProvider isp;

    public OwnObjLoader() {
        this(new RegularInputStreamProvider(), null);
    }

    public OwnObjLoader(InputStreamProvider isp, FileHandleResolver resolver) {
        super(resolver);
        this.isp = isp;
    }

    @Override
    public IntModel loadModel(FileHandle fileHandle, boolean flipV) {
        return this.loadModel(fileHandle, new ObjLoaderParameters(flipV));
    }

    @Override
    public IntModelData loadModelData(FileHandle file, ObjLoaderParameters parameters) {
        return this.loadModelData(file, parameters != null && parameters.flipV);
    }

    @Override
    protected IntModelData loadModelData(FileHandle file, boolean flipV) {
        if (logWarning) {
            Gdx.app.error(OwnObjLoader.class.getSimpleName(), "Wavefront (OBJ) is not fully supported, consult the documentation for more information");
        }
        OwnMtlLoader materialLoader = new OwnMtlLoader();
        Group activeGroup = new Group("default");
        this.groups.add((Object)activeGroup);
        int id = 0;
        try {
            String[] tokens;
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.isp.getInputStream(file)), 4096);
            while ((line = reader.readLine()) != null && (tokens = line.split("\\s+")).length >= 1) {
                char firstChar;
                if (tokens[0].isEmpty() || (firstChar = tokens[0].toLowerCase(Locale.ROOT).charAt(0)) == '#') continue;
                if (firstChar == 'v') {
                    if (tokens[0].length() == 1) {
                        this.verts.add(Float.parseFloat(tokens[1]));
                        this.verts.add(Float.parseFloat(tokens[2]));
                        this.verts.add(Float.parseFloat(tokens[3]));
                        continue;
                    }
                    if (tokens[0].charAt(1) == 'n') {
                        this.norms.add(Float.parseFloat(tokens[1]));
                        this.norms.add(Float.parseFloat(tokens[2]));
                        this.norms.add(Float.parseFloat(tokens[3]));
                        continue;
                    }
                    if (tokens[0].charAt(1) != 't') continue;
                    this.uvs.add(Float.parseFloat(tokens[1]));
                    this.uvs.add(flipV ? Float.parseFloat(tokens[2]) : 1.0f - Float.parseFloat(tokens[2]));
                    continue;
                }
                if (firstChar == 'f') {
                    IntArray faces = activeGroup.faces;
                    for (int i = 1; i < tokens.length - 2; --i) {
                        String[] parts = tokens[1].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            if (i == 1) {
                                activeGroup.hasNorms = true;
                            }
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            if (i == 1) {
                                activeGroup.hasUVs = true;
                            }
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        parts = tokens[++i].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        parts = tokens[++i].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && !parts[1].isEmpty()) {
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        ++activeGroup.numFaces;
                    }
                    continue;
                }
                if (firstChar == 'o' || firstChar == 'g') {
                    if (tokens.length > 1) {
                        activeGroup = this.setActiveGroup(tokens[1]);
                        continue;
                    }
                    activeGroup = this.setActiveGroup("default");
                    continue;
                }
                if (tokens[0].equals("mtllib")) {
                    materialLoader.load(file.parent().child(tokens[1]));
                    continue;
                }
                if (!tokens[0].equals("usemtl")) continue;
                if (tokens.length == 1) {
                    activeGroup.materialName = "default";
                    continue;
                }
                activeGroup.materialName = tokens[1].replace('.', '_');
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        for (int i = 0; i < this.groups.size; ++i) {
            if (((Group)this.groups.get((int)i)).numFaces >= 1) continue;
            this.groups.removeIndex(i);
            --i;
        }
        if (this.groups.size < 1) {
            return null;
        }
        int numGroups = this.groups.size;
        IntModelData data = new IntModelData();
        for (int g = 0; g < numGroups; ++g) {
            Group group = (Group)this.groups.get(g);
            IntArray faces = group.faces;
            int numElements = faces.size;
            int numFaces = group.numFaces;
            boolean hasNorms = group.hasNorms;
            boolean hasUVs = group.hasUVs;
            float[] finalVerts = new float[numFaces * 3 * (3 + (hasNorms ? 3 : 0) + (hasUVs ? 2 : 0))];
            int i = 0;
            int vi = 0;
            while (i < numElements) {
                int vertIndex = faces.get(i++) * 3;
                finalVerts[vi++] = this.verts.get(vertIndex++);
                finalVerts[vi++] = this.verts.get(vertIndex++);
                finalVerts[vi++] = this.verts.get(vertIndex);
                if (hasNorms) {
                    int normIndex = faces.get(i++) * 3;
                    finalVerts[vi++] = this.norms.get(normIndex++);
                    finalVerts[vi++] = this.norms.get(normIndex++);
                    finalVerts[vi++] = this.norms.get(normIndex);
                }
                if (!hasUVs) continue;
                int uvIndex = faces.get(i++) * 2;
                finalVerts[vi++] = this.uvs.get(uvIndex++);
                finalVerts[vi++] = this.uvs.get(uvIndex);
            }
            int numIndices = numFaces * 3 >= Integer.MAX_VALUE ? 0 : numFaces * 3;
            int[] finalIndices = new int[numIndices];
            if (numIndices > 0) {
                for (int i2 = 0; i2 < numIndices; ++i2) {
                    finalIndices[i2] = i2;
                }
            }
            Array attributes = new Array();
            attributes.add((Object)new VertexAttribute(1, 3, "a_position"));
            if (hasNorms) {
                attributes.add((Object)new VertexAttribute(8, 3, "a_normal"));
            }
            if (hasUVs) {
                attributes.add((Object)new VertexAttribute(16, 2, "a_texCoord0"));
            }
            String stringId = Integer.toString(++id);
            Object nodeId = "default".equals(group.name) ? "node" + stringId : group.name;
            Object meshId = "default".equals(group.name) ? "mesh" + stringId : group.name;
            Object partId = "default".equals(group.name) ? "part" + stringId : group.name;
            IntModelNode node = new IntModelNode();
            node.id = nodeId;
            node.meshId = meshId;
            node.scale = new Vector3(1.0f, 1.0f, 1.0f);
            node.translation = new Vector3();
            node.rotation = new Quaternion();
            ModelNodePart pm = new ModelNodePart();
            pm.meshPartId = partId;
            pm.materialId = group.materialName;
            node.parts = new ModelNodePart[]{pm};
            IntModelMeshPart part = new IntModelMeshPart();
            part.id = partId;
            part.indices = finalIndices;
            part.primitiveType = 4;
            IntModelMesh mesh = new IntModelMesh();
            mesh.id = meshId;
            mesh.attributes = (VertexAttribute[])attributes.toArray(VertexAttribute.class);
            mesh.vertices = finalVerts;
            mesh.parts = new IntModelMeshPart[]{part};
            data.nodes.add((Object)node);
            data.meshes.add((Object)mesh);
            OwnModelMaterial mm = materialLoader.getMaterial(group.materialName);
            data.materials.add((Object)mm);
        }
        if (this.verts.size > 0) {
            this.verts.clear();
        }
        if (this.norms.size > 0) {
            this.norms.clear();
        }
        if (this.uvs.size > 0) {
            this.uvs.clear();
        }
        if (this.groups.size > 0) {
            this.groups.clear();
        }
        return data;
    }

    private Group setActiveGroup(String name) {
        for (Group group : this.groups) {
            if (!group.name.equals(name)) continue;
            return group;
        }
        Group group = new Group(name);
        this.groups.add((Object)group);
        return group;
    }

    private int getIndex(String index, int size) {
        if (index == null || index.isEmpty()) {
            return 0;
        }
        int idx = Integer.parseInt(index);
        if (idx < 0) {
            return size + idx;
        }
        return idx - 1;
    }

    public static class ObjLoaderParameters
    extends IntModelLoader.IntModelParameters {
        public boolean flipV;

        public ObjLoaderParameters() {
        }

        public ObjLoaderParameters(boolean flipV) {
            this.flipV = flipV;
        }
    }

    private static class Group {
        final String name;
        String materialName;
        IntArray faces;
        int numFaces;
        boolean hasNorms;
        boolean hasUVs;

        Group(String name) {
            this.name = name;
            this.faces = new IntArray(200);
            this.numFaces = 0;
            this.materialName = "default";
        }
    }
}

