/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import gaiasky.util.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class OwnPixmapLoader
extends PixmapLoader {
    private static final Logger.Log logger = Logger.getLogger(OwnPixmapLoader.class);
    Pixmap pixmap;

    public OwnPixmapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, PixmapLoader.PixmapParameter parameter) {
        if (file.extension().equalsIgnoreCase("jxl")) {
            try {
                BufferedImage image = ImageIO.read(file.read());
                int w = image.getWidth();
                int h = image.getHeight();
                this.pixmap = new Pixmap(w, h, Pixmap.Format.RGBA8888);
                for (int x = 0; x < w; ++x) {
                    for (int y = 0; y < h; ++y) {
                        int argb = image.getRGB(x, y);
                        int blue = argb & 0xFF;
                        int green = argb >> 8 & 0xFF;
                        int red = argb >> 16 & 0xFF;
                        int alpha = argb >> 24 & 0xFF;
                        this.pixmap.setColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
                        this.pixmap.drawPixel(x, y);
                    }
                }
            }
            catch (IOException e) {
                logger.error(e, "Error loading JPEG-XL image.");
            }
        } else {
            super.loadAsync(manager, fileName, file, parameter);
        }
    }

    public Pixmap loadSync(AssetManager manager, String fileName, FileHandle file, PixmapLoader.PixmapParameter parameter) {
        if (this.pixmap != null) {
            Pixmap pixmap = this.pixmap;
            this.pixmap = null;
            return pixmap;
        }
        return super.loadSync(manager, fileName, file, parameter);
    }
}

