/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.ETC1TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.KTXTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.graphics.BufferedImageTextureData;
import gaiasky.util.gdx.loader.OwnPixmapLoader;

public class OwnTextureLoader
extends AsynchronousAssetLoader<Texture, TextureLoader.TextureParameter> {
    TextureLoaderInfo info = new TextureLoaderInfo();

    public OwnTextureLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        this.info.filename = fileName;
        if (parameter == null || parameter.textureData == null) {
            Pixmap.Format format = null;
            boolean genMipMaps = false;
            boolean pixmapBacked = false;
            this.info.texture = null;
            if (parameter != null) {
                format = parameter.format;
                genMipMaps = parameter.genMipMaps;
                if (parameter instanceof OwnTextureParameter) {
                    pixmapBacked = ((OwnTextureParameter)parameter).pixmapBacked;
                }
                this.info.texture = parameter.texture;
            }
            this.info.data = Factory.loadFromFile(file, format, genMipMaps, pixmapBacked);
        } else {
            this.info.data = parameter.textureData;
            this.info.texture = parameter.texture;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    public void unloadAsync(AssetManager manager, String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        if (parameter.texture != null) {
            parameter.texture.dispose();
        }
        if (parameter.textureData != null) {
            parameter.textureData.disposePixmap();
        }
    }

    public Texture loadSync(AssetManager manager, String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        if (this.info == null) {
            return null;
        }
        Texture texture = this.info.texture;
        if (texture != null) {
            texture.load(this.info.data);
        } else {
            try {
                texture = new Texture(this.info.data);
            }
            catch (Exception e) {
                return null;
            }
        }
        if (parameter != null) {
            texture.setFilter(parameter.minFilter, parameter.magFilter);
            texture.setWrap(parameter.wrapU, parameter.wrapV);
        }
        return texture;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        return null;
    }

    public static class TextureLoaderInfo {
        String filename;
        TextureData data;
        Texture texture;
    }

    public static class OwnTextureParameter
    extends TextureLoader.TextureParameter {
        public boolean pixmapBacked = false;
    }

    public static class Factory {
        public static TextureData loadFromFile(FileHandle file, boolean useMipMaps) {
            return Factory.loadFromFile(file, null, useMipMaps, false);
        }

        private static TextureData loadFromFile(FileHandle file, Pixmap.Format format, boolean useMipMaps, boolean pixmapBacked) {
            if (file == null) {
                return null;
            }
            if (file.name().endsWith(".cim")) {
                return new FileTextureData(file, PixmapIO.readCIM((FileHandle)file), format, useMipMaps);
            }
            if (file.name().endsWith(".etc1")) {
                return new ETC1TextureData(file, useMipMaps);
            }
            if (file.name().endsWith(".ktx") || file.name().endsWith(".zktx")) {
                return new KTXTextureData(file, useMipMaps);
            }
            if (pixmapBacked) {
                return new PixmapTextureData(Factory.loadPixmap(file), format, useMipMaps, false, false);
            }
            if (file.name().endsWith(".jxl")) {
                return new BufferedImageTextureData(file, useMipMaps);
            }
            return new FileTextureData(file, Factory.loadPixmap(file), format, useMipMaps);
        }

        private static Pixmap loadPixmap(FileHandle file) {
            OwnPixmapLoader pixLoader = new OwnPixmapLoader(null);
            pixLoader.loadAsync(null, file.name(), file, new PixmapLoader.PixmapParameter());
            return pixLoader.loadSync((AssetManager)null, (String)null, (FileHandle)null, (PixmapLoader.PixmapParameter)null);
        }
    }
}

