/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Logger;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.PFMReader;

public class PFMDataLoader
extends AsynchronousAssetLoader<PFMData, PFMDataParameter> {
    private static final Logger.Log logger = Logger.getLogger(PFMDataLoader.class);
    PFMDataInfo info = new PFMDataInfo();

    public PFMDataLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, PFMDataParameter parameter) {
        return null;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, PFMDataParameter parameter) {
        this.info.filename = fileName;
        logger.info("Loading PFM: " + file.path());
        this.info.data = PFMReader.readPFMData(file, false, parameter.invert);
    }

    public PFMData loadSync(AssetManager manager, String fileName, FileHandle file, PFMDataParameter parameter) {
        if (this.info == null) {
            return null;
        }
        return this.info.data;
    }

    public static class PFMDataInfo {
        String filename;
        PFMData data;
    }

    public static class PFMDataParameter
    extends AssetLoaderParameters<PFMData> {
        public PFMData data = null;
        public boolean invert = false;
    }
}

