/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FloatTextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.Logger;
import gaiasky.util.gdx.loader.PFMData;
import gaiasky.util.gdx.loader.PortableFloatMap;
import gaiasky.util.math.MathUtilsDouble;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.jafama.FastMath;

public class PFMReader {
    private static final Logger.Log logger = Logger.getLogger(PFMReader.class);

    public static TextureData readPFMTextureData(FileHandle file, boolean invert) {
        try {
            PortableFloatMap pfm = new PortableFloatMap(file.file());
            float[] data = pfm.pixels;
            int width = pfm.width;
            int height = pfm.height;
            if (invert) {
                data = PFMReader.invertWarp(data, width, height);
            }
            FloatTextureData td = new FloatTextureData(width, height, 34843, 6407, 5126, false);
            td.prepare();
            FloatBuffer buff = td.getBuffer();
            buff.put(data);
            FloatTextureData floatTextureData = td;
            return floatTextureData;
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't read PFM file '" + String.valueOf(file) + "'", (Throwable)e);
        }
    }

    public static PFMData readPFMData(FileHandle file, boolean normalize, boolean invert) {
        try {
            PortableFloatMap pfm = new PortableFloatMap(file.file());
            float[] data = pfm.pixels;
            int width = pfm.width;
            int height = pfm.height;
            if (invert) {
                data = PFMReader.invertWarp(data, width, height);
            } else if (normalize) {
                for (int i = 0; i < data.length; ++i) {
                    data[i] = (float)PFMReader.nor(data[i], 0.0, 1.0);
                }
            }
            return new PFMData(data, width, height);
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't read PFM file '" + String.valueOf(file) + "'", (Throwable)e);
        }
    }

    public static void writePFMFile(Path file, boolean grayscale, boolean bigEndian, PFMData data) {
        PortableFloatMap pfm = new PortableFloatMap();
        pfm.bigEndian = bigEndian;
        pfm.mode = grayscale ? PortableFloatMap.Mode.GRAYSCALE : PortableFloatMap.Mode.COLOR;
        pfm.pixels = data.data;
        pfm.width = data.width;
        pfm.height = data.height;
        if (Files.notExists(file, new LinkOption[0])) {
            try {
                pfm.write(file.toFile());
            }
            catch (IOException e) {
                throw new GdxRuntimeException("Error writing PFM file", (Throwable)e);
            }
        }
    }

    public static Pixmap readPFMPixmap(FileHandle file, boolean invert) {
        try {
            PortableFloatMap pfm = new PortableFloatMap(file.file());
            float[] data = pfm.pixels;
            int width = pfm.width;
            int height = pfm.height;
            if (invert) {
                data = PFMReader.invertWarp(data, width, height);
            }
            int totalSize = pfm.pixels.length;
            Pixmap.Format format = Pixmap.Format.RGB888;
            Pixmap pixmap = new Pixmap(width, height, format);
            ByteBuffer pixelBuf = pixmap.getPixels();
            pixelBuf.position(0);
            pixelBuf.limit(pixelBuf.capacity());
            for (int i = 0; i < totalSize; ++i) {
                byte b;
                float f = data[i];
                if (Float.isNaN(f)) {
                    b = 0;
                } else {
                    f = (float)((invert ? (double)f : PFMReader.nor(f)) * 255.0);
                    b = (byte)f;
                }
                pixelBuf.put(b);
            }
            pixelBuf.position(0);
            pixelBuf.limit(pixelBuf.capacity());
            Pixmap pixmap2 = pixmap;
            return pixmap2;
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't read PFM file '" + String.valueOf(file) + "'", (Throwable)e);
        }
    }

    private static double nor(double value) {
        return MathUtilsDouble.clamp(value + 0.5, 0.0, 1.0);
    }

    private static double nor(double value, double min, double max) {
        double val = MathUtilsDouble.clamp(value, min, max);
        return (val - min) / (max - min);
    }

    public static PFMData constructPFMData(int width, int height, Function<Float, Float> fx, Function<Float, Float> fy) {
        try {
            float[] data = PFMReader.generateMapping(width, height, fx, fy);
            PFMData pFMData = new PFMData(data, width, height);
            return pFMData;
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't construct PFM data", (Throwable)e);
        }
    }

    public static PFMData constructPFMData(int width, int height, Function<Float, Float> f) {
        try {
            float[] data = PFMReader.generateMapping(width, height, f, f);
            PFMData pFMData = new PFMData(data, width, height);
            return pFMData;
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't construct PFM data", (Throwable)e);
        }
    }

    private static float[] generateMapping(int w, int h, Function<Float, Float> fx, Function<Float, Float> fy) {
        float[] out = new float[w * h * 3];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                float u = (float)i / (float)(w - 1);
                float v = (float)j / (float)(h - 1);
                out[(w * j + i) * 3 + 0] = fx.apply(Float.valueOf(u)).floatValue();
                out[(w * j + i) * 3 + 1] = fy.apply(Float.valueOf(v)).floatValue();
                out[(w * j + i) * 3 + 2] = Float.NaN;
            }
        }
        return out;
    }

    public static List<Quad> generateMesh(float[] d, int w, int h) {
        ArrayList<Quad> mesh = new ArrayList<Quad>();
        for (int j = 0; j < h - 1; ++j) {
            for (int i = 0; i < w - 1; ++i) {
                double u = (double)i / ((double)w - 1.0);
                double v = (double)j / ((double)h - 1.0);
                double[] origuv = new double[]{u, v};
                int bl = (w * j + i) * 3;
                int br = (w * j + i + 1) * 3;
                int tl = (w * (j + 1) + i) * 3;
                int tr = (w * (j + 1) + i + 1) * 3;
                double[] positions = new double[]{PFMReader.nor(d[bl]), PFMReader.nor(d[bl + 1]), PFMReader.nor(d[br]), PFMReader.nor(d[br + 1]), PFMReader.nor(d[tr]), PFMReader.nor(d[tr + 1]), PFMReader.nor(d[tl]), PFMReader.nor(d[tl + 1])};
                Quad quad = new Quad(positions, origuv);
                mesh.add(quad);
            }
        }
        return mesh;
    }

    private static float[] invertWarp(float[] d, int w, int h) throws RuntimeException {
        List<Quad> mesh = PFMReader.generateMesh(d, w, h);
        double du = 1.0 / ((double)w - 1.0);
        double dv = 1.0 / ((double)h - 1.0);
        boolean warnedFolds = false;
        boolean warnedRange = false;
        float[] out = new float[d.length];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int p = (w * j + i) * 3;
                double u = (double)i / ((double)w - 1.0);
                double v = (double)j / ((double)h - 1.0);
                List matches = mesh.stream().filter(quad -> quad.containsAlt02(u, v)).collect(Collectors.toList());
                if (matches.isEmpty()) {
                    out[p + 0] = 0.0f;
                    out[p + 1] = 0.0f;
                    out[p + 2] = Float.NaN;
                    if (warnedRange) continue;
                    logger.warn("WARN: The geometry warp forward function does not cover the whole image!");
                    warnedRange = true;
                    continue;
                }
                if (matches.size() > 1 && !warnedFolds) {
                    logger.warn("WARN: The geometry warp forward function has folds!");
                    warnedFolds = true;
                }
                Quad quad2 = (Quad)matches.get(0);
                double[] uv = quad2.invBilinear(u, v);
                double finalU = quad2.origUV[0] + du * uv[0];
                double finalV = quad2.origUV[1] + dv * uv[1];
                out[p + 0] = (float)finalU;
                out[p + 1] = (float)finalV;
                out[p + 2] = Float.NaN;
            }
        }
        return out;
    }

    private static class Quad {
        double[] positions;
        double[] origUV;

        public Quad(double[] positions, double[] origUV) {
            this.positions = positions;
            this.origUV = origUV;
        }

        public double areaTri(double x1, double y1, double x2, double y2, double x3, double y3) {
            return 0.5 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
        }

        public boolean containsAlt01(double x, double y) {
            double a4;
            double a3;
            double a2;
            double quadArea = this.areaTri(this.positions[0], this.positions[1], this.positions[2], this.positions[3], this.positions[4], this.positions[5]) + this.areaTri(this.positions[0], this.positions[1], this.positions[4], this.positions[5], this.positions[6], this.positions[7]);
            double a1 = this.areaTri(x, y, this.positions[0], this.positions[1], this.positions[2], this.positions[3]);
            return a1 + (a2 = this.areaTri(x, y, this.positions[2], this.positions[3], this.positions[4], this.positions[5])) + (a3 = this.areaTri(x, y, this.positions[4], this.positions[5], this.positions[6], this.positions[7])) + (a4 = this.areaTri(x, y, this.positions[6], this.positions[7], this.positions[0], this.positions[1])) <= quadArea;
        }

        public boolean containsAlt02(double x, double y) {
            boolean inside = false;
            int nverts = 4;
            int i = 0;
            int j = 3;
            while (i < 4) {
                boolean intersect;
                double x1 = this.positions[i * 2];
                double y1 = this.positions[i * 2 + 1];
                double x2 = this.positions[j * 2];
                double y2 = this.positions[j * 2 + 1];
                boolean bl = intersect = y1 > y != y2 > y && x < (x2 - x1) * (y - y1) / (y2 - y1) + x1;
                if (intersect) {
                    inside = !inside;
                }
                j = i++;
            }
            return inside;
        }

        public boolean contains(double x, double y) {
            int numFloats = 8;
            int intersects = 0;
            for (int i = 0; i < 8; i += 2) {
                double x1 = this.positions[i];
                double y1 = this.positions[i + 1];
                double x2 = this.positions[(i + 2) % 8];
                double y2 = this.positions[(i + 3) % 8];
                if (!(y1 <= y && y < y2) && (!(y2 <= y) || !(y < y1)) || !(x < (x2 - x1) / (y2 - y1) * (y - y1) + x1)) continue;
                ++intersects;
            }
            return intersects & true;
        }

        double cross2d(double[] a, double[] b) {
            return a[0] * b[1] - a[1] * b[0];
        }

        private double[] checkPointOnPosition(double x, double y) {
            if (x == this.positions[0] && y == this.positions[1]) {
                return new double[]{0.0, 0.0};
            }
            if (x == this.positions[2] && y == this.positions[3]) {
                return new double[]{1.0, 0.0};
            }
            if (x == this.positions[4] && y == this.positions[5]) {
                return new double[]{1.0, 1.0};
            }
            if (x == this.positions[6] && y == this.positions[7]) {
                return new double[]{0.0, 1.0};
            }
            return null;
        }

        public double[] invBilinear(double x, double y) {
            double u;
            double k0;
            double[] uv = this.checkPointOnPosition(x, y);
            if (uv != null) {
                return uv;
            }
            double[] p = new double[]{x, y};
            double[] a = new double[]{this.positions[0], this.positions[1]};
            double[] b = new double[]{this.positions[2], this.positions[3]};
            double[] c = new double[]{this.positions[4], this.positions[5]};
            double[] d = new double[]{this.positions[6], this.positions[7]};
            double[] e = new double[]{b[0] - a[0], b[1] - a[1]};
            double[] f = new double[]{d[0] - a[0], d[1] - a[1]};
            double[] g = new double[]{a[0] - b[0] + c[0] - d[0], a[1] - b[1] + c[1] - d[1]};
            double[] h = new double[]{p[0] - a[0], p[1] - a[1]};
            double k2 = this.cross2d(g, f);
            double k1 = this.cross2d(e, f) + this.cross2d(h, g);
            double w = k1 * k1 - 4.0 * (k0 = this.cross2d(h, e)) * k2;
            if (w < 0.0) {
                return new double[]{-1.0, -1.0};
            }
            double v = 2.0 * k0 / (-k1 - (w = FastMath.sqrt((double)w)));
            if (v < 0.0 || v > 1.0) {
                v = 2.0 * k0 / (-k1 + w);
            }
            if ((u = (h[0] - f[0] * v) / (e[0] + g[0] * v)) < 0.0 || u > 1.0 || v < 0.0 || v > 1.0) {
                return new double[]{-1.0, -1.0};
            }
            return new double[]{u, v};
        }
    }
}

