/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.Logger;
import gaiasky.util.gdx.loader.OwnTextureLoader;
import gaiasky.util.gdx.loader.PFMReader;

public class PFMTextureLoader
extends AsynchronousAssetLoader<Texture, PFMTextureParameter> {
    private static final Logger.Log logger = Logger.getLogger(PFMTextureLoader.class);
    TextureLoaderInfo info = new TextureLoaderInfo();

    public PFMTextureLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, PFMTextureParameter parameter) {
        this.info.filename = fileName;
        if (parameter == null || parameter.textureData == null) {
            this.info.texture = null;
            if (parameter != null) {
                this.info.texture = parameter.texture;
            }
            logger.info("Loading PFM: " + file.path());
            assert (parameter != null);
            if (parameter.internalFormat == 5126) {
                this.info.data = PFMReader.readPFMTextureData(file, parameter.invert);
            } else {
                Pixmap pixmap = PFMReader.readPFMPixmap(file, parameter.invert);
                this.info.data = new FileTextureData(file, pixmap, parameter.format, parameter.genMipMaps);
            }
        } else {
            this.info.data = parameter.textureData;
            this.info.texture = parameter.texture;
        }
        if (!this.info.data.isPrepared()) {
            this.info.data.prepare();
        }
    }

    public Texture loadSync(AssetManager manager, String fileName, FileHandle file, PFMTextureParameter parameter) {
        if (this.info == null) {
            return null;
        }
        Texture texture = this.info.texture;
        if (texture != null) {
            texture.load(this.info.data);
        } else {
            texture = new Texture(this.info.data);
        }
        if (parameter != null) {
            texture.setFilter(parameter.minFilter, parameter.magFilter);
            texture.setWrap(parameter.wrapU, parameter.wrapV);
        }
        return texture;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, PFMTextureParameter parameter) {
        return null;
    }

    public static class TextureLoaderInfo {
        String filename;
        TextureData data;
        Texture texture;
    }

    public static class PFMTextureParameter
    extends OwnTextureLoader.OwnTextureParameter {
        public boolean invert = false;
        public int internalFormat = 6407;

        public PFMTextureParameter() {
        }

        public PFMTextureParameter(OwnTextureLoader.OwnTextureParameter other) {
            this.format = other.format;
            this.genMipMaps = other.genMipMaps;
            this.magFilter = other.magFilter;
            this.minFilter = other.minFilter;
            this.wrapU = other.wrapU;
            this.wrapV = other.wrapV;
        }
    }
}

