/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.loader;

import com.badlogic.gdx.files.FileHandle;
import gaiasky.util.parse.Parser;
import java.io.BufferedReader;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class WarpMeshReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidWarpMeshAscii(Path file) {
        if (file == null) return false;
        if (!Files.exists(file, new LinkOption[0])) return false;
        if (!Files.isRegularFile(file, new LinkOption[0])) return false;
        if (!Files.isReadable(file)) return false;
        try (BufferedReader reader = new BufferedReader(new FileReader(file.toFile()));){
            String sep = "\\s+";
            int type = Parser.parseIntException(reader.readLine().trim());
            String line = reader.readLine();
            String[] tokens = line.split(sep);
            int nx = Parser.parseIntException(tokens[0].trim());
            int ny = Parser.parseIntException(tokens[1].trim());
            line = reader.readLine();
            tokens = line.split(sep);
            if (tokens.length < 5) return false;
            for (int i = 0; i < 5; ++i) {
                Parser.parseFloatException(tokens[i].trim());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static WarpMesh readWarpMeshAscii(FileHandle file) throws RuntimeException {
        if (file != null && file.exists()) {
            WarpMesh warpMesh;
            BufferedReader reader = new BufferedReader(new FileReader(file.file()));
            try {
                String sep = "\\s+";
                WarpMesh mesh = new WarpMesh();
                mesh.type = Parser.parseIntException(reader.readLine().trim());
                String line = reader.readLine();
                String[] tokens = line.split(sep);
                mesh.nx = Parser.parseIntException(tokens[0].trim());
                mesh.ny = Parser.parseIntException(tokens[1].trim());
                mesh.nodes = new ArrayList<float[]>();
                while ((line = reader.readLine()) != null) {
                    tokens = line.split(sep);
                    float[] values = new float[5];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = Parser.parseFloatException(tokens[i].trim());
                    }
                    mesh.nodes.add(values);
                }
                warpMesh = mesh;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return warpMesh;
        }
        return null;
    }

    public static class WarpMesh {
        public int type;
        public int nx;
        public int ny;
        public List<float[]> nodes;
    }
}

