/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.mesh;

import com.badlogic.gdx.utils.BufferUtils;
import gaiasky.util.gdx.mesh.IntIndexData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class IntIndexArray
implements IntIndexData {
    final IntBuffer buffer;
    final ByteBuffer byteBuffer;
    private final boolean empty;

    public IntIndexArray(int maxIndices) {
        boolean bl = this.empty = maxIndices == 0;
        if (this.empty) {
            maxIndices = 1;
        }
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer((int)(maxIndices * 4));
        this.buffer = this.byteBuffer.asIntBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
    }

    @Override
    public int getNumIndices() {
        return this.empty ? 0 : this.buffer.limit();
    }

    @Override
    public int getNumMaxIndices() {
        return this.empty ? 0 : this.buffer.capacity();
    }

    @Override
    public void setIndices(int[] indices, int offset, int count) {
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(count << 2);
    }

    @Override
    public void setIndices(IntBuffer indices) {
        int pos = indices.position();
        this.buffer.clear();
        this.buffer.limit(indices.remaining());
        this.buffer.put(indices);
        this.buffer.flip();
        indices.position(pos);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 2);
    }

    @Override
    public void updateIndices(int targetOffset, int[] indices, int offset, int count) {
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        BufferUtils.copy((int[])indices, (int)offset, (Buffer)this.byteBuffer, (int)count);
        this.byteBuffer.position(pos);
    }

    @Override
    public IntBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void bind() {
    }

    @Override
    public void unbind() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer((ByteBuffer)this.byteBuffer);
    }
}

