/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.mesh;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import gaiasky.util.gdx.mesh.IntIndexData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class IntIndexBufferObjectSubData
implements IntIndexData {
    final IntBuffer buffer;
    final ByteBuffer byteBuffer;
    final boolean isDirect;
    final int usage;
    int bufferHandle;
    boolean isDirty = true;
    boolean isBound = false;

    public IntIndexBufferObjectSubData(boolean isStatic, int maxIndices) {
        this.byteBuffer = BufferUtils.newByteBuffer((int)(maxIndices * 4));
        this.isDirect = true;
        this.usage = isStatic ? 35044 : 35048;
        this.buffer = this.byteBuffer.asIntBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    public IntIndexBufferObjectSubData(int maxIndices) {
        this.byteBuffer = BufferUtils.newByteBuffer((int)(maxIndices * 4));
        this.isDirect = true;
        this.usage = 35044;
        this.buffer = this.byteBuffer.asIntBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = this.createBufferObject();
    }

    private int createBufferObject() {
        int result = Gdx.gl20.glGenBuffer();
        Gdx.gl20.glBindBuffer(34963, result);
        Gdx.gl20.glBufferData(34963, this.byteBuffer.capacity(), null, this.usage);
        Gdx.gl20.glBindBuffer(34963, 0);
        return result;
    }

    @Override
    public int getNumIndices() {
        return this.buffer.limit();
    }

    @Override
    public int getNumMaxIndices() {
        return this.buffer.capacity();
    }

    @Override
    public void setIndices(int[] indices, int offset, int count) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices, offset, count);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(count << 2);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), (Buffer)this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void setIndices(IntBuffer indices) {
        int pos = indices.position();
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(indices);
        this.buffer.flip();
        indices.position(pos);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 2);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), (Buffer)this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public void updateIndices(int targetOffset, int[] indices, int offset, int count) {
        this.isDirty = true;
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        BufferUtils.copy((int[])indices, (int)offset, (Buffer)this.byteBuffer, (int)count);
        this.byteBuffer.position(pos);
        this.buffer.position(0);
        if (this.isBound) {
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), (Buffer)this.byteBuffer);
            this.isDirty = false;
        }
    }

    @Override
    public IntBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public void bind() {
        if (this.bufferHandle == 0) {
            throw new GdxRuntimeException("IntIndexBufferObject cannot be used after it has been disposed.");
        }
        Gdx.gl20.glBindBuffer(34963, this.bufferHandle);
        if (this.isDirty) {
            this.byteBuffer.limit(this.buffer.limit() * 4);
            Gdx.gl20.glBufferSubData(34963, 0, this.byteBuffer.limit(), (Buffer)this.byteBuffer);
            this.isDirty = false;
        }
        this.isBound = true;
    }

    @Override
    public void unbind() {
        Gdx.gl20.glBindBuffer(34963, 0);
        this.isBound = false;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = this.createBufferObject();
        this.isDirty = true;
    }

    @Override
    public void dispose() {
        GL20 gl = Gdx.gl20;
        gl.glBindBuffer(34963, 0);
        gl.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }
}

