/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.mesh;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.IntArray;
import gaiasky.util.gdx.mesh.IntVertexData;
import gaiasky.util.gdx.shader.ExtShaderProgram;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class VertexBufferObjectInstanced
implements IntVertexData {
    static final IntBuffer tmpHandle = BufferUtils.newIntBuffer((int)1);
    final VertexAttributes globalAttributes;
    final VertexAttributes instanceAttributes;
    final FloatBuffer bufferGlobal;
    final ByteBuffer byteBufferGlobal;
    final FloatBuffer bufferInstance;
    final ByteBuffer byteBufferInstance;
    final boolean isStatic;
    final int usage;
    int globalBufferHandle;
    int instanceBufferHandle;
    boolean isDirtyGlobal = false;
    boolean isDirtyInstance = false;
    boolean isBoundGlobal = false;
    boolean isBoundInstance = false;
    int meshVAO = -1;
    IntArray cachedLocationsGlobal = new IntArray();
    IntArray cachedLocationsInstance = new IntArray();

    public VertexBufferObjectInstanced(boolean isStatic, int numGlobal, VertexAttributes globalAttributes, int numInstance, VertexAttributes instanceAttributes) {
        this.isStatic = isStatic;
        this.globalAttributes = globalAttributes;
        this.instanceAttributes = instanceAttributes;
        this.byteBufferGlobal = BufferUtils.newUnsafeByteBuffer((int)(this.globalAttributes.vertexSize * numGlobal));
        this.bufferGlobal = this.byteBufferGlobal.asFloatBuffer();
        this.bufferGlobal.flip();
        this.byteBufferGlobal.flip();
        this.globalBufferHandle = Gdx.gl20.glGenBuffer();
        this.byteBufferInstance = BufferUtils.newUnsafeByteBuffer((int)(this.instanceAttributes.vertexSize * numInstance));
        this.bufferInstance = this.byteBufferInstance.asFloatBuffer();
        this.bufferInstance.flip();
        this.byteBufferInstance.flip();
        this.instanceBufferHandle = Gdx.gl20.glGenBuffer();
        this.usage = isStatic ? 35044 : 35048;
        this.createVAO();
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.globalAttributes;
    }

    public VertexAttributes getInstanceAttributes() {
        return this.instanceAttributes;
    }

    @Override
    public int getNumVertices() {
        return this.bufferGlobal.limit() * 4 / this.globalAttributes.vertexSize;
    }

    @Override
    public int getNumMaxVertices() {
        return this.byteBufferGlobal.capacity() / this.globalAttributes.vertexSize;
    }

    @Override
    public FloatBuffer getBuffer() {
        this.isDirtyGlobal = true;
        return this.bufferGlobal;
    }

    private boolean bufferChanged(ByteBuffer byteBuffer, boolean isBound, boolean isDirty) {
        if (isBound) {
            Gdx.gl20.glBufferData(34962, byteBuffer.limit(), (Buffer)byteBuffer, this.usage);
            return false;
        }
        return isDirty;
    }

    @Override
    public void setVertices(float[] vertices, int offset, int count) {
        this.isDirtyGlobal = true;
        BufferUtils.copy((float[])vertices, (Buffer)this.byteBufferGlobal, (int)count, (int)offset);
        this.bufferGlobal.position(0);
        this.bufferGlobal.limit(count);
        this.isDirtyGlobal = this.bufferChanged(this.byteBufferGlobal, this.isBoundGlobal, this.isDirtyGlobal);
    }

    public void setInstance(float[] vertices, int offset, int count) {
        this.isDirtyInstance = true;
        BufferUtils.copy((float[])vertices, (Buffer)this.byteBufferInstance, (int)count, (int)offset);
        this.bufferInstance.position(0);
        this.bufferInstance.limit(count);
        this.isDirtyInstance = this.bufferChanged(this.byteBufferInstance, this.isBoundInstance, this.isDirtyInstance);
    }

    @Override
    public void updateVertices(int targetOffset, float[] vertices, int sourceOffset, int count) {
        this.isDirtyGlobal = true;
        int pos = this.byteBufferGlobal.position();
        this.byteBufferGlobal.position(targetOffset * 4);
        BufferUtils.copy((float[])vertices, (int)sourceOffset, (int)count, (Buffer)this.byteBufferGlobal);
        this.byteBufferGlobal.position(pos);
        this.bufferGlobal.position(0);
        this.isDirtyGlobal = this.bufferChanged(this.byteBufferGlobal, this.isBoundGlobal, this.isDirtyGlobal);
    }

    @Override
    public void bind(ExtShaderProgram shader) {
        this.bind(shader, null);
    }

    @Override
    public void bind(ExtShaderProgram shader, int[] locations) {
        GL30 gl = Gdx.gl30;
        gl.glBindVertexArray(this.meshVAO);
        this.bindAttributes(shader, locations, this.globalAttributes, this.globalBufferHandle, this.cachedLocationsGlobal, 0);
        this.isDirtyGlobal = this.bindData((GL20)gl, this.globalBufferHandle, this.isDirtyGlobal, this.bufferGlobal, this.byteBufferGlobal);
        this.isBoundGlobal = true;
        this.bindAttributes(shader, locations, this.instanceAttributes, this.instanceBufferHandle, this.cachedLocationsInstance, 1);
        this.isDirtyInstance = this.bindData((GL20)gl, this.instanceBufferHandle, this.isDirtyInstance, this.bufferInstance, this.byteBufferInstance);
        this.isBoundInstance = true;
    }

    private void bindAttributes(ExtShaderProgram shader, int[] locations, VertexAttributes attributes, int bufferHandle, IntArray cachedLocations, int divisor) {
        int location;
        VertexAttribute attribute;
        int i;
        boolean stillValid = cachedLocations.size != 0;
        int numAttributes = attributes.size();
        if (stillValid) {
            if (locations == null) {
                for (i = 0; stillValid && i < numAttributes; ++i) {
                    attribute = attributes.get(i);
                    location = shader.getAttributeLocation(attribute.alias);
                    stillValid = location == cachedLocations.get(i);
                }
            } else {
                stillValid = locations.length == cachedLocations.size;
                for (i = 0; stillValid && i < numAttributes; ++i) {
                    stillValid = locations[i] == cachedLocations.get(i);
                }
            }
        }
        if (!stillValid) {
            Gdx.gl.glBindBuffer(34962, bufferHandle);
            this.unbindAttributes(shader, attributes, cachedLocations);
            cachedLocations.clear();
            for (i = 0; i < numAttributes; ++i) {
                attribute = attributes.get(i);
                if (locations == null) {
                    cachedLocations.add(shader.getAttributeLocation(attribute.alias));
                } else {
                    cachedLocations.add(locations[i]);
                }
                location = cachedLocations.get(i);
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                shader.setVertexAttribute(location, attribute.numComponents, attribute.type, attribute.normalized, attributes.vertexSize, attribute.offset);
            }
        }
        for (i = 0; i < numAttributes; ++i) {
            attribute = attributes.get(i);
            if (locations == null) {
                cachedLocations.add(shader.getAttributeLocation(attribute.alias));
            } else {
                cachedLocations.add(locations[i]);
            }
            location = cachedLocations.get(i);
            if (location < 0 || divisor < 0) continue;
            Gdx.gl30.glVertexAttribDivisor(location, divisor);
        }
    }

    private void unbindAttributes(ExtShaderProgram shaderProgram, VertexAttributes attributes, IntArray cachedLocations) {
        if (cachedLocations.size == 0) {
            return;
        }
        int numAttributes = attributes.size();
        for (int i = 0; i < numAttributes; ++i) {
            int location = cachedLocations.get(i);
            if (location < 0) continue;
            shaderProgram.disableVertexAttribute(location);
        }
    }

    private boolean bindData(GL20 gl, int bufferHandle, boolean isDirty, FloatBuffer buffer, ByteBuffer byteBuffer) {
        if (isDirty) {
            gl.glBindBuffer(34962, bufferHandle);
            byteBuffer.limit(buffer.limit() * 4);
            gl.glBufferData(34962, byteBuffer.limit(), (Buffer)byteBuffer, this.usage);
        }
        return false;
    }

    @Override
    public void unbind(ExtShaderProgram shader) {
        this.unbind(shader, null);
    }

    @Override
    public void unbind(ExtShaderProgram shader, int[] locations) {
        GL30 gl = Gdx.gl30;
        gl.glBindVertexArray(0);
        this.isBoundGlobal = false;
        this.isBoundInstance = false;
    }

    @Override
    public void invalidate() {
        this.globalBufferHandle = Gdx.gl30.glGenBuffer();
        this.createVAO();
        this.isDirtyGlobal = true;
    }

    @Override
    public void dispose() {
        GL30 gl = Gdx.gl30;
        gl.glBindBuffer(34962, 0);
        gl.glDeleteBuffer(this.globalBufferHandle);
        this.globalBufferHandle = 0;
        BufferUtils.disposeUnsafeByteBuffer((ByteBuffer)this.byteBufferGlobal);
        gl.glDeleteBuffer(this.instanceBufferHandle);
        this.instanceBufferHandle = 0;
        BufferUtils.disposeUnsafeByteBuffer((ByteBuffer)this.byteBufferInstance);
        this.deleteVAO();
    }

    private void createVAO() {
        tmpHandle.clear();
        Gdx.gl30.glGenVertexArrays(1, tmpHandle);
        this.meshVAO = tmpHandle.get();
    }

    private void deleteVAO() {
        if (this.meshVAO != -1) {
            tmpHandle.clear();
            tmpHandle.put(this.meshVAO);
            tmpHandle.flip();
            Gdx.gl30.glDeleteVertexArrays(1, tmpHandle);
            this.meshVAO = -1;
        }
    }
}

