/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model;

import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.model.IntAnimation;
import gaiasky.util.gdx.model.IntModelInstance;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodeAnimation;

public class BaseIntAnimationController {
    private final Pool<Transform> transformPool = new Pool<Transform>(this){

        protected Transform newObject() {
            return new Transform();
        }
    };
    private static final ObjectMap<IntNode, Transform> transforms = new ObjectMap();
    private boolean applying = false;
    public final IntModelInstance target;
    private static final Transform tmpT = new Transform();

    public BaseIntAnimationController(IntModelInstance target) {
        this.target = target;
    }

    protected void begin() {
        if (this.applying) {
            throw new GdxRuntimeException("You must call end() after each call to being()");
        }
        this.applying = true;
    }

    protected void apply(IntAnimation animation, float time, float weight) {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() before adding an animation");
        }
        BaseIntAnimationController.applyAnimation(transforms, this.transformPool, weight, animation, time);
    }

    protected void end() {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() first");
        }
        for (ObjectMap.Entry entry : transforms.entries()) {
            ((Transform)entry.value).toMatrix4(((IntNode)entry.key).localTransform);
            this.transformPool.free((Object)((Transform)entry.value));
        }
        transforms.clear();
        this.target.calculateTransforms();
        this.applying = false;
    }

    protected void applyAnimation(IntAnimation animation, float time) {
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        BaseIntAnimationController.applyAnimation(null, null, 1.0f, animation, time);
        this.target.calculateTransforms();
    }

    protected void applyAnimations(IntAnimation anim1, float time1, IntAnimation anim2, float time2, float weight) {
        if (anim2 == null || weight == 0.0f) {
            this.applyAnimation(anim1, time1);
        } else if (anim1 == null || weight == 1.0f) {
            this.applyAnimation(anim2, time2);
        } else {
            if (this.applying) {
                throw new GdxRuntimeException("Call end() first");
            }
            this.begin();
            this.apply(anim1, time1, 1.0f);
            this.apply(anim2, time2, weight);
            this.end();
        }
    }

    static <T> int getFirstKeyframeIndexAtTime(Array<NodeKeyframe<T>> arr, float time) {
        int lastIndex = arr.size - 1;
        if (lastIndex <= 0 || time < ((NodeKeyframe)arr.get((int)0)).keytime || time > ((NodeKeyframe)arr.get((int)lastIndex)).keytime) {
            return 0;
        }
        int minIndex = 0;
        int maxIndex = lastIndex;
        while (minIndex < maxIndex) {
            int i = (minIndex + maxIndex) / 2;
            if (time > ((NodeKeyframe)arr.get((int)(i + 1))).keytime) {
                minIndex = i + 1;
                continue;
            }
            if (time < ((NodeKeyframe)arr.get((int)i)).keytime) {
                maxIndex = i - 1;
                continue;
            }
            return i;
        }
        return minIndex;
    }

    private static Vector3 getTranslationAtTime(IntNodeAnimation nodeAnim, float time, Vector3 out) {
        if (nodeAnim.translation == null) {
            return out.set(nodeAnim.node.translation);
        }
        if (nodeAnim.translation.size == 1) {
            return out.set((Vector3)((NodeKeyframe)nodeAnim.translation.get((int)0)).value);
        }
        int index = BaseIntAnimationController.getFirstKeyframeIndexAtTime(nodeAnim.translation, time);
        NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
        out.set((Vector3)firstKeyframe.value);
        if (++index < nodeAnim.translation.size) {
            NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.translation.get(index);
            float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
            out.lerp((Vector3)secondKeyframe.value, t);
        }
        return out;
    }

    private static Quaternion getRotationAtTime(IntNodeAnimation nodeAnim, float time, Quaternion out) {
        if (nodeAnim.rotation == null) {
            return out.set(nodeAnim.node.rotation);
        }
        if (nodeAnim.rotation.size == 1) {
            return out.set((Quaternion)((NodeKeyframe)nodeAnim.rotation.get((int)0)).value);
        }
        int index = BaseIntAnimationController.getFirstKeyframeIndexAtTime(nodeAnim.rotation, time);
        NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
        out.set((Quaternion)firstKeyframe.value);
        if (++index < nodeAnim.rotation.size) {
            NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.rotation.get(index);
            float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
            out.slerp((Quaternion)secondKeyframe.value, t);
        }
        return out;
    }

    private static Vector3 getScalingAtTime(IntNodeAnimation nodeAnim, float time, Vector3 out) {
        if (nodeAnim.scaling == null) {
            return out.set(nodeAnim.node.scale);
        }
        if (nodeAnim.scaling.size == 1) {
            return out.set((Vector3)((NodeKeyframe)nodeAnim.scaling.get((int)0)).value);
        }
        int index = BaseIntAnimationController.getFirstKeyframeIndexAtTime(nodeAnim.scaling, time);
        NodeKeyframe firstKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
        out.set((Vector3)firstKeyframe.value);
        if (++index < nodeAnim.scaling.size) {
            NodeKeyframe secondKeyframe = (NodeKeyframe)nodeAnim.scaling.get(index);
            float t = (time - firstKeyframe.keytime) / (secondKeyframe.keytime - firstKeyframe.keytime);
            out.lerp((Vector3)secondKeyframe.value, t);
        }
        return out;
    }

    private static Transform getNodeAnimationTransform(IntNodeAnimation nodeAnim, float time) {
        Transform transform = tmpT;
        BaseIntAnimationController.getTranslationAtTime(nodeAnim, time, transform.translation);
        BaseIntAnimationController.getRotationAtTime(nodeAnim, time, transform.rotation);
        BaseIntAnimationController.getScalingAtTime(nodeAnim, time, transform.scale);
        return transform;
    }

    private static void applyNodeAnimationDirectly(IntNodeAnimation nodeAnim, float time) {
        IntNode node = nodeAnim.node;
        node.isAnimated = true;
        Transform transform = BaseIntAnimationController.getNodeAnimationTransform(nodeAnim, time);
        transform.toMatrix4(node.localTransform);
    }

    private static void applyNodeAnimationBlending(IntNodeAnimation nodeAnim, ObjectMap<IntNode, Transform> out, Pool<Transform> pool, float alpha, float time) {
        IntNode node = nodeAnim.node;
        node.isAnimated = true;
        Transform transform = BaseIntAnimationController.getNodeAnimationTransform(nodeAnim, time);
        Transform t = (Transform)out.get((Object)node, null);
        if (t != null) {
            if (alpha > 0.999999f) {
                t.set(transform);
            } else {
                t.lerp(transform, alpha);
            }
        } else if (alpha > 0.999999f) {
            out.put((Object)node, (Object)((Transform)pool.obtain()).set(transform));
        } else {
            out.put((Object)node, (Object)((Transform)pool.obtain()).set(node.translation, node.rotation, node.scale).lerp(transform, alpha));
        }
    }

    protected static void applyAnimation(ObjectMap<IntNode, Transform> out, Pool<Transform> pool, float alpha, IntAnimation animation, float time) {
        if (out == null) {
            for (IntNodeAnimation nodeAnim : animation.nodeAnimations) {
                BaseIntAnimationController.applyNodeAnimationDirectly(nodeAnim, time);
            }
        } else {
            for (IntNode node : out.keys()) {
                node.isAnimated = false;
            }
            for (IntNodeAnimation nodeAnim : animation.nodeAnimations) {
                BaseIntAnimationController.applyNodeAnimationBlending(nodeAnim, out, pool, alpha, time);
            }
            for (ObjectMap.Entry e : out.entries()) {
                if (((IntNode)e.key).isAnimated) continue;
                ((IntNode)e.key).isAnimated = true;
                ((Transform)e.value).lerp(((IntNode)e.key).translation, ((IntNode)e.key).rotation, ((IntNode)e.key).scale, alpha);
            }
        }
    }

    protected void removeAnimation(IntAnimation animation) {
        for (IntNodeAnimation nodeAnim : animation.nodeAnimations) {
            nodeAnim.node.isAnimated = false;
        }
    }

    public static final class Transform
    implements Pool.Poolable {
        public final Vector3 translation = new Vector3();
        public final Quaternion rotation = new Quaternion();
        public final Vector3 scale = new Vector3(1.0f, 1.0f, 1.0f);

        public Transform idt() {
            this.translation.set(0.0f, 0.0f, 0.0f);
            this.rotation.idt();
            this.scale.set(1.0f, 1.0f, 1.0f);
            return this;
        }

        public Transform set(Vector3 t, Quaternion r, Vector3 s) {
            this.translation.set(t);
            this.rotation.set(r);
            this.scale.set(s);
            return this;
        }

        public Transform set(Transform other) {
            return this.set(other.translation, other.rotation, other.scale);
        }

        public Transform lerp(Transform target, float alpha) {
            return this.lerp(target.translation, target.rotation, target.scale, alpha);
        }

        public Transform lerp(Vector3 targetT, Quaternion targetR, Vector3 targetS, float alpha) {
            this.translation.lerp(targetT, alpha);
            this.rotation.slerp(targetR, alpha);
            this.scale.lerp(targetS, alpha);
            return this;
        }

        public Matrix4 toMatrix4(Matrix4 out) {
            return out.set(this.translation, this.rotation, this.scale);
        }

        public void reset() {
            this.idt();
        }

        public String toString() {
            return String.valueOf(this.translation) + " - " + String.valueOf(this.rotation) + " - " + String.valueOf(this.scale);
        }
    }
}

