/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model;

import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.shader.ExtShaderProgram;

public class IntMeshPart {
    private static final BoundingBox bounds = new BoundingBox();
    public final Vector3 center = new Vector3();
    public final Vector3 halfExtents = new Vector3();
    public String id;
    public int primitiveType;
    public int offset;
    public int size;
    public IntMesh mesh;
    public float radius = -1.0f;

    public IntMeshPart() {
    }

    public IntMeshPart(MeshPart other) {
        this.primitiveType = other.primitiveType;
        this.center.set(other.center);
        this.halfExtents.set(other.halfExtents);
        this.id = other.id;
        this.offset = other.offset;
        this.size = other.size;
        this.mesh = new IntMesh(other.mesh);
        this.radius = other.radius;
    }

    public IntMeshPart(String id, IntMesh mesh, int offset, int size, int type) {
        this.set(id, mesh, offset, size, type);
    }

    public IntMeshPart(IntMeshPart copyFrom) {
        this.set(copyFrom);
    }

    public IntMeshPart set(IntMeshPart other) {
        this.id = other.id;
        this.mesh = other.mesh;
        this.offset = other.offset;
        this.size = other.size;
        this.primitiveType = other.primitiveType;
        this.center.set(other.center);
        this.halfExtents.set(other.halfExtents);
        this.radius = other.radius;
        return this;
    }

    public IntMeshPart set(String id, IntMesh mesh, int offset, int size, int type) {
        this.id = id;
        this.mesh = mesh;
        this.offset = offset;
        this.size = size;
        this.primitiveType = type;
        this.center.set(0.0f, 0.0f, 0.0f);
        this.halfExtents.set(0.0f, 0.0f, 0.0f);
        this.radius = -1.0f;
        return this;
    }

    public void update() {
        this.mesh.calculateBoundingBox(bounds, this.offset, this.size);
        bounds.getCenter(this.center);
        bounds.getDimensions(this.halfExtents).scl(0.5f);
        this.radius = this.halfExtents.len();
    }

    public boolean equals(IntMeshPart other) {
        return other == this || other != null && other.mesh == this.mesh && other.primitiveType == this.primitiveType && other.offset == this.offset && other.size == this.size;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 == this) {
            return true;
        }
        if (!(arg0 instanceof IntMeshPart)) {
            return false;
        }
        return this.equals((IntMeshPart)arg0);
    }

    public void render(ExtShaderProgram shader, boolean autoBind) {
        this.mesh.render(shader, this.primitiveType, this.offset, this.size, autoBind);
    }

    public void render(ExtShaderProgram shader) {
        this.mesh.render(shader, this.primitiveType, this.offset, this.size);
    }
}

