/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.IntAnimation;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodeAnimation;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.model.data.IntModelData;
import gaiasky.util.gdx.model.data.IntModelMesh;
import gaiasky.util.gdx.model.data.IntModelMeshPart;
import gaiasky.util.gdx.model.data.IntModelNode;
import gaiasky.util.gdx.model.data.OwnModelMaterial;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;
import java.nio.Buffer;
import net.jafama.FastMath;

public class IntModel
implements Disposable {
    public final Array<Material> materials = new Array();
    public final Array<IntNode> nodes = new Array();
    public final Array<IntAnimation> animations = new Array();
    public final Array<IntMesh> meshes = new Array();
    public final Array<IntMeshPart> meshParts = new Array();
    public double span;
    protected final Array<Disposable> disposables = new Array();
    private final ObjectMap<IntNodePart, ArrayMap<String, Matrix4>> nodePartBones = new ObjectMap();
    private final Vector3 v = new Vector3();
    private final Vector3 scale = new Vector3();
    private final Matrix4 transform = new Matrix4();

    public IntModel() {
    }

    public IntModel(IntModelData modelData) {
        this(modelData, (TextureProvider)new TextureProvider.FileTextureProvider());
    }

    public IntModel(IntModelData modelData, TextureProvider textureProvider) {
        this.load(modelData, textureProvider);
    }

    protected void load(IntModelData modelData, TextureProvider textureProvider) {
        this.loadMeshes((Iterable<IntModelMesh>)modelData.meshes);
        this.loadMaterials((Iterable<OwnModelMaterial>)modelData.materials, textureProvider);
        this.loadNodes((Iterable<IntModelNode>)modelData.nodes);
        this.loadAnimations((Iterable<ModelAnimation>)modelData.animations);
        this.calculateTransforms();
        this.computeSpan();
    }

    protected void loadAnimations(Iterable<ModelAnimation> modelAnimations) {
        for (ModelAnimation anim : modelAnimations) {
            IntAnimation animation = new IntAnimation();
            animation.id = anim.id;
            for (ModelNodeAnimation nanim : anim.nodeAnimations) {
                IntNode node = this.getNode(nanim.nodeId);
                if (node == null) continue;
                IntNodeAnimation nodeAnim = new IntNodeAnimation();
                nodeAnim.node = node;
                if (nanim.translation != null) {
                    nodeAnim.translation = new Array();
                    nodeAnim.translation.ensureCapacity(nanim.translation.size);
                    for (ModelNodeKeyframe kf : nanim.translation) {
                        if (kf.keytime > animation.duration) {
                            animation.duration = kf.keytime;
                        }
                        nodeAnim.translation.add((Object)new NodeKeyframe(kf.keytime, (Object)new Vector3(kf.value == null ? node.translation : (Vector3)kf.value)));
                    }
                }
                if (nanim.rotation != null) {
                    nodeAnim.rotation = new Array();
                    nodeAnim.rotation.ensureCapacity(nanim.rotation.size);
                    for (ModelNodeKeyframe kf : nanim.rotation) {
                        if (kf.keytime > animation.duration) {
                            animation.duration = kf.keytime;
                        }
                        nodeAnim.rotation.add((Object)new NodeKeyframe(kf.keytime, (Object)new Quaternion(kf.value == null ? node.rotation : (Quaternion)kf.value)));
                    }
                }
                if (nanim.scaling != null) {
                    nodeAnim.scaling = new Array();
                    nodeAnim.scaling.ensureCapacity(nanim.scaling.size);
                    for (ModelNodeKeyframe kf : nanim.scaling) {
                        if (kf.keytime > animation.duration) {
                            animation.duration = kf.keytime;
                        }
                        nodeAnim.scaling.add((Object)new NodeKeyframe(kf.keytime, (Object)new Vector3(kf.value == null ? node.scale : (Vector3)kf.value)));
                    }
                }
                if (!(nodeAnim.translation != null && nodeAnim.translation.size > 0 || nodeAnim.rotation != null && nodeAnim.rotation.size > 0) && (nodeAnim.scaling == null || nodeAnim.scaling.size <= 0)) continue;
                animation.nodeAnimations.add((Object)nodeAnim);
            }
            if (animation.nodeAnimations.size <= 0) continue;
            this.animations.add((Object)animation);
        }
    }

    protected void loadNodes(Iterable<IntModelNode> modelNodes) {
        this.nodePartBones.clear();
        for (IntModelNode node : modelNodes) {
            this.nodes.add((Object)this.loadNode(node));
        }
        for (ObjectMap.Entry e : this.nodePartBones.entries()) {
            if (((IntNodePart)e.key).invBoneBindTransforms == null) {
                ((IntNodePart)e.key).invBoneBindTransforms = new ArrayMap(IntNode[]::new, Matrix4[]::new);
            }
            ((IntNodePart)e.key).invBoneBindTransforms.clear();
            for (ObjectMap.Entry b : ((ArrayMap)e.value).entries()) {
                ((IntNodePart)e.key).invBoneBindTransforms.put((Object)this.getNode((String)b.key), (Object)new Matrix4((Matrix4)b.value).inv());
            }
        }
    }

    protected IntNode loadNode(IntModelNode modelNode) {
        IntNode node = new IntNode();
        node.id = modelNode.id;
        if (modelNode.translation != null) {
            node.translation.set(modelNode.translation);
        }
        if (modelNode.rotation != null) {
            node.rotation.set(modelNode.rotation);
        }
        if (modelNode.scale != null) {
            node.scale.set(modelNode.scale);
        }
        if (modelNode.parts != null) {
            for (ModelNodePart modelNodePart : modelNode.parts) {
                IntMeshPart meshPart = null;
                Material meshMaterial = null;
                if (modelNodePart.meshPartId != null) {
                    for (IntMeshPart part : this.meshParts) {
                        if (!modelNodePart.meshPartId.equals(part.id)) continue;
                        meshPart = part;
                        break;
                    }
                }
                if (modelNodePart.materialId != null) {
                    for (Material material : this.materials) {
                        if (!modelNodePart.materialId.equals(material.id)) continue;
                        meshMaterial = material;
                        break;
                    }
                }
                if (meshPart == null || meshMaterial == null) {
                    throw new GdxRuntimeException("Invalid node: " + node.id);
                }
                IntNodePart nodePart = new IntNodePart();
                nodePart.meshPart = meshPart;
                nodePart.material = meshMaterial;
                node.parts.add((Object)nodePart);
                if (modelNodePart.bones == null) continue;
                this.nodePartBones.put((Object)nodePart, (Object)modelNodePart.bones);
            }
        }
        if (modelNode.children != null) {
            for (IntModelNode child : modelNode.children) {
                node.addChild(this.loadNode(child));
            }
        }
        return node;
    }

    protected void loadMeshes(Iterable<IntModelMesh> meshes) {
        for (IntModelMesh mesh : meshes) {
            this.convertMesh(mesh);
        }
    }

    protected void convertMesh(IntModelMesh modelMesh) {
        int numIndices = 0;
        for (IntModelMeshPart part : modelMesh.parts) {
            numIndices += part.indices.length;
        }
        VertexAttributes attributes = new VertexAttributes(modelMesh.attributes);
        int numVertices = modelMesh.vertices.length / (attributes.vertexSize / 4);
        IntMesh mesh = new IntMesh(true, numVertices, numIndices, attributes);
        this.meshes.add((Object)mesh);
        this.disposables.add((Object)mesh);
        BufferUtils.copy((float[])modelMesh.vertices, (Buffer)mesh.getVerticesBuffer(), (int)modelMesh.vertices.length, (int)0);
        int offset = 0;
        mesh.getIndicesBuffer().clear();
        for (IntModelMeshPart part : modelMesh.parts) {
            IntMeshPart meshPart = new IntMeshPart();
            meshPart.id = part.id;
            meshPart.primitiveType = part.primitiveType;
            meshPart.offset = offset;
            meshPart.size = part.indices.length;
            meshPart.mesh = mesh;
            mesh.getIndicesBuffer().put(part.indices);
            offset += meshPart.size;
            this.meshParts.add((Object)meshPart);
        }
        mesh.getIndicesBuffer().position(0);
        for (IntMeshPart part : this.meshParts) {
            part.update();
        }
    }

    protected void loadMaterials(Iterable<OwnModelMaterial> modelMaterials, TextureProvider textureProvider) {
        for (OwnModelMaterial mtl : modelMaterials) {
            this.materials.add((Object)this.convertMaterial(mtl, textureProvider));
        }
    }

    protected Material convertMaterial(OwnModelMaterial mtl, TextureProvider textureProvider) {
        Material result = new Material();
        result.id = mtl.id;
        if (mtl.ambient != null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Ambient, mtl.ambient));
        }
        if (mtl.diffuse != null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, mtl.diffuse));
        }
        if (mtl.specular != null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Specular, mtl.specular));
        }
        if (mtl.emissive != null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, mtl.emissive));
        }
        if (mtl.metallic != null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Metallic, mtl.metallic));
        }
        if (mtl.reflection != null && mtl.metallic == null) {
            result.set((Attribute)new ColorAttribute(ColorAttribute.Metallic, mtl.reflection));
        }
        if (mtl.shininess > 0.0f) {
            result.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, mtl.shininess));
        }
        if (mtl.opacity != 1.0f) {
            result.set((Attribute)new BlendingAttribute(770, 771, mtl.opacity));
        }
        ObjectMap textures = new ObjectMap();
        if (mtl.textures != null) {
            for (ModelTexture tex : mtl.textures) {
                Texture texture;
                if (textures.containsKey((Object)tex.fileName)) {
                    texture = (Texture)textures.get((Object)tex.fileName);
                } else {
                    texture = textureProvider.load(tex.fileName);
                    textures.put((Object)tex.fileName, (Object)texture);
                    this.disposables.add((Object)texture);
                }
                TextureDescriptor descriptor = new TextureDescriptor((GLTexture)texture);
                descriptor.minFilter = texture.getMinFilter();
                descriptor.magFilter = texture.getMagFilter();
                descriptor.uWrap = texture.getUWrap();
                descriptor.vWrap = texture.getVWrap();
                float offsetU = tex.uvTranslation == null ? 0.0f : tex.uvTranslation.x;
                float offsetV = tex.uvTranslation == null ? 0.0f : tex.uvTranslation.y;
                float scaleU = tex.uvScaling == null ? 1.0f : tex.uvScaling.x;
                float scaleV = tex.uvScaling == null ? 1.0f : tex.uvScaling.y;
                switch (tex.usage) {
                    case 2: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 5: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Specular, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 8: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Bump, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 7: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Normal, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 4: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Ambient, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 3: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Emissive, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 11: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Metallic, descriptor, offsetU, offsetV, scaleU, scaleV));
                        break;
                    }
                    case 6: 
                    case 13: {
                        result.set((Attribute)new TextureAttribute(TextureAttribute.Roughness, descriptor, offsetU, offsetV, scaleU, scaleV));
                    }
                }
            }
        }
        return result;
    }

    public void manageDisposable(Disposable disposable) {
        if (!this.disposables.contains((Object)disposable, true)) {
            this.disposables.add((Object)disposable);
        }
    }

    public Iterable<Disposable> getManagedDisposables() {
        return this.disposables;
    }

    public void dispose() {
        for (Disposable disposable : this.disposables) {
            disposable.dispose();
        }
    }

    public void calculateTransforms() {
        int i;
        int n = this.nodes.size;
        for (i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).calculateTransforms(true);
        }
        for (i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).calculateBoneTransforms(true);
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox out) {
        out.inf();
        return this.extendBoundingBox(out);
    }

    public BoundingBox extendBoundingBox(BoundingBox out) {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).extendBoundingBox(out);
        }
        return out;
    }

    public IntAnimation getAnimation(String id) {
        return this.getAnimation(id, true);
    }

    public IntAnimation getAnimation(String id, boolean ignoreCase) {
        int n = this.animations.size;
        if (ignoreCase) {
            for (int i = 0; i < n; ++i) {
                IntAnimation animation = (IntAnimation)this.animations.get(i);
                if (!animation.id.equalsIgnoreCase(id)) continue;
                return animation;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                IntAnimation animation = (IntAnimation)this.animations.get(i);
                if (!animation.id.equals(id)) continue;
                return animation;
            }
        }
        return null;
    }

    public Material getMaterial(String id) {
        return this.getMaterial(id, true);
    }

    public Material getMaterial(String id, boolean ignoreCase) {
        int n = this.materials.size;
        if (ignoreCase) {
            for (int i = 0; i < n; ++i) {
                Material material = (Material)this.materials.get(i);
                if (!material.id.equalsIgnoreCase(id)) continue;
                return material;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Material material = (Material)this.materials.get(i);
                if (!material.id.equals(id)) continue;
                return material;
            }
        }
        return null;
    }

    public IntNode getNode(String id) {
        return this.getNode(id, true);
    }

    public IntNode getNode(String id, boolean recursive) {
        return this.getNode(id, recursive, false);
    }

    public IntNode getNode(String id, boolean recursive, boolean ignoreCase) {
        return IntNode.getNode(this.nodes, id, recursive, ignoreCase);
    }

    public void computeSpan() {
        this.span = 0.0;
        this.transform.idt();
        if (!this.nodes.isEmpty()) {
            for (IntNode node : this.nodes) {
                if (node.scale.len2() != 1.0f) {
                    this.transform.scale(node.scale.x, node.scale.y, node.scale.z);
                }
                if (!node.rotation.isIdentity()) {
                    this.transform.rotate(node.rotation);
                }
                if (node.translation.len2() != 0.0f) {
                    this.transform.translate(node.translation);
                }
                for (IntNodePart nodePart : node.parts) {
                    IntMeshPart meshPart = nodePart.meshPart;
                    double meshSpan2 = this.meshSpan2(meshPart.mesh, node.globalTransform);
                    if (!(meshSpan2 > this.span)) continue;
                    this.span = meshSpan2;
                }
            }
        }
        if (!this.meshParts.isEmpty()) {
            for (IntMeshPart meshPart : this.meshParts) {
                double meshSpan2 = this.meshSpan2(meshPart.mesh, this.transform);
                if (!(meshSpan2 > this.span)) continue;
                this.span = meshSpan2;
            }
        }
        if (!this.meshes.isEmpty()) {
            for (IntMesh mesh : this.meshes) {
                double meshSpan2 = this.meshSpan2(mesh, this.transform);
                if (!(meshSpan2 > this.span)) continue;
                this.span = meshSpan2;
            }
        }
        this.span = FastMath.sqrt((double)this.span);
    }

    private double meshSpan2(IntMesh mesh, Matrix4 transform) {
        if (mesh == null) {
            return 0.0;
        }
        double span = 0.0;
        VertexAttribute positionAttrib = mesh.getVertexAttribute(1);
        if (positionAttrib == null) {
            return 0.0;
        }
        int offset = positionAttrib.offset / 4;
        int num = mesh.getNumVertices();
        int size = mesh.getVertexSize() / 4;
        int length = num * size;
        float[] vertices = new float[length];
        mesh.getVertices(vertices);
        for (int i = 0; i < num; ++i) {
            float l2;
            this.v.set(vertices[i * size + offset], vertices[i * size + offset + 1], vertices[i * size + offset + 2]);
            if (transform != null) {
                this.v.mul(transform);
            }
            if (!(span < (double)(l2 = this.v.len2()))) continue;
            span = l2;
        }
        return span;
    }
}

