/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model;

import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.Pool;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.IntRenderableProvider;
import gaiasky.util.gdx.model.IntAnimation;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodeAnimation;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.shader.Material;

public class IntModelInstance
implements IntRenderableProvider {
    public static boolean defaultShareKeyframes = true;
    public final Array<Material> materials = new Array();
    public final Array<IntNode> nodes = new Array();
    public final Array<IntAnimation> animations = new Array();
    public final IntModel model;
    public Matrix4 transform;
    public Object userData;
    public double span;

    public IntModelInstance(IntModel model) {
        this(model, (String[])null);
    }

    public IntModelInstance(IntModel model, String nodeId, boolean mergeTransform) {
        this(model, null, nodeId, false, false, mergeTransform);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, String nodeId, boolean mergeTransform) {
        this(model, transform, nodeId, false, false, mergeTransform);
    }

    public IntModelInstance(IntModel model, String nodeId, boolean parentTransform, boolean mergeTransform) {
        this(model, null, nodeId, true, parentTransform, mergeTransform);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, String nodeId, boolean parentTransform, boolean mergeTransform) {
        this(model, transform, nodeId, true, parentTransform, mergeTransform);
    }

    public IntModelInstance(IntModel model, String nodeId, boolean recursive, boolean parentTransform, boolean mergeTransform) {
        this(model, null, nodeId, recursive, parentTransform, mergeTransform);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, String nodeId, boolean recursive, boolean parentTransform, boolean mergeTransform) {
        this(model, transform, nodeId, recursive, parentTransform, mergeTransform, defaultShareKeyframes);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, String nodeId, boolean recursive, boolean parentTransform, boolean mergeTransform, boolean shareKeyframes) {
        this.model = model;
        this.transform = transform == null ? new Matrix4() : transform;
        IntNode node = model.getNode(nodeId, recursive);
        IntNode copy = node.copy();
        this.nodes.add((Object)copy);
        if (mergeTransform) {
            this.transform.mul(parentTransform ? node.globalTransform : node.localTransform);
            copy.translation.set(0.0f, 0.0f, 0.0f);
            copy.rotation.idt();
            copy.scale.set(1.0f, 1.0f, 1.0f);
        } else if (parentTransform && copy.hasParent()) {
            this.transform.mul(node.getParent().globalTransform);
        }
        this.invalidate();
        this.copyAnimations((Iterable<IntAnimation>)model.animations, shareKeyframes);
        this.calculateTransforms();
    }

    public IntModelInstance(IntModel model, String ... rootNodeIds) {
        this(model, (Matrix4)null, rootNodeIds);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, String ... rootNodeIds) {
        this.model = model;
        Matrix4 matrix4 = this.transform = transform == null ? new Matrix4() : transform;
        if (rootNodeIds == null) {
            this.copyNodes(model.nodes);
        } else {
            this.copyNodes(model.nodes, rootNodeIds);
        }
        this.copyAnimations((Iterable<IntAnimation>)model.animations, defaultShareKeyframes);
        this.calculateTransforms();
        this.span = model.span;
    }

    public IntModelInstance(IntModel model, Array<String> rootNodeIds) {
        this(model, null, rootNodeIds);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, Array<String> rootNodeIds) {
        this(model, transform, rootNodeIds, defaultShareKeyframes);
    }

    public IntModelInstance(IntModel model, Matrix4 transform, Array<String> rootNodeIds, boolean shareKeyframes) {
        this.model = model;
        this.transform = transform == null ? new Matrix4() : transform;
        this.copyNodes(model.nodes, rootNodeIds);
        this.copyAnimations((Iterable<IntAnimation>)model.animations, shareKeyframes);
        this.calculateTransforms();
        this.span = model.span;
    }

    public IntModelInstance(IntModel model, Vector3 position) {
        this(model);
        this.transform.setToTranslation(position);
    }

    public IntModelInstance(IntModel model, float x, float y, float z) {
        this(model);
        this.transform.setToTranslation(x, y, z);
    }

    public IntModelInstance(IntModel model, Matrix4 transform) {
        this(model, transform, (String[])null);
    }

    public IntModelInstance(IntModelInstance copyFrom) {
        this(copyFrom, copyFrom.transform.cpy());
    }

    public IntModelInstance(IntModelInstance copyFrom, Matrix4 transform) {
        this(copyFrom, transform, defaultShareKeyframes);
    }

    public IntModelInstance(IntModelInstance copyFrom, Matrix4 transform, boolean shareKeyframes) {
        this.model = copyFrom.model;
        this.transform = transform == null ? new Matrix4() : transform;
        this.copyNodes(copyFrom.nodes);
        this.copyAnimations((Iterable<IntAnimation>)copyFrom.animations, shareKeyframes);
        this.calculateTransforms();
        this.span = copyFrom.span;
    }

    public IntModelInstance copy() {
        return new IntModelInstance(this);
    }

    private void copyNodes(Array<IntNode> nodes) {
        int n = nodes.size;
        for (int i = 0; i < n; ++i) {
            IntNode node = (IntNode)nodes.get(i);
            this.nodes.add((Object)node.copy());
        }
        this.invalidate();
    }

    private void copyNodes(Array<IntNode> nodes, String ... nodeIds) {
        int n = nodes.size;
        block0: for (int i = 0; i < n; ++i) {
            IntNode node = (IntNode)nodes.get(i);
            for (String nodeId : nodeIds) {
                if (!nodeId.equals(node.id)) continue;
                this.nodes.add((Object)node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void copyNodes(Array<IntNode> nodes, Array<String> nodeIds) {
        int n = nodes.size;
        block0: for (int i = 0; i < n; ++i) {
            IntNode node = (IntNode)nodes.get(i);
            for (String nodeId : nodeIds) {
                if (!nodeId.equals(node.id)) continue;
                this.nodes.add((Object)node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void invalidate(IntNode node) {
        int i;
        int n = node.parts.size;
        for (i = 0; i < n; ++i) {
            IntNodePart part = (IntNodePart)node.parts.get(i);
            ArrayMap<IntNode, Matrix4> bindPose = part.invBoneBindTransforms;
            if (bindPose != null) {
                for (int j = 0; j < bindPose.size; ++j) {
                    ((IntNode[])bindPose.keys)[j] = this.getNode(((IntNode[])bindPose.keys)[j].id);
                }
            }
            if (this.materials.contains((Object)part.material, true)) continue;
            int midx = this.materials.indexOf((Object)part.material, false);
            if (midx < 0) {
                part.material = part.material.copy();
                this.materials.add((Object)part.material);
                continue;
            }
            part.material = (Material)this.materials.get(midx);
        }
        n = node.getChildCount();
        for (i = 0; i < n; ++i) {
            this.invalidate(node.getChild(i));
        }
    }

    private void invalidate() {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            this.invalidate((IntNode)this.nodes.get(i));
        }
    }

    private void copyAnimations(Iterable<IntAnimation> source, boolean shareKeyframes) {
        for (IntAnimation anim : source) {
            IntAnimation animation = new IntAnimation();
            animation.id = anim.id;
            animation.duration = anim.duration;
            for (IntNodeAnimation nanim : anim.nodeAnimations) {
                IntNode node = this.getNode(nanim.node.id);
                if (node == null) continue;
                IntNodeAnimation nodeAnim = new IntNodeAnimation();
                nodeAnim.node = node;
                if (shareKeyframes) {
                    nodeAnim.translation = nanim.translation;
                    nodeAnim.rotation = nanim.rotation;
                    nodeAnim.scaling = nanim.scaling;
                } else {
                    if (nanim.translation != null) {
                        nodeAnim.translation = new Array();
                        for (NodeKeyframe kf : nanim.translation) {
                            nodeAnim.translation.add((Object)new NodeKeyframe(kf.keytime, (Object)((Vector3)kf.value)));
                        }
                    }
                    if (nanim.rotation != null) {
                        nodeAnim.rotation = new Array();
                        for (NodeKeyframe kf : nanim.rotation) {
                            nodeAnim.rotation.add((Object)new NodeKeyframe(kf.keytime, (Object)((Quaternion)kf.value)));
                        }
                    }
                    if (nanim.scaling != null) {
                        nodeAnim.scaling = new Array();
                        for (NodeKeyframe kf : nanim.scaling) {
                            nodeAnim.scaling.add((Object)new NodeKeyframe(kf.keytime, (Object)((Vector3)kf.value)));
                        }
                    }
                }
                if (nodeAnim.translation == null && nodeAnim.rotation == null && nodeAnim.scaling == null) continue;
                animation.nodeAnimations.add((Object)nodeAnim);
            }
            if (animation.nodeAnimations.size <= 0) continue;
            this.animations.add((Object)animation);
        }
    }

    @Override
    public void getRenderables(Array<IntRenderable> renderables, Pool<IntRenderable> pool) {
        for (IntNode node : this.nodes) {
            this.getRenderables(node, renderables, pool);
        }
    }

    public IntRenderable getRenderable(IntRenderable out) {
        return this.getRenderable(out, (IntNode)this.nodes.get(0));
    }

    public IntRenderable getRenderable(IntRenderable out, IntNode node) {
        return this.getRenderable(out, node, (IntNodePart)node.parts.get(0));
    }

    public IntRenderable getRenderable(IntRenderable out, IntNode node, IntNodePart nodePart) {
        nodePart.setRenderable(out);
        if (nodePart.bones == null && this.transform != null) {
            out.worldTransform.set(this.transform).mul(node.globalTransform);
        } else if (this.transform != null) {
            out.worldTransform.set(this.transform);
        } else {
            out.worldTransform.idt();
        }
        out.userData = this.userData;
        return out;
    }

    protected void getRenderables(IntNode node, Array<IntRenderable> renderables, Pool<IntRenderable> pool) {
        if (node.parts.size > 0) {
            for (IntNodePart nodePart : node.parts) {
                if (!nodePart.enabled) continue;
                renderables.add((Object)this.getRenderable((IntRenderable)pool.obtain(), node, nodePart));
            }
        }
        for (IntNode child : node.getChildren()) {
            this.getRenderables(child, renderables, pool);
        }
    }

    public void calculateTransforms() {
        int i;
        int n = this.nodes.size;
        for (i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).calculateTransforms(true);
        }
        for (i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).calculateBoneTransforms(true);
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox out) {
        out.inf();
        return this.extendBoundingBox(out);
    }

    public BoundingBox extendBoundingBox(BoundingBox out) {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            ((IntNode)this.nodes.get(i)).extendBoundingBox(out);
        }
        return out;
    }

    public IntAnimation getAnimation(String id) {
        return this.getAnimation(id, false);
    }

    public IntAnimation getAnimation(String id, boolean ignoreCase) {
        int n = this.animations.size;
        if (ignoreCase) {
            for (int i = 0; i < n; ++i) {
                IntAnimation animation = (IntAnimation)this.animations.get(i);
                if (!animation.id.equalsIgnoreCase(id)) continue;
                return animation;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                IntAnimation animation = (IntAnimation)this.animations.get(i);
                if (!animation.id.equals(id)) continue;
                return animation;
            }
        }
        return null;
    }

    public Material getMaterial(String id) {
        return this.getMaterial(id, true);
    }

    public Material getMaterial(String id, boolean ignoreCase) {
        int n = this.materials.size;
        if (ignoreCase) {
            for (int i = 0; i < n; ++i) {
                Material material = (Material)this.materials.get(i);
                if (!material.id.equalsIgnoreCase(id)) continue;
                return material;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Material material = (Material)this.materials.get(i);
                if (!material.id.equals(id)) continue;
                return material;
            }
        }
        return null;
    }

    public IntNode getNode(String id) {
        return this.getNode(id, true);
    }

    public IntNode getNode(String id, boolean recursive) {
        return this.getNode(id, recursive, false);
    }

    public IntNode getNode(String id, boolean recursive, boolean ignoreCase) {
        return IntNode.getNode(this.nodes, id, recursive, ignoreCase);
    }
}

