/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.ArrayMap;
import gaiasky.util.gdx.IntRenderable;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.shader.Material;

public class IntNodePart {
    public IntMeshPart meshPart;
    public Material material;
    public ArrayMap<IntNode, Matrix4> invBoneBindTransforms;
    public Matrix4[] bones;
    public boolean enabled = true;

    public IntNodePart() {
    }

    public IntNodePart(IntMeshPart meshPart, Material material) {
        this.meshPart = meshPart;
        this.material = material;
    }

    public IntRenderable setRenderable(IntRenderable out) {
        out.material = this.material;
        out.meshPart.set(this.meshPart);
        out.bones = this.bones;
        return out;
    }

    public IntNodePart copy() {
        return new IntNodePart().set(this);
    }

    protected IntNodePart set(IntNodePart other) {
        this.meshPart = new IntMeshPart(other.meshPart);
        this.material = other.material;
        this.enabled = other.enabled;
        if (other.invBoneBindTransforms == null) {
            this.invBoneBindTransforms = null;
            this.bones = null;
        } else {
            if (this.invBoneBindTransforms == null) {
                this.invBoneBindTransforms = new ArrayMap(true, other.invBoneBindTransforms.size, IntNode.class, Matrix4.class);
            } else {
                this.invBoneBindTransforms.clear();
            }
            this.invBoneBindTransforms.putAll(other.invBoneBindTransforms);
            if (this.bones == null || this.bones.length != this.invBoneBindTransforms.size) {
                this.bones = new Matrix4[this.invBoneBindTransforms.size];
            }
            for (int i = 0; i < this.bones.length; ++i) {
                if (this.bones[i] != null) continue;
                this.bones[i] = new Matrix4();
            }
        }
        return this;
    }
}

