/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.data.extensions;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.model.gltf.data.GLTFObject;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFIllegalException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.PointLightEx;
import gaiasky.util.gdx.model.gltf.scene3d.lights.SpotLightEx;

public abstract class KHRLightsPunctual {
    public static final String EXT = "KHR_lights_punctual";

    public static BaseLight map(GLTFLight light) {
        if ("directional".equals(light.type)) {
            DirectionalLightEx dl = new DirectionalLightEx();
            dl.baseColor.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            dl.intensity = light.intensity;
            return dl;
        }
        if ("point".equals(light.type)) {
            PointLightEx pl = new PointLightEx();
            pl.color.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            pl.intensity = light.intensity / 10.0f;
            pl.range = light.range;
            return pl;
        }
        if ("spot".equals(light.type)) {
            SpotLightEx sl = new SpotLightEx();
            if (light.spot == null) {
                throw new GLTFIllegalException("spot property required for spot light type");
            }
            sl.color.set(GLTFTypes.mapColor(light.color, Color.WHITE));
            sl.intensity = light.intensity / 10.0f;
            sl.range = light.range;
            sl.setConeRad(light.spot.outerConeAngle, light.spot.innerConeAngle);
            return sl;
        }
        throw new GLTFIllegalException("unsupported light type " + light.type);
    }

    public static class GLTFLight
    extends GLTFObject {
        public static final String TYPE_DIRECTIONAL = "directional";
        public static final String TYPE_POINT = "point";
        public static final String TYPE_SPOT = "spot";
        public String name = "";
        public float[] color = new float[]{1.0f, 1.0f, 1.0f};
        public float intensity = 1.0f;
        public String type;
        public Float range;
        public GLTFSpotLight spot;
    }

    public static class GLTFSpotLight {
        public float innerConeAngle = 0.0f;
        public float outerConeAngle = 0.7853982f;
    }

    public static class GLTFLightNode {
        public Integer light;
    }

    public static class GLTFLights {
        public Array<GLTFLight> lights;
    }
}

