/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.gltf;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.model.gltf.data.GLTF;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFImage;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFSampler;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFTexture;
import gaiasky.util.gdx.model.gltf.loaders.gltf.SeparatedDataFileResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFLoaderBase;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.SceneAssetLoaderParameters;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.ImageResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.TextureResolver;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneAsset;

public class GLTFAssetLoader
extends AsynchronousAssetLoader<SceneAsset, SceneAssetLoaderParameters> {
    private SeparatedDataFileResolver dataFileResolver;
    private ManagedTextureResolver textureResolver;

    public GLTFAssetLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public GLTFAssetLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        this.textureResolver.fetch(manager);
    }

    public SceneAsset loadSync(AssetManager manager, String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        boolean withData = parameter != null && parameter.withData;
        this.textureResolver.loadTextures();
        GLTFLoaderBase loader = new GLTFLoaderBase(this.textureResolver);
        SceneAsset sceneAsset = loader.load(this.dataFileResolver, withData);
        Array deps = manager.getDependencies(fileName);
        if (deps != null) {
            for (String depFileName : deps) {
                Object dep = manager.get(depFileName);
                if (!(dep instanceof Texture)) continue;
                sceneAsset.textures.removeValue((Object)((Texture)dep), true);
            }
        }
        this.textureResolver = null;
        this.dataFileResolver = null;
        return sceneAsset;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SceneAssetLoaderParameters parameter) {
        Array deps = new Array();
        this.dataFileResolver = new SeparatedDataFileResolver();
        this.dataFileResolver.load(file);
        GLTF glModel = this.dataFileResolver.getRoot();
        this.textureResolver = new ManagedTextureResolver(glModel);
        this.textureResolver.getDependencies((Array<AssetDescriptor>)deps);
        return deps;
    }

    private class ManagedTextureResolver
    extends TextureResolver {
        private final ObjectMap<Integer, AssetDescriptor<Texture>> textureDescriptorsSimple = new ObjectMap();
        private final ObjectMap<Integer, AssetDescriptor<Texture>> textureDescriptorsMipMap = new ObjectMap();
        private final ObjectMap<Integer, Pixmap> pixmaps = new ObjectMap();
        private final ObjectMap<Integer, TextureLoader.TextureParameter> textureParameters = new ObjectMap();
        private final GLTF glModel;

        public ManagedTextureResolver(GLTF glModel) {
            this.glModel = glModel;
        }

        @Override
        public void loadTextures(Array<GLTFTexture> glTextures, Array<GLTFSampler> glSamplers, ImageResolver imageResolver) {
        }

        public void fetch(AssetManager manager) {
            for (ObjectMap.Entry e : this.textureDescriptorsSimple) {
                this.texturesSimple.put((Object)((Integer)e.key), (Object)((Texture)manager.get((AssetDescriptor)e.value)));
            }
            for (ObjectMap.Entry e : this.textureDescriptorsMipMap) {
                this.texturesMipmap.put((Object)((Integer)e.key), (Object)((Texture)manager.get((AssetDescriptor)e.value)));
            }
        }

        public void loadTextures() {
            for (ObjectMap.Entry entry : GLTFAssetLoader.this.textureResolver.textureParameters) {
                TextureLoader.TextureParameter params = (TextureLoader.TextureParameter)entry.value;
                GLTFTexture glTexure = (GLTFTexture)this.glTextures.get(((Integer)entry.key).intValue());
                Pixmap pixmap = (Pixmap)this.pixmaps.get((Object)glTexure.source);
                Texture texture = new Texture(pixmap, params.genMipMaps);
                texture.setFilter(params.minFilter, params.magFilter);
                texture.setWrap(params.wrapU, params.wrapV);
                if (params.genMipMaps) {
                    this.texturesMipmap.put((Object)((Integer)entry.key), (Object)texture);
                    continue;
                }
                this.texturesSimple.put((Object)((Integer)entry.key), (Object)texture);
            }
            for (ObjectMap.Entry entry : this.pixmaps) {
                ((Pixmap)entry.value).dispose();
            }
        }

        public void getDependencies(Array<AssetDescriptor> deps) {
            this.glTextures = this.glModel.textures;
            this.glSamplers = this.glModel.samplers;
            if (this.glTextures != null) {
                for (int i = 0; i < this.glTextures.size; ++i) {
                    GLTFTexture glTexture = (GLTFTexture)this.glTextures.get(i);
                    GLTFImage glImage = (GLTFImage)this.glModel.images.get(glTexture.source.intValue());
                    FileHandle imageFile = GLTFAssetLoader.this.dataFileResolver.getImageFile(glImage);
                    TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
                    if (glTexture.sampler != null) {
                        GLTFSampler sampler = (GLTFSampler)this.glSamplers.get(glTexture.sampler.intValue());
                        if (GLTFTypes.isMipMapFilter(sampler)) {
                            textureParameter.genMipMaps = true;
                        }
                        GLTFTypes.mapTextureSampler(textureParameter, sampler);
                    } else {
                        GLTFTypes.mapTextureSampler(textureParameter);
                    }
                    if (imageFile == null) {
                        Pixmap pixmap = (Pixmap)this.pixmaps.get((Object)glTexture.source);
                        if (pixmap == null) {
                            pixmap = GLTFAssetLoader.this.dataFileResolver.load(glImage);
                            this.pixmaps.put((Object)glTexture.source, (Object)pixmap);
                        }
                        this.textureParameters.put((Object)i, (Object)textureParameter);
                        continue;
                    }
                    AssetDescriptor assetDescriptor = new AssetDescriptor(imageFile, Texture.class, (AssetLoaderParameters)textureParameter);
                    deps.add((Object)assetDescriptor);
                    if (textureParameter.genMipMaps) {
                        this.textureDescriptorsMipMap.put((Object)glTexture.source, (Object)assetDescriptor);
                        continue;
                    }
                    this.textureDescriptorsSimple.put((Object)glTexture.source, (Object)assetDescriptor);
                }
            }
        }
    }
}

