/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.model.IntModel;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.model.gltf.data.GLTF;
import gaiasky.util.gdx.model.gltf.data.camera.GLTFCamera;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRLightsPunctual;
import gaiasky.util.gdx.model.gltf.data.geometry.GLTFMesh;
import gaiasky.util.gdx.model.gltf.data.scene.GLTFNode;
import gaiasky.util.gdx.model.gltf.data.scene.GLTFScene;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFUnsupportedException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.animation.AnimationLoader;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataFileResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.geometry.MeshLoader;
import gaiasky.util.gdx.model.gltf.loaders.shared.material.MaterialLoader;
import gaiasky.util.gdx.model.gltf.loaders.shared.material.PBRMaterialLoader;
import gaiasky.util.gdx.model.gltf.loaders.shared.scene.NodeResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.scene.SkinLoader;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.ImageResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.TextureResolver;
import gaiasky.util.gdx.model.gltf.scene3d.model.NodePlus;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneAsset;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneModel;
import gaiasky.util.gdx.shader.Material;

public class GLTFLoaderBase
implements Disposable {
    public static final String TAG = "GLTF";
    public static final ObjectSet<String> supportedExtensions = new ObjectSet();
    private static final ObjectSet<Material> materialSet;
    private static final ObjectSet<IntMeshPart> meshPartSet;
    private static final ObjectSet<IntMesh> meshSet;
    private final ObjectSet<IntMesh> loadedMeshes = new ObjectSet();
    private final Array<Camera> cameras = new Array();
    private final Array<BaseLight> lights = new Array();
    private final ObjectMap<String, Integer> lightMap = new ObjectMap();
    private final ObjectMap<String, Integer> cameraMap = new ObjectMap();
    private final Array<SceneModel> scenes = new Array();
    protected GLTF glModel;
    protected DataFileResolver dataFileResolver;
    protected MaterialLoader materialLoader;
    protected TextureResolver textureResolver;
    protected AnimationLoader animationLoader;
    protected DataResolver dataResolver;
    protected SkinLoader skinLoader;
    protected NodeResolver nodeResolver;
    protected MeshLoader meshLoader;
    protected ImageResolver imageResolver;

    public GLTFLoaderBase() {
        this(null);
    }

    public GLTFLoaderBase(TextureResolver textureResolver) {
        this.textureResolver = textureResolver;
        this.animationLoader = new AnimationLoader();
        this.nodeResolver = new NodeResolver();
        this.meshLoader = new MeshLoader();
        this.skinLoader = new SkinLoader();
    }

    public SceneAsset load(DataFileResolver dataFileResolver, boolean withData) {
        try {
            this.dataFileResolver = dataFileResolver;
            this.glModel = dataFileResolver.getRoot();
            if (this.glModel.extensionsRequired != null) {
                for (String extension : this.glModel.extensionsRequired) {
                    if (supportedExtensions.contains((Object)extension)) continue;
                    throw new GLTFUnsupportedException("Extension " + extension + " required but not supported");
                }
            }
            if (this.glModel.extensionsUsed != null) {
                for (String extension : this.glModel.extensionsUsed) {
                    if (supportedExtensions.contains((Object)extension)) continue;
                    Gdx.app.error(TAG, "Extension " + extension + " used but not supported");
                }
            }
            this.dataResolver = new DataResolver(this.glModel, dataFileResolver);
            if (this.textureResolver == null) {
                this.imageResolver = new ImageResolver(dataFileResolver);
                this.imageResolver.load(this.glModel.images);
                this.textureResolver = new TextureResolver();
                this.textureResolver.loadTextures(this.glModel.textures, this.glModel.samplers, this.imageResolver);
            }
            this.materialLoader = this.createMaterialLoader(this.textureResolver);
            this.materialLoader.loadMaterials(this.glModel.materials);
            this.loadCameras();
            this.loadLights();
            this.loadScenes();
            this.animationLoader.load(this.glModel.animations, this.nodeResolver, this.dataResolver);
            this.skinLoader.load(this.glModel.skins, this.glModel.nodes, this.nodeResolver, this.dataResolver);
            SceneAsset model = new SceneAsset();
            if (withData) {
                model.data = this.glModel;
            }
            model.scenes = this.scenes;
            model.scene = (SceneModel)this.scenes.get(this.glModel.scene);
            model.maxBones = this.skinLoader.getMaxBones();
            model.textures = this.textureResolver.getTextures((Array<Texture>)new Array());
            if (this.imageResolver != null) {
                model.pixmaps = this.imageResolver.getPixmaps((Array<Pixmap>)new Array());
                this.imageResolver.clear();
            }
            model.animations = this.animationLoader.animations;
            for (SceneModel scene : model.scenes) {
                scene.model.animations.addAll(this.animationLoader.animations);
            }
            model.meshes = new Array();
            GLTFLoaderBase.copy(this.loadedMeshes, model.meshes);
            this.loadedMeshes.clear();
            return model;
        }
        catch (RuntimeException e) {
            this.dispose();
            throw e;
        }
    }

    protected MaterialLoader createMaterialLoader(TextureResolver textureResolver) {
        return new PBRMaterialLoader(textureResolver);
    }

    private void loadLights() {
        KHRLightsPunctual.GLTFLights lightExt;
        if (this.glModel.extensions != null && (lightExt = this.glModel.extensions.get(KHRLightsPunctual.GLTFLights.class, "KHR_lights_punctual")) != null) {
            for (KHRLightsPunctual.GLTFLight light : lightExt.lights) {
                this.lights.add((Object)KHRLightsPunctual.map(light));
            }
        }
    }

    public void dispose() {
        if (this.imageResolver != null) {
            this.imageResolver.dispose();
        }
        if (this.textureResolver != null) {
            this.textureResolver.dispose();
        }
        for (SceneModel scene : this.scenes) {
            scene.dispose();
        }
        for (IntMesh mesh : this.loadedMeshes) {
            mesh.dispose();
        }
        this.loadedMeshes.clear();
    }

    private void loadScenes() {
        for (int i = 0; i < this.glModel.scenes.size; ++i) {
            this.scenes.add((Object)this.loadScene((GLTFScene)this.glModel.scenes.get(i)));
        }
    }

    private void loadCameras() {
        if (this.glModel.cameras != null) {
            for (GLTFCamera glCamera : this.glModel.cameras) {
                this.cameras.add((Object)GLTFTypes.map(glCamera));
            }
        }
    }

    private SceneModel loadScene(GLTFScene gltfScene) {
        IntNode node;
        SceneModel sceneModel = new SceneModel();
        sceneModel.name = gltfScene.name;
        sceneModel.model = new IntModel();
        if (gltfScene.nodes != null) {
            Array.ArrayIterator arrayIterator = gltfScene.nodes.iterator();
            while (arrayIterator.hasNext()) {
                int id = (Integer)arrayIterator.next();
                sceneModel.model.nodes.add((Object)this.getNode(id));
            }
        }
        for (ObjectMap.Entry entry : this.cameraMap) {
            node = sceneModel.model.getNode((String)entry.key, true);
            if (node == null) continue;
            sceneModel.cameras.put((Object)node, (Object)((Camera)this.cameras.get(((Integer)entry.value).intValue())));
        }
        for (ObjectMap.Entry entry : this.lightMap) {
            node = sceneModel.model.getNode((String)entry.key, true);
            if (node == null) continue;
            sceneModel.lights.put((Object)node, (Object)((BaseLight)this.lights.get(((Integer)entry.value).intValue())));
        }
        this.collectData(sceneModel.model, (Iterable<IntNode>)sceneModel.model.nodes);
        this.loadedMeshes.addAll(meshSet);
        GLTFLoaderBase.copy(meshSet, sceneModel.model.meshes);
        GLTFLoaderBase.copy(meshPartSet, sceneModel.model.meshParts);
        GLTFLoaderBase.copy(materialSet, sceneModel.model.materials);
        sceneModel.model.computeSpan();
        meshSet.clear();
        meshPartSet.clear();
        materialSet.clear();
        return sceneModel;
    }

    private void collectData(IntModel model, Iterable<IntNode> nodes) {
        for (IntNode node : nodes) {
            for (IntNodePart part : node.parts) {
                meshSet.add((Object)part.meshPart.mesh);
                meshPartSet.add((Object)part.meshPart);
                materialSet.add((Object)part.material);
            }
            this.collectData(model, node.getChildren());
        }
    }

    private static <T> void copy(ObjectSet<T> src, Array<T> dst) {
        for (Object e : src) {
            dst.add(e);
        }
    }

    private IntNode getNode(int id) {
        IntNode node = this.nodeResolver.get(id);
        if (node == null) {
            KHRLightsPunctual.GLTFLightNode nodeLight;
            Matrix4 matrix;
            node = new NodePlus();
            this.nodeResolver.put(id, node);
            GLTFNode glNode = (GLTFNode)this.glModel.nodes.get(id);
            if (glNode.matrix != null) {
                matrix = new Matrix4(glNode.matrix);
                matrix.getTranslation(node.translation);
                matrix.getScale(node.scale);
                matrix.getRotation(node.rotation, true);
            } else {
                if (glNode.translation != null) {
                    GLTFTypes.map(node.translation, glNode.translation);
                }
                if (glNode.rotation != null) {
                    GLTFTypes.map(node.rotation, glNode.rotation);
                }
                if (glNode.scale != null) {
                    GLTFTypes.map(node.scale, glNode.scale);
                }
            }
            Object object = node.id = glNode.name == null ? "glNode " + id : glNode.name;
            if (glNode.children != null) {
                matrix = glNode.children.iterator();
                while (matrix.hasNext()) {
                    int childId = (Integer)matrix.next();
                    node.addChild(this.getNode(childId));
                }
            }
            if (glNode.mesh != null) {
                this.meshLoader.load(node, (GLTFMesh)this.glModel.meshes.get(glNode.mesh.intValue()), this.dataResolver, this.materialLoader);
            }
            if (glNode.camera != null) {
                this.cameraMap.put((Object)node.id, (Object)glNode.camera);
            }
            if (glNode.extensions != null && (nodeLight = glNode.extensions.get(KHRLightsPunctual.GLTFLightNode.class, "KHR_lights_punctual")) != null) {
                this.lightMap.put((Object)node.id, (Object)nodeLight.light);
            }
        }
        return node;
    }

    static {
        supportedExtensions.addAll((Object[])new String[]{"KHR_materials_pbrSpecularGlossiness", "KHR_texture_transform", "KHR_lights_punctual", "KHR_materials_unlit", "KHR_materials_transmission", "KHR_materials_volume", "KHR_materials_ior", "KHR_materials_specular", "KHR_materials_iridescence", "KHR_materials_emissive_strength"});
        materialSet = new ObjectSet();
        meshPartSet = new ObjectSet();
        meshSet = new ObjectSet();
    }
}

