/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.model.gltf.data.camera.GLTFCamera;
import gaiasky.util.gdx.model.gltf.data.data.GLTFAccessor;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFSampler;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFIllegalException;
import gaiasky.util.gdx.model.gltf.loaders.shared.animation.Interpolation;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicQuaternion;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicVector3;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicWeightVector;
import gaiasky.util.gdx.model.gltf.scene3d.model.WeightVector;
import net.jafama.FastMath;

public class GLTFTypes {
    public static final String TYPE_SCALAR = "SCALAR";
    public static final String TYPE_VEC2 = "VEC2";
    public static final String TYPE_VEC3 = "VEC3";
    public static final String TYPE_VEC4 = "VEC4";
    public static final String TYPE_MAT2 = "MAT2";
    public static final String TYPE_MAT3 = "MAT3";
    public static final String TYPE_MAT4 = "MAT4";
    public static final int C_BYTE = 5120;
    public static final int C_UBYTE = 5121;
    public static final int C_SHORT = 5122;
    public static final int C_USHORT = 5123;
    public static final int C_UINT = 5125;
    public static final int C_FLOAT = 5126;

    public static int mapPrimitiveMode(Integer glMode) {
        if (glMode == null) {
            return 4;
        }
        switch (glMode) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        throw new GLTFIllegalException("unsupported mode " + glMode);
    }

    public static Color mapColor(float[] c, Color defaultColor) {
        if (c == null) {
            return new Color(defaultColor);
        }
        if (c.length < 4) {
            return new Color(c[0], c[1], c[2], 1.0f);
        }
        return new Color(c[0], c[1], c[2], c[3]);
    }

    public static Quaternion map(Quaternion q, float[] fv) {
        return q.set(fv[0], fv[1], fv[2], fv[3]);
    }

    public static Quaternion map(Quaternion q, float[] fv, int offset) {
        return q.set(fv[offset + 0], fv[offset + 1], fv[offset + 2], fv[offset + 3]);
    }

    public static Vector3 map(Vector3 v, float[] fv) {
        return v.set(fv[0], fv[1], fv[2]);
    }

    public static Vector3 map(Vector3 v, float[] fv, int offset) {
        return v.set(fv[offset + 0], fv[offset + 1], fv[offset + 2]);
    }

    public static CubicVector3 map(CubicVector3 v, float[] fv, int offset) {
        v.tangentIn.set(fv[offset + 0], fv[offset + 1], fv[offset + 2]);
        v.set(fv[offset + 3], fv[offset + 4], fv[offset + 5]);
        v.tangentOut.set(fv[offset + 6], fv[offset + 7], fv[offset + 8]);
        return v;
    }

    public static CubicQuaternion map(CubicQuaternion v, float[] fv, int offset) {
        v.tangentIn.set(fv[offset + 0], fv[offset + 1], fv[offset + 2], fv[offset + 3]);
        v.set(fv[offset + 4], fv[offset + 5], fv[offset + 6], fv[offset + 7]);
        v.tangentOut.set(fv[offset + 8], fv[offset + 9], fv[offset + 10], fv[offset + 11]);
        return v;
    }

    public static WeightVector map(WeightVector w, float[] outputData, int offset) {
        for (int i = 0; i < w.count; ++i) {
            w.values[i] = outputData[offset + i];
        }
        return w;
    }

    public static CubicWeightVector map(CubicWeightVector w, float[] outputData, int offset) {
        int i;
        for (i = 0; i < w.count; ++i) {
            w.tangentIn.values[i] = outputData[offset + i];
        }
        offset += w.count;
        for (i = 0; i < w.count; ++i) {
            w.values[i] = outputData[offset + i];
        }
        offset += w.count;
        for (i = 0; i < w.count; ++i) {
            w.tangentOut.values[i] = outputData[offset + i];
        }
        return w;
    }

    public static int accessorTypeSize(GLTFAccessor accessor) {
        if (TYPE_SCALAR.equals(accessor.type)) {
            return 1;
        }
        if (TYPE_VEC2.equals(accessor.type)) {
            return 2;
        }
        if (TYPE_VEC3.equals(accessor.type)) {
            return 3;
        }
        if (TYPE_VEC4.equals(accessor.type)) {
            return 4;
        }
        if (TYPE_MAT2.equals(accessor.type)) {
            return 4;
        }
        if (TYPE_MAT3.equals(accessor.type)) {
            return 9;
        }
        if (TYPE_MAT4.equals(accessor.type)) {
            return 16;
        }
        throw new GLTFIllegalException("illegal accessor type: " + accessor.type);
    }

    public static int accessorComponentTypeSize(GLTFAccessor accessor) {
        switch (accessor.componentType) {
            case 5120: 
            case 5121: {
                return 1;
            }
            case 5122: 
            case 5123: {
                return 2;
            }
            case 5125: 
            case 5126: {
                return 4;
            }
        }
        throw new GLTFIllegalException("illegal accessor component type: " + accessor.componentType);
    }

    public static int accessorStrideSize(GLTFAccessor accessor) {
        return GLTFTypes.accessorTypeSize(accessor) * GLTFTypes.accessorComponentTypeSize(accessor);
    }

    public static int accessorSize(GLTFAccessor accessor) {
        return GLTFTypes.accessorStrideSize(accessor) * accessor.count;
    }

    public static Camera map(GLTFCamera glCamera) {
        if ("perspective".equals(glCamera.type)) {
            float znear = glCamera.perspective.znear;
            float zfar = glCamera.perspective.zfar != null ? glCamera.perspective.zfar.floatValue() : znear * 16384.0f;
            float canvasRatio = (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight();
            float aspectRatio = glCamera.perspective.aspectRatio != null ? glCamera.perspective.aspectRatio.floatValue() : canvasRatio;
            float yfov = (float)FastMath.atan((double)(Math.tan((double)glCamera.perspective.yfov * 0.5) * (double)aspectRatio / (double)canvasRatio)) * 2.0f;
            PerspectiveCamera camera = new PerspectiveCamera();
            camera.fieldOfView = yfov * 57.295776f;
            camera.near = znear;
            camera.far = zfar;
            camera.viewportWidth = Gdx.graphics.getWidth();
            camera.viewportHeight = Gdx.graphics.getHeight();
            return camera;
        }
        if ("orthographic".equals(glCamera.type)) {
            OrthographicCamera camera = new OrthographicCamera();
            camera.near = glCamera.orthographic.znear.floatValue();
            camera.far = glCamera.orthographic.zfar.floatValue();
            float canvasRatio = (float)Gdx.graphics.getWidth() / (float)Gdx.graphics.getHeight();
            camera.viewportWidth = glCamera.orthographic.xmag.floatValue();
            camera.viewportHeight = glCamera.orthographic.ymag.floatValue() / canvasRatio;
            return camera;
        }
        throw new GLTFIllegalException("unknown camera type " + glCamera.type);
    }

    public static void mapTextureSampler(TextureDescriptor<Texture> textureDescriptor, GLTFSampler glSampler) {
        textureDescriptor.minFilter = GLTFTypes.mapTextureMinFilter(glSampler.minFilter);
        textureDescriptor.magFilter = GLTFTypes.mapTextureMagFilter(glSampler.magFilter);
        textureDescriptor.uWrap = GLTFTypes.mapTextureWrap(glSampler.wrapS);
        textureDescriptor.vWrap = GLTFTypes.mapTextureWrap(glSampler.wrapT);
    }

    public static void mapTextureSampler(TextureLoader.TextureParameter textureParameter, GLTFSampler glSampler) {
        textureParameter.minFilter = GLTFTypes.mapTextureMinFilter(glSampler.minFilter);
        textureParameter.magFilter = GLTFTypes.mapTextureMagFilter(glSampler.magFilter);
        textureParameter.wrapU = GLTFTypes.mapTextureWrap(glSampler.wrapS);
        textureParameter.wrapV = GLTFTypes.mapTextureWrap(glSampler.wrapT);
    }

    public static void mapTextureSampler(TextureLoader.TextureParameter textureParameter) {
        textureParameter.minFilter = GLTFTypes.mapTextureMinFilter(null);
        textureParameter.magFilter = GLTFTypes.mapTextureMagFilter(null);
        textureParameter.wrapU = GLTFTypes.mapTextureWrap(null);
        textureParameter.wrapV = GLTFTypes.mapTextureWrap(null);
    }

    private static Texture.TextureWrap mapTextureWrap(Integer wrap) {
        if (wrap == null) {
            return Texture.TextureWrap.Repeat;
        }
        switch (wrap) {
            case 33071: {
                return Texture.TextureWrap.ClampToEdge;
            }
            case 33648: {
                return Texture.TextureWrap.MirroredRepeat;
            }
            case 10497: {
                return Texture.TextureWrap.Repeat;
            }
        }
        throw new GLTFIllegalException("unexpected texture wrap " + wrap);
    }

    public static Texture.TextureFilter mapTextureMagFilter(Integer filter) {
        if (filter == null) {
            return Texture.TextureFilter.Linear;
        }
        switch (filter) {
            case 9728: {
                return Texture.TextureFilter.Nearest;
            }
            case 9729: {
                return Texture.TextureFilter.Linear;
            }
        }
        throw new GLTFIllegalException("unexpected texture mag filter " + filter);
    }

    public static Texture.TextureFilter mapTextureMinFilter(Integer filter) {
        if (filter == null) {
            return Texture.TextureFilter.Linear;
        }
        switch (filter) {
            case 9728: {
                return Texture.TextureFilter.Nearest;
            }
            case 9729: {
                return Texture.TextureFilter.Linear;
            }
            case 9984: {
                return Texture.TextureFilter.MipMapNearestNearest;
            }
            case 9985: {
                return Texture.TextureFilter.MipMapLinearNearest;
            }
            case 9986: {
                return Texture.TextureFilter.MipMapNearestLinear;
            }
            case 9987: {
                return Texture.TextureFilter.MipMapLinearLinear;
            }
        }
        throw new GLTFIllegalException("unexpected texture mag filter " + filter);
    }

    public static boolean isMipMapFilter(GLTFSampler sampler) {
        Texture.TextureFilter filter = GLTFTypes.mapTextureMinFilter(sampler.minFilter);
        switch (filter) {
            case Nearest: 
            case Linear: {
                return false;
            }
            case MipMapNearestNearest: 
            case MipMapLinearNearest: 
            case MipMapNearestLinear: 
            case MipMapLinearLinear: {
                return true;
            }
        }
        throw new GLTFIllegalException("unexpected texture min filter " + String.valueOf(filter));
    }

    public static Interpolation mapInterpolation(String type) {
        if (type == null) {
            return Interpolation.LINEAR;
        }
        if ("LINEAR".equals(type)) {
            return Interpolation.LINEAR;
        }
        if ("STEP".equals(type)) {
            return Interpolation.STEP;
        }
        if ("CUBICSPLINE".equals(type)) {
            return Interpolation.CUBICSPLINE;
        }
        throw new GLTFIllegalException("unexpected interpolation type " + type);
    }
}

