/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.animation;

import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.model.IntAnimation;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodeAnimation;
import gaiasky.util.gdx.model.gltf.data.animation.GLTFAnimation;
import gaiasky.util.gdx.model.gltf.data.animation.GLTFAnimationChannel;
import gaiasky.util.gdx.model.gltf.data.animation.GLTFAnimationSampler;
import gaiasky.util.gdx.model.gltf.data.data.GLTFAccessor;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFUnsupportedException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.animation.Interpolation;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.scene.NodeResolver;
import gaiasky.util.gdx.model.gltf.scene3d.animation.NodeAnimationHack;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicQuaternion;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicVector3;
import gaiasky.util.gdx.model.gltf.scene3d.model.CubicWeightVector;
import gaiasky.util.gdx.model.gltf.scene3d.model.NodePlus;
import gaiasky.util.gdx.model.gltf.scene3d.model.WeightVector;
import net.jafama.FastMath;

public class AnimationLoader {
    public final Array<IntAnimation> animations = new Array();

    public void load(Array<GLTFAnimation> glAnimations, NodeResolver nodeResolver, DataResolver dataResolver) {
        if (glAnimations != null) {
            for (int i = 0; i < glAnimations.size; ++i) {
                GLTFAnimation glAnimation = (GLTFAnimation)glAnimations.get(i);
                IntAnimation animation = this.load(glAnimation, nodeResolver, dataResolver);
                animation.id = glAnimation.name == null ? "animation" + i : glAnimation.name;
                this.animations.add((Object)animation);
            }
        }
    }

    private IntAnimation load(GLTFAnimation glAnimation, NodeResolver nodeResolver, DataResolver dataResolver) {
        ObjectMap animMap = new ObjectMap();
        IntAnimation animation = new IntAnimation();
        for (GLTFAnimationChannel glChannel : glAnimation.channels) {
            GLTFAnimationSampler glSampler = (GLTFAnimationSampler)glAnimation.samplers.get(glChannel.sampler.intValue());
            IntNode node = nodeResolver.get(glChannel.target.node);
            IntNodeAnimation nodeAnimation = (IntNodeAnimation)animMap.get((Object)node);
            if (nodeAnimation == null) {
                nodeAnimation = new NodeAnimationHack();
                nodeAnimation.node = node;
                animMap.put((Object)node, (Object)nodeAnimation);
                animation.nodeAnimations.add((Object)nodeAnimation);
            }
            float[] inputData = dataResolver.readBufferFloat(glSampler.input);
            float[] outputData = dataResolver.readBufferFloat(glSampler.output);
            Interpolation interpolation = GLTFTypes.mapInterpolation(glSampler.interpolation);
            int dataOffset = 0;
            int dataStride = 1;
            if (interpolation == Interpolation.CUBICSPLINE) {
                dataOffset = 1;
                dataStride = 3;
            }
            GLTFAccessor inputAccessor = dataResolver.getAccessor(glSampler.input);
            animation.duration = FastMath.max((float)animation.duration, (float)inputAccessor.max[0]);
            String property = glChannel.target.path;
            if ("translation".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).translationMode = interpolation;
                nodeAnimation.translation = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.translation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicVector3(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.translation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicVector3(), outputData, k * dataStride * 3)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.translation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Vector3(), outputData, dataOffset * 3)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.translation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Vector3(), outputData, (dataOffset + k * dataStride) * 3)));
                }
                continue;
            }
            if ("rotation".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).rotationMode = interpolation;
                nodeAnimation.rotation = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.rotation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicQuaternion(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.rotation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicQuaternion(), outputData, k * dataStride * 4)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.rotation.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Quaternion(), outputData, dataOffset * 4)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.rotation.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Quaternion(), outputData, (dataOffset + k * dataStride) * 4)));
                }
                continue;
            }
            if ("scale".equals(property)) {
                ((NodeAnimationHack)nodeAnimation).scalingMode = interpolation;
                nodeAnimation.scaling = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        nodeAnimation.scaling.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicVector3(), outputData, 0)));
                    }
                    for (int k = 0; k < inputData.length; ++k) {
                        nodeAnimation.scaling.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicVector3(), outputData, k * dataStride * 3)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    nodeAnimation.scaling.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new Vector3(), outputData, dataOffset * 3)));
                }
                for (int k = 0; k < inputData.length; ++k) {
                    nodeAnimation.scaling.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new Vector3(), outputData, (dataOffset + k * dataStride) * 3)));
                }
                continue;
            }
            if ("weights".equals(property)) {
                int k;
                ((NodeAnimationHack)nodeAnimation).weightsMode = interpolation;
                NodeAnimationHack np = (NodeAnimationHack)nodeAnimation;
                int nbWeights = ((NodePlus)node).weights.count;
                np.weights = new Array();
                if (interpolation == Interpolation.CUBICSPLINE) {
                    if (inputData[0] > 0.0f) {
                        np.weights.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new CubicWeightVector(nbWeights), outputData, 0)));
                    }
                    for (k = 0; k < inputData.length; ++k) {
                        np.weights.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new CubicWeightVector(nbWeights), outputData, k * dataStride * nbWeights)));
                    }
                    continue;
                }
                if (inputData[0] > 0.0f) {
                    np.weights.add((Object)new NodeKeyframe(0.0f, (Object)GLTFTypes.map(new WeightVector(nbWeights), outputData, dataOffset * nbWeights)));
                }
                for (k = 0; k < inputData.length; ++k) {
                    np.weights.add((Object)new NodeKeyframe(inputData[k], (Object)GLTFTypes.map(new WeightVector(nbWeights), outputData, (dataOffset + k * dataStride) * nbWeights)));
                }
                continue;
            }
            throw new GLTFUnsupportedException("unsupported " + property);
        }
        return animation;
    }
}

