/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.data;

import gaiasky.util.gdx.model.gltf.data.GLTF;
import gaiasky.util.gdx.model.gltf.data.data.GLTFAccessor;
import gaiasky.util.gdx.model.gltf.data.data.GLTFBufferView;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataFileResolver;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public class DataResolver {
    private final GLTF glModel;
    private final DataFileResolver dataFileResolver;

    public DataResolver(GLTF glModel, DataFileResolver dataFileResolver) {
        this.glModel = glModel;
        this.dataFileResolver = dataFileResolver;
    }

    public GLTFAccessor getAccessor(int accessorID) {
        return (GLTFAccessor)this.glModel.accessors.get(accessorID);
    }

    public float[] readBufferFloat(int accessorID) {
        GLTFAccessor accessor = (GLTFAccessor)this.glModel.accessors.get(accessorID);
        GLTFBufferView bufferView = (GLTFBufferView)this.glModel.bufferViews.get(accessor.bufferView.intValue());
        ByteBuffer bytes = this.dataFileResolver.getBuffer(bufferView.buffer);
        bytes.position(bufferView.byteOffset + accessor.byteOffset);
        float[] data = new float[GLTFTypes.accessorSize(accessor) / 4];
        int nbFloatsPerVertex = GLTFTypes.accessorTypeSize(accessor);
        int nbBytesToSkip = 0;
        if (bufferView.byteStride != null) {
            nbBytesToSkip = bufferView.byteStride - nbFloatsPerVertex * 4;
        }
        if (nbBytesToSkip == 0) {
            bytes.asFloatBuffer().get(data);
        } else {
            for (int i = 0; i < accessor.count; ++i) {
                for (int j = 0; j < nbFloatsPerVertex; ++j) {
                    data[i * nbFloatsPerVertex + j] = bytes.getFloat();
                }
                bytes.position(bytes.position() + nbBytesToSkip);
            }
        }
        return data;
    }

    public int[] readBufferUByte(int accessorID) {
        GLTFAccessor accessor = (GLTFAccessor)this.glModel.accessors.get(accessorID);
        GLTFBufferView bufferView = (GLTFBufferView)this.glModel.bufferViews.get(accessor.bufferView.intValue());
        ByteBuffer bytes = this.dataFileResolver.getBuffer(bufferView.buffer);
        bytes.position(bufferView.byteOffset + accessor.byteOffset);
        int[] data = new int[GLTFTypes.accessorSize(accessor)];
        int nbBytesPerVertex = GLTFTypes.accessorTypeSize(accessor);
        int nbBytesToSkip = 0;
        if (bufferView.byteStride != null) {
            nbBytesToSkip = bufferView.byteStride - nbBytesPerVertex;
        }
        if (nbBytesToSkip == 0) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = bytes.get() & 0xFF;
            }
        } else {
            for (int i = 0; i < accessor.count; ++i) {
                for (int j = 0; j < nbBytesPerVertex; ++j) {
                    data[i * nbBytesPerVertex + j] = bytes.get() & 0xFF;
                }
                bytes.position(bytes.position() + nbBytesToSkip);
            }
        }
        return data;
    }

    public int[] readBufferUShort(int accessorID) {
        GLTFAccessor accessor = (GLTFAccessor)this.glModel.accessors.get(accessorID);
        GLTFBufferView bufferView = (GLTFBufferView)this.glModel.bufferViews.get(accessor.bufferView.intValue());
        ByteBuffer bytes = this.dataFileResolver.getBuffer(bufferView.buffer);
        bytes.position(bufferView.byteOffset + accessor.byteOffset);
        int[] data = new int[GLTFTypes.accessorSize(accessor) / 2];
        int nbShortsPerVertex = GLTFTypes.accessorTypeSize(accessor);
        int nbBytesToSkip = 0;
        if (bufferView.byteStride != null) {
            nbBytesToSkip = bufferView.byteStride - nbShortsPerVertex * 2;
        }
        if (nbBytesToSkip == 0) {
            ShortBuffer shorts = bytes.asShortBuffer();
            for (int i = 0; i < data.length; ++i) {
                data[i] = shorts.get() & 0xFFFF;
            }
        } else {
            for (int i = 0; i < accessor.count; ++i) {
                for (int j = 0; j < nbShortsPerVertex; ++j) {
                    data[i * nbShortsPerVertex + j] = bytes.getShort() & 0xFFFF;
                }
                bytes.position(bytes.position() + nbBytesToSkip);
            }
        }
        return data;
    }

    public float[] readBufferUShortAsFloat(int accessorID) {
        int[] intBuffer = this.readBufferUShort(accessorID);
        float[] floatBuffer = new float[intBuffer.length];
        for (int i = 0; i < intBuffer.length; ++i) {
            floatBuffer[i] = (float)intBuffer[i] / 65535.0f;
        }
        return floatBuffer;
    }

    public float[] readBufferUByteAsFloat(int accessorID) {
        int[] intBuffer = this.readBufferUByte(accessorID);
        float[] floatBuffer = new float[intBuffer.length];
        for (int i = 0; i < intBuffer.length; ++i) {
            floatBuffer[i] = (float)intBuffer[i] / 255.0f;
        }
        return floatBuffer;
    }

    public FloatBuffer getBufferFloat(int accessorID) {
        return this.getBufferFloat((GLTFAccessor)this.glModel.accessors.get(accessorID));
    }

    public GLTFBufferView getBufferView(int bufferViewID) {
        return (GLTFBufferView)this.glModel.bufferViews.get(bufferViewID);
    }

    public FloatBuffer getBufferFloat(GLTFAccessor glAccessor) {
        return this.getBufferByte(glAccessor).asFloatBuffer();
    }

    public IntBuffer getBufferInt(GLTFAccessor glAccessor) {
        return this.getBufferByte(glAccessor).asIntBuffer();
    }

    public ShortBuffer getBufferShort(GLTFAccessor glAccessor) {
        return this.getBufferByte(glAccessor).asShortBuffer();
    }

    public ByteBuffer getBufferByte(GLTFAccessor glAccessor) {
        GLTFBufferView bufferView = (GLTFBufferView)this.glModel.bufferViews.get(glAccessor.bufferView.intValue());
        ByteBuffer bytes = this.dataFileResolver.getBuffer(bufferView.buffer);
        bytes.position(bufferView.byteOffset + glAccessor.byteOffset);
        return bytes;
    }

    public ByteBuffer getBufferByte(GLTFBufferView bufferView) {
        ByteBuffer bytes = this.dataFileResolver.getBuffer(bufferView.buffer);
        bytes.position(bufferView.byteOffset);
        return bytes;
    }
}

