/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.geometry;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.IntMeshPart;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.model.gltf.data.data.GLTFAccessor;
import gaiasky.util.gdx.model.gltf.data.geometry.GLTFMesh;
import gaiasky.util.gdx.model.gltf.data.geometry.GLTFMorphTarget;
import gaiasky.util.gdx.model.gltf.data.geometry.GLTFPrimitive;
import gaiasky.util.gdx.model.gltf.loaders.blender.BlenderShapeKeys;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFIllegalException;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFUnsupportedException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.geometry.MeshTangentSpaceGenerator;
import gaiasky.util.gdx.model.gltf.loaders.shared.material.MaterialLoader;
import gaiasky.util.gdx.model.gltf.scene3d.model.NodePartPlus;
import gaiasky.util.gdx.model.gltf.scene3d.model.NodePlus;
import gaiasky.util.gdx.model.gltf.scene3d.model.WeightVector;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;

public class MeshLoader {
    private final ObjectMap<GLTFMesh, Array<IntNodePart>> meshMap = new ObjectMap();
    private final Array<IntMesh> meshes = new Array();

    /*
     * Unable to fully structure code
     */
    public void load(IntNode node, GLTFMesh glMesh, DataResolver dataResolver, MaterialLoader materialLoader) {
        block50: {
            ((NodePlus)node).morphTargetNames = BlenderShapeKeys.parse(glMesh);
            parts = (Array)this.meshMap.get((Object)glMesh);
            if (parts != null) break block50;
            parts = new Array();
            for (GLTFPrimitive primitive : glMesh.primitives) {
                glPrimitiveType = GLTFTypes.mapPrimitiveMode(primitive.mode);
                material = primitive.material != null ? materialLoader.get(primitive.material) : materialLoader.getDefaultMaterial();
                vertexAttributes = new Array();
                glAccessors = new Array();
                bonesIndices = new Array();
                bonesWeights = new Array();
                hasNormals = false;
                hasTangent = false;
                for (ObjectMap.Entry attribute : primitive.attributes) {
                    block52: {
                        block63: {
                            block66: {
                                block65: {
                                    block64: {
                                        block56: {
                                            block61: {
                                                block62: {
                                                    block57: {
                                                        block60: {
                                                            block59: {
                                                                block58: {
                                                                    block55: {
                                                                        block54: {
                                                                            block53: {
                                                                                block51: {
                                                                                    attributeName = (String)attribute.key;
                                                                                    accessorId = (Integer)attribute.value;
                                                                                    accessor = dataResolver.getAccessor(accessorId);
                                                                                    rawAttribute = true;
                                                                                    if (!attributeName.equals("POSITION")) break block51;
                                                                                    if (!"VEC3".equals(accessor.type) || accessor.componentType != 5126) {
                                                                                        throw new GLTFIllegalException("illegal position attribute format");
                                                                                    }
                                                                                    vertexAttributes.add((Object)VertexAttribute.Position());
                                                                                    break block52;
                                                                                }
                                                                                if (!attributeName.equals("NORMAL")) break block53;
                                                                                if (!"VEC3".equals(accessor.type) || accessor.componentType != 5126) {
                                                                                    throw new GLTFIllegalException("illegal normal attribute format");
                                                                                }
                                                                                vertexAttributes.add((Object)VertexAttribute.Normal());
                                                                                hasNormals = true;
                                                                                break block52;
                                                                            }
                                                                            if (!attributeName.equals("TANGENT")) break block54;
                                                                            if (!"VEC4".equals(accessor.type) || accessor.componentType != 5126) {
                                                                                throw new GLTFIllegalException("illegal tangent attribute format");
                                                                            }
                                                                            vertexAttributes.add((Object)new VertexAttribute(128, 4, "a_tangent"));
                                                                            hasTangent = true;
                                                                            break block52;
                                                                        }
                                                                        if (!attributeName.startsWith("TEXCOORD_")) break block55;
                                                                        if (!"VEC2".equals(accessor.type)) {
                                                                            throw new GLTFIllegalException("illegal texture coordinate attribute type : " + accessor.type);
                                                                        }
                                                                        if (accessor.componentType == 5121) {
                                                                            throw new GLTFUnsupportedException("unsigned byte texture coordinate attribute not supported");
                                                                        }
                                                                        if (accessor.componentType == 5123) {
                                                                            throw new GLTFUnsupportedException("unsigned short texture coordinate attribute not supported");
                                                                        }
                                                                        if (accessor.componentType != 5126) {
                                                                            throw new GLTFIllegalException("illegal texture coordinate component type : " + accessor.componentType);
                                                                        }
                                                                        unit = this.parseAttributeUnit(attributeName);
                                                                        vertexAttributes.add((Object)VertexAttribute.TexCoords((int)unit));
                                                                        break block52;
                                                                    }
                                                                    if (!attributeName.startsWith("COLOR_")) break block56;
                                                                    unit = this.parseAttributeUnit(attributeName);
                                                                    v0 = alias = unit > 0 ? "a_color" + unit : "a_color";
                                                                    if (!"VEC4".equals(accessor.type)) break block57;
                                                                    if (5126 != accessor.componentType) break block58;
                                                                    vertexAttributes.add((Object)new VertexAttribute(2, 4, 5126, false, (String)alias));
                                                                    break block52;
                                                                }
                                                                if (5123 != accessor.componentType) break block59;
                                                                vertexAttributes.add((Object)new VertexAttribute(2, 4, 5123, true, (String)alias));
                                                                break block52;
                                                            }
                                                            if (5121 != accessor.componentType) break block60;
                                                            vertexAttributes.add((Object)new VertexAttribute(2, 4, 5121, true, (String)alias));
                                                            break block52;
                                                        }
                                                        throw new GLTFIllegalException("illegal color attribute component type: " + accessor.type);
                                                    }
                                                    if (!"VEC3".equals(accessor.type)) break block61;
                                                    if (5126 != accessor.componentType) break block62;
                                                    vertexAttributes.add((Object)new VertexAttribute(2, 3, 5126, false, (String)alias));
                                                    break block52;
                                                }
                                                if (5123 == accessor.componentType) {
                                                    throw new GLTFUnsupportedException("RGB unsigned short color attribute not supported");
                                                }
                                                if (5121 == accessor.componentType) {
                                                    throw new GLTFUnsupportedException("RGB unsigned byte color attribute not supported");
                                                }
                                                throw new GLTFIllegalException("illegal color attribute component type: " + accessor.type);
                                            }
                                            throw new GLTFIllegalException("illegal color attribute type: " + accessor.type);
                                        }
                                        if (!attributeName.startsWith("WEIGHTS_")) break block63;
                                        rawAttribute = false;
                                        if (!"VEC4".equals(accessor.type)) {
                                            throw new GLTFIllegalException("illegal weight attribute type: " + accessor.type);
                                        }
                                        unit = this.parseAttributeUnit(attributeName);
                                        if (unit >= bonesWeights.size) {
                                            bonesWeights.setSize(unit + 1);
                                        }
                                        if (accessor.componentType != 5126) break block64;
                                        bonesWeights.set(unit, (Object)dataResolver.readBufferFloat(accessorId));
                                        break block52;
                                    }
                                    if (accessor.componentType != 5123) break block65;
                                    bonesWeights.set(unit, (Object)dataResolver.readBufferUShortAsFloat(accessorId));
                                    break block52;
                                }
                                if (accessor.componentType != 5121) break block66;
                                bonesWeights.set(unit, (Object)dataResolver.readBufferUByteAsFloat(accessorId));
                                break block52;
                            }
                            throw new GLTFIllegalException("illegal weight attribute type: " + accessor.componentType);
                        }
                        if (!attributeName.startsWith("JOINTS_")) ** GOTO lbl120
                        rawAttribute = false;
                        if (!"VEC4".equals(accessor.type)) {
                            throw new GLTFIllegalException("illegal joints attribute type: " + accessor.type);
                        }
                        unit = this.parseAttributeUnit(attributeName);
                        if (unit >= bonesIndices.size) {
                            bonesIndices.setSize(unit + 1);
                        }
                        if (accessor.componentType == 5121) {
                            bonesIndices.set(unit, (Object)dataResolver.readBufferUByte(accessorId));
                        } else if (accessor.componentType == 5123) {
                            bonesIndices.set(unit, (Object)dataResolver.readBufferUShort(accessorId));
                        } else {
                            throw new GLTFIllegalException("illegal type for joints: " + accessor.componentType);
lbl120:
                            // 1 sources

                            if (attributeName.startsWith("_")) {
                                Gdx.app.error("GLTF", "skip unsupported custom attribute: " + attributeName);
                            } else {
                                throw new GLTFIllegalException("illegal attribute type " + attributeName);
                            }
                        }
                    }
                    if (!rawAttribute) continue;
                    glAccessors.add((Object)accessor);
                }
                if (primitive.targets != null) {
                    morphTargetCount = primitive.targets.size;
                    ((NodePlus)node).weights = new WeightVector(morphTargetCount);
                    for (t = 0; t < primitive.targets.size; ++t) {
                        unit = t;
                        accessorId = ((GLTFMorphTarget)primitive.targets.get(t)).iterator();
                        while (accessorId.hasNext()) {
                            attribute = (ObjectMap.Entry)accessorId.next();
                            attributeName = (String)attribute.key;
                            accessorId = (Integer)attribute.value;
                            accessor = dataResolver.getAccessor(accessorId);
                            glAccessors.add((Object)accessor);
                            if (attributeName.equals("POSITION")) {
                                if (!"VEC3".equals(accessor.type) || accessor.componentType != 5126) {
                                    throw new GLTFIllegalException("illegal morph target position attribute format");
                                }
                                vertexAttributes.add((Object)new VertexAttribute(512, 3, "a_position" + unit, unit));
                                continue;
                            }
                            if (attributeName.equals("NORMAL")) {
                                if (!"VEC3".equals(accessor.type) || accessor.componentType != 5126) {
                                    throw new GLTFIllegalException("illegal morph target normal attribute format");
                                }
                                vertexAttributes.add((Object)new VertexAttribute(1024, 3, "a_normal" + unit, unit));
                                continue;
                            }
                            if (attributeName.equals("TANGENT")) {
                                if (!"VEC3".equals(accessor.type) || accessor.componentType != 5126) {
                                    throw new GLTFIllegalException("illegal morph target tangent attribute format");
                                }
                                vertexAttributes.add((Object)new VertexAttribute(2048, 3, "a_tangent" + unit, unit));
                                continue;
                            }
                            throw new GLTFIllegalException("illegal morph target attribute type " + attributeName);
                        }
                    }
                }
                bSize = bonesIndices.size * 4;
                bonesAttributes = new Array();
                for (b = 0; b < bSize; ++b) {
                    boneAttribute = VertexAttribute.BoneWeight((int)b);
                    vertexAttributes.add((Object)boneAttribute);
                    bonesAttributes.add((Object)boneAttribute);
                }
                computeNormals = false;
                computeTangents = false;
                normalMapUVs = null;
                if (glPrimitiveType == 4) {
                    if (!hasNormals) {
                        vertexAttributes.add((Object)VertexAttribute.Normal());
                        glAccessors.add(null);
                        computeNormals = true;
                    }
                    if (!hasTangent && (normalMap = material.get(TextureAttribute.class, TextureAttribute.Normal)) != null) {
                        vertexAttributes.add((Object)new VertexAttribute(128, 4, "a_tangent"));
                        glAccessors.add(null);
                        computeTangents = true;
                        for (VertexAttribute attribute : vertexAttributes) {
                            if (attribute.usage != 16 || attribute.unit != normalMap.uvIndex) continue;
                            normalMapUVs = attribute;
                        }
                        if (normalMapUVs == null) {
                            throw new GLTFIllegalException("UVs not found for normal map");
                        }
                    }
                }
                attributesGroup = new VertexAttributes((VertexAttribute[])vertexAttributes.toArray(VertexAttribute.class));
                vertexFloats = attributesGroup.vertexSize / 4;
                maxVertices = ((GLTFAccessor)glAccessors.first()).count;
                vertices = new float[maxVertices * vertexFloats];
                for (b = 0; b < bSize; ++b) {
                    boneAttribute = (VertexAttribute)bonesAttributes.get(b);
                    for (i = 0; i < maxVertices; ++i) {
                        vertices[i * vertexFloats + boneAttribute.offset / 4] = ((int[])bonesIndices.get(b / 4))[i * 4 + b % 4];
                        vertices[i * vertexFloats + boneAttribute.offset / 4 + 1] = ((float[])bonesWeights.get(b / 4))[i * 4 + b % 4];
                    }
                }
                for (i = 0; i < glAccessors.size; ++i) {
                    glAccessor = (GLTFAccessor)glAccessors.get(i);
                    attribute = (VertexAttribute)vertexAttributes.get(i);
                    if (glAccessor == null) continue;
                    if (glAccessor.bufferView == null) {
                        throw new GLTFIllegalException("bufferView is null (mesh compression ?)");
                    }
                    glBufferView = dataResolver.getBufferView(glAccessor.bufferView);
                    floatBuffer = dataResolver.getBufferFloat(glAccessor);
                    attributeFloats = GLTFTypes.accessorStrideSize(glAccessor) / 4;
                    floatStride = glBufferView.byteStride == null ? attributeFloats : glBufferView.byteStride / 4;
                    for (j = 0; j < glAccessor.count; ++j) {
                        floatBuffer.position(j * floatStride);
                        vIndex = j * vertexFloats + attribute.offset / 4;
                        floatBuffer.get(vertices, vIndex, attributeFloats);
                    }
                }
                if (primitive.indices != null) {
                    indicesAccessor = dataResolver.getAccessor(primitive.indices);
                    if (!indicesAccessor.type.equals("SCALAR")) {
                        throw new GLTFIllegalException("indices accessor must be SCALAR but was " + indicesAccessor.type);
                    }
                    maxIndices = indicesAccessor.count;
                    switch (indicesAccessor.componentType) {
                        case 5125: {
                            indices = new int[maxIndices];
                            dataResolver.getBufferInt(indicesAccessor).get(indices);
                            this.generateParts(node, (Array<IntNodePart>)parts, material, glMesh.name, vertices, maxVertices, indices, attributesGroup, glPrimitiveType, computeNormals, computeTangents, normalMapUVs);
                            break;
                        }
                        case 5122: 
                        case 5123: {
                            indicesAux = new short[maxIndices];
                            dataResolver.getBufferShort(indicesAccessor).get(indicesAux);
                            indices = new int[indicesAux.length];
                            for (i = 0; i < indicesAux.length; ++i) {
                                indices[i] = indicesAux[i];
                            }
                            this.generateParts(node, (Array<IntNodePart>)parts, material, glMesh.name, vertices, maxVertices, indices, attributesGroup, glPrimitiveType, computeNormals, computeTangents, normalMapUVs);
                            break;
                        }
                        case 5121: {
                            indices = new int[maxIndices];
                            byteBuffer = dataResolver.getBufferByte(indicesAccessor);
                            for (i = 0; i < maxIndices; ++i) {
                                indices[i] = byteBuffer.get() & 65535;
                            }
                            this.generateParts(node, (Array<IntNodePart>)parts, material, glMesh.name, vertices, maxVertices, indices, attributesGroup, glPrimitiveType, computeNormals, computeTangents, normalMapUVs);
                            break;
                        }
                        default: {
                            throw new GLTFIllegalException("illegal componentType " + indicesAccessor.componentType);
                        }
                    }
                    continue;
                }
                this.generateParts(node, (Array<IntNodePart>)parts, material, glMesh.name, vertices, maxVertices, null, attributesGroup, glPrimitiveType, computeNormals, computeTangents, normalMapUVs);
            }
            this.meshMap.put((Object)glMesh, (Object)parts);
        }
        node.parts.addAll(parts);
    }

    private void generateParts(IntNode node, Array<IntNodePart> parts, Material material, String id, float[] vertices, int vertexCount, int[] indices, VertexAttributes attributesGroup, int glPrimitiveType, boolean computeNormals, boolean computeTangents, VertexAttribute normalMapUVs) {
        if (vertices.length == 0 || indices != null && indices.length == 0) {
            return;
        }
        if (computeNormals || computeTangents) {
            if (computeNormals && computeTangents) {
                Gdx.app.log("GLTF", "compute normals and tangents for primitive " + id);
            } else if (computeTangents) {
                Gdx.app.log("GLTF", "compute tangents for primitive " + id);
            } else {
                Gdx.app.log("GLTF", "compute normals for primitive " + id);
            }
            MeshTangentSpaceGenerator.computeTangentSpace(vertices, indices, attributesGroup, computeNormals, computeTangents, normalMapUVs);
        }
        IntMesh mesh = new IntMesh(true, vertexCount, indices == null ? 0 : indices.length, attributesGroup);
        this.meshes.add((Object)mesh);
        mesh.setVertices(vertices);
        if (indices != null) {
            mesh.setIndices(indices);
        }
        int len = indices == null ? vertexCount : indices.length;
        IntMeshPart meshPart = new IntMeshPart(id, mesh, 0, len, glPrimitiveType);
        NodePartPlus nodePart = new NodePartPlus();
        nodePart.morphTargets = ((NodePlus)node).weights;
        nodePart.meshPart = meshPart;
        nodePart.material = material;
        parts.add((Object)nodePart);
    }

    private int parseAttributeUnit(String attributeName) {
        int lastUnderscoreIndex = attributeName.lastIndexOf(95);
        try {
            return Integer.parseInt(attributeName.substring(lastUnderscoreIndex + 1));
        }
        catch (NumberFormatException e) {
            throw new GLTFIllegalException("illegal attribute name " + attributeName);
        }
    }

    public Array<? extends IntMesh> getMeshes() {
        return this.meshes;
    }
}

