/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.geometry;

import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.IntMap;
import net.jafama.FastMath;

class MeshSpliter {
    MeshSpliter() {
    }

    public static void split(Array<float[]> splitVertices, Array<short[]> splitIndices, float[] vertices, VertexAttributes attributes, int[] indices, int verticesPerPrimitive) {
        int i;
        int size16 = 65535;
        int stride = attributes.vertexSize / 4;
        int vertexMaxSize = size16 * stride;
        IntArray primitiveIndices = new IntArray(verticesPerPrimitive);
        IntArray remainingIndices = new IntArray();
        int maxIndexFound = 0;
        for (int i2 = 0; i2 < indices.length; ++i2) {
            maxIndexFound = FastMath.max((int)maxIndexFound, (int)indices[i2]);
        }
        IntMap groups = new IntMap();
        int i3 = 0;
        int count = indices.length;
        while (i3 < count) {
            int index0 = indices[i3++];
            primitiveIndices.add(index0);
            int group0 = index0 / size16;
            boolean sameGroup = true;
            for (int j = 1; j < verticesPerPrimitive; ++j) {
                int indexI = indices[i3++];
                primitiveIndices.add(indexI);
                int groupI = indexI / size16;
                if (groupI == group0) continue;
                sameGroup = false;
            }
            if (sameGroup) {
                IntArray group = (IntArray)groups.get(group0);
                if (group == null) {
                    group = new IntArray();
                    groups.put(group0, (Object)group);
                }
                for (int j = 0; j < verticesPerPrimitive; ++j) {
                    group.add(primitiveIndices.get(j) - group0 * size16);
                }
            } else {
                remainingIndices.addAll(primitiveIndices);
            }
            primitiveIndices.clear();
        }
        int maxGroup = 0;
        for (IntMap.Entry entry : groups) {
            maxGroup = FastMath.max((int)maxGroup, (int)entry.key);
        }
        IntArray lastGroup = (IntArray)groups.get(maxGroup);
        int maxIndex = 0;
        for (i = 0; i < lastGroup.size; ++i) {
            maxIndex = FastMath.max((int)maxIndex, (int)lastGroup.get(i));
        }
        for (i = 0; i <= maxGroup; ++i) {
            float[] groupVertices = new float[vertexMaxSize];
            int offset = i * size16 * stride;
            int size = FastMath.min((int)(vertices.length - offset), (int)groupVertices.length);
            System.arraycopy(vertices, offset, groupVertices, 0, size);
            splitVertices.add((Object)groupVertices);
        }
        float[] lastVertices = (float[])splitVertices.peek();
        IntArray toProcess = new IntArray();
        while (remainingIndices.size > 0) {
            if (maxIndex < 0 || maxIndex >= size16 - 1) {
                maxIndex = -1;
                lastGroup = new IntArray();
                groups.put(++maxGroup, (Object)lastGroup);
                lastVertices = new float[vertexMaxSize];
                splitVertices.add((Object)lastVertices);
            }
            IntIntMap reindex = new IntIntMap();
            for (int i4 = 0; i4 < remainingIndices.size; ++i4) {
                int oindex = remainingIndices.get(i4);
                int tindex = reindex.get(oindex, -1);
                if (tindex < 0) {
                    tindex = maxIndex + 1;
                    if (tindex >= size16) {
                        toProcess.add(oindex);
                        continue;
                    }
                    reindex.put(oindex, tindex);
                    maxIndex = tindex;
                    lastGroup.add(tindex);
                    continue;
                }
                lastGroup.add(tindex);
            }
            for (IntIntMap.Entry entry : reindex) {
                System.arraycopy(vertices, entry.key * stride, lastVertices, entry.value * stride, stride);
            }
            if (toProcess.size == 0) break;
            remainingIndices.clear();
            IntArray tmp = toProcess;
            toProcess = remainingIndices;
            remainingIndices = tmp;
            maxIndex = -1;
        }
        for (int i5 = 0; i5 <= maxGroup; ++i5) {
            IntArray group = (IntArray)groups.get(i5);
            short[] shortIndices = new short[group.size];
            for (int j = 0; j < group.size; ++j) {
                int index = group.get(j);
                shortIndices[j] = (short)index;
            }
            splitIndices.add((Object)shortIndices);
        }
        int size = (maxIndex + 1) * stride;
        float[] tmp = new float[size];
        System.arraycopy(lastVertices, 0, tmp, 0, size);
        splitVertices.set(splitIndices.size - 1, (Object)tmp);
    }
}

