/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.geometry;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.mesh.IntMesh;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.shader.Material;

public class MeshTangentSpaceGenerator {
    public static void computeTangentSpace(IntMesh mesh, Material material, boolean computeNormals, boolean computeTangents) {
        if (mesh.getNumIndices() == 0) {
            throw new IllegalArgumentException("non indexed mesh not implemented");
        }
        float[] vertices = new float[mesh.getNumVertices() * mesh.getVertexAttributes().vertexSize / 4];
        int[] indices = new int[mesh.getNumIndices()];
        mesh.getVertices(vertices);
        mesh.getIndices(indices);
        PBRTextureAttribute normalMap = material.get(PBRTextureAttribute.class, PBRTextureAttribute.NormalTexture);
        if (normalMap == null) {
            throw new IllegalArgumentException("normal map not found in material");
        }
        VertexAttributes attributesGroup = mesh.getVertexAttributes();
        VertexAttribute normalMapUVs = null;
        for (VertexAttribute a : attributesGroup) {
            if (a.usage != 16 || a.unit != normalMap.uvIndex) continue;
            normalMapUVs = a;
        }
        if (normalMapUVs == null) {
            throw new IllegalArgumentException("texture coordinates not found");
        }
        MeshTangentSpaceGenerator.computeTangentSpace(vertices, indices, attributesGroup, computeNormals, computeTangents, normalMapUVs);
        mesh.setVertices(vertices);
        mesh.setIndices(indices);
    }

    public static void computeTangentSpace(float[] vertices, int[] indices, VertexAttributes attributesGroup, boolean computeNormals, boolean computeTangents, VertexAttribute normalMapUVs) {
        if (computeNormals) {
            MeshTangentSpaceGenerator.computeNormals(vertices, indices, attributesGroup);
        }
        if (computeTangents) {
            MeshTangentSpaceGenerator.computeTangents(vertices, indices, attributesGroup, normalMapUVs);
        }
    }

    private static void computeNormals(float[] vertices, int[] indices, VertexAttributes attributesGroup) {
        int posOffset = attributesGroup.getOffset(1);
        int normalOffset = attributesGroup.getOffset(8);
        int stride = attributesGroup.vertexSize / 4;
        Vector3 vab = new Vector3();
        Vector3 vac = new Vector3();
        if (indices != null) {
            int index = 0;
            int count = indices.length;
            while (index < count) {
                int vIndexA = indices[index++] & 0xFFFF;
                float ax = vertices[vIndexA * stride + posOffset];
                float ay = vertices[vIndexA * stride + posOffset + 1];
                float az = vertices[vIndexA * stride + posOffset + 2];
                int vIndexB = indices[index++] & 0xFFFF;
                float bx = vertices[vIndexB * stride + posOffset];
                float by = vertices[vIndexB * stride + posOffset + 1];
                float bz = vertices[vIndexB * stride + posOffset + 2];
                int vIndexC = indices[index++] & 0xFFFF;
                float cx = vertices[vIndexC * stride + posOffset];
                float cy = vertices[vIndexC * stride + posOffset + 1];
                float cz = vertices[vIndexC * stride + posOffset + 2];
                vab.set(bx, by, bz).sub(ax, ay, az);
                vac.set(cx, cy, cz).sub(ax, ay, az);
                Vector3 n = vab.crs(vac).nor();
                vertices[vIndexA * stride + normalOffset] = n.x;
                vertices[vIndexA * stride + normalOffset + 1] = n.y;
                vertices[vIndexA * stride + normalOffset + 2] = n.z;
                vertices[vIndexB * stride + normalOffset] = n.x;
                vertices[vIndexB * stride + normalOffset + 1] = n.y;
                vertices[vIndexB * stride + normalOffset + 2] = n.z;
                vertices[vIndexC * stride + normalOffset] = n.x;
                vertices[vIndexC * stride + normalOffset + 1] = n.y;
                vertices[vIndexC * stride + normalOffset + 2] = n.z;
            }
        } else {
            int index = 0;
            int count = vertices.length / stride;
            while (index < count) {
                int vIndexA = index++;
                float ax = vertices[vIndexA * stride + posOffset];
                float ay = vertices[vIndexA * stride + posOffset + 1];
                float az = vertices[vIndexA * stride + posOffset + 2];
                int vIndexB = index++;
                float bx = vertices[vIndexB * stride + posOffset];
                float by = vertices[vIndexB * stride + posOffset + 1];
                float bz = vertices[vIndexB * stride + posOffset + 2];
                int vIndexC = index++;
                float cx = vertices[vIndexC * stride + posOffset];
                float cy = vertices[vIndexC * stride + posOffset + 1];
                float cz = vertices[vIndexC * stride + posOffset + 2];
                vab.set(bx, by, bz).sub(ax, ay, az);
                vac.set(cx, cy, cz).sub(ax, ay, az);
                Vector3 n = vab.crs(vac).nor();
                vertices[vIndexA * stride + normalOffset] = n.x;
                vertices[vIndexA * stride + normalOffset + 1] = n.y;
                vertices[vIndexA * stride + normalOffset + 2] = n.z;
                vertices[vIndexB * stride + normalOffset] = n.x;
                vertices[vIndexB * stride + normalOffset + 1] = n.y;
                vertices[vIndexB * stride + normalOffset + 2] = n.z;
                vertices[vIndexC * stride + normalOffset] = n.x;
                vertices[vIndexC * stride + normalOffset + 1] = n.y;
                vertices[vIndexC * stride + normalOffset + 2] = n.z;
            }
        }
    }

    private static void computeTangents(float[] vertices, int[] indices, VertexAttributes attributesGroup, VertexAttribute normalMapUVs) {
        int posOffset = attributesGroup.getOffset(1);
        int normalOffset = attributesGroup.getOffset(8);
        int tangentOffset = attributesGroup.getOffset(128);
        int texCoordOffset = normalMapUVs.offset / 4;
        int stride = attributesGroup.vertexSize / 4;
        int vertexCount = vertices.length / stride;
        Vector3 vu = new Vector3();
        Vector3 vv = new Vector3();
        Vector3[] tan1 = new Vector3[indices.length];
        Vector3[] tan2 = new Vector3[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            tan1[i] = new Vector3();
            tan2[i] = new Vector3();
        }
        int index = 0;
        int count = indices.length;
        while (index < count) {
            int vIndexA = indices[index++] & 0xFFFF;
            float ax = vertices[vIndexA * stride + posOffset];
            float ay = vertices[vIndexA * stride + posOffset + 1];
            float az = vertices[vIndexA * stride + posOffset + 2];
            int vIndexB = indices[index++] & 0xFFFF;
            float bx = vertices[vIndexB * stride + posOffset];
            float by = vertices[vIndexB * stride + posOffset + 1];
            float bz = vertices[vIndexB * stride + posOffset + 2];
            int vIndexC = indices[index++] & 0xFFFF;
            float cx = vertices[vIndexC * stride + posOffset];
            float cy = vertices[vIndexC * stride + posOffset + 1];
            float cz = vertices[vIndexC * stride + posOffset + 2];
            float au = vertices[vIndexA * stride + texCoordOffset];
            float av = 1.0f - vertices[vIndexA * stride + texCoordOffset + 1];
            float bu = vertices[vIndexB * stride + texCoordOffset];
            float bv = 1.0f - vertices[vIndexB * stride + texCoordOffset + 1];
            float cu = vertices[vIndexC * stride + texCoordOffset];
            float cv = 1.0f - vertices[vIndexC * stride + texCoordOffset + 1];
            float dx1 = bx - ax;
            float dx2 = cx - ax;
            float dy1 = by - ay;
            float dy2 = cy - ay;
            float dz1 = bz - az;
            float dz2 = cz - az;
            float du1 = bu - au;
            float du2 = cu - au;
            float dv1 = bv - av;
            float dv2 = cv - av;
            float r = 1.0f / (du1 * dv2 - du2 * dv1);
            vu.set((dv2 * dx1 - dv1 * dx2) * r, (dv2 * dy1 - dv1 * dy2) * r, (dv2 * dz1 - dv1 * dz2) * r);
            vv.set((du1 * dx2 - du2 * dx1) * r, (du1 * dy2 - du2 * dy1) * r, (du1 * dz2 - du2 * dz1) * r);
            tan1[vIndexA].add(vu);
            tan2[vIndexA].add(vv);
            tan1[vIndexB].add(vu);
            tan2[vIndexB].add(vv);
            tan1[vIndexC].add(vu);
            tan2[vIndexC].add(vv);
        }
        Vector3 tangent = new Vector3();
        Vector3 normal = new Vector3();
        Vector3 biNormal = new Vector3();
        for (int i = 0; i < vertexCount; ++i) {
            float nx = vertices[i * stride + normalOffset];
            float ny = vertices[i * stride + normalOffset + 1];
            float nz = vertices[i * stride + normalOffset + 2];
            normal.set(nx, ny, nz);
            Vector3 t1 = tan1[i];
            tangent.set(t1).mulAdd(normal, -normal.dot(t1)).nor();
            Vector3 t2 = tan2[i];
            biNormal.set(normal).crs(tangent);
            float tangentW = biNormal.dot(t2) < 0.0f ? -1.0f : 1.0f;
            vertices[i * stride + tangentOffset] = tangent.x;
            vertices[i * stride + tangentOffset + 1] = tangent.y;
            vertices[i * stride + tangentOffset + 2] = tangent.z;
            vertices[i * stride + tangentOffset + 3] = tangentW;
        }
    }
}

