/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.material;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsEmissiveStrength;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsIOR;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsIridescence;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsPBRSpecularGlossiness;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsSpecular;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsTransmission;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsUnlit;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRMaterialsVolume;
import gaiasky.util.gdx.model.gltf.data.extensions.KHRTextureTransform;
import gaiasky.util.gdx.model.gltf.data.material.GLTFMaterial;
import gaiasky.util.gdx.model.gltf.data.material.GLTFpbrMetallicRoughness;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFTextureInfo;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFIllegalException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.material.MaterialLoaderBase;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.TextureResolver;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRFloatAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRIridescenceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRTextureAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.PBRVolumeAttribute;
import gaiasky.util.gdx.shader.Material;
import gaiasky.util.gdx.shader.attribute.Attribute;
import gaiasky.util.gdx.shader.attribute.BlendingAttribute;
import gaiasky.util.gdx.shader.attribute.ColorAttribute;
import gaiasky.util.gdx.shader.attribute.FloatAttribute;
import gaiasky.util.gdx.shader.attribute.IntAttribute;
import gaiasky.util.gdx.shader.attribute.TextureAttribute;

public class PBRMaterialLoader
extends MaterialLoaderBase {
    public PBRMaterialLoader(TextureResolver textureResolver) {
        super(textureResolver, new Material());
    }

    @Override
    public Material loadMaterial(GLTFMaterial glMaterial) {
        Material material = new Material();
        if (glMaterial.name != null) {
            material.id = glMaterial.name;
        }
        if (glMaterial.emissiveFactor != null && glMaterial.emissiveFactor[0] != 0.0f && glMaterial.emissiveFactor[1] != 0.0f && glMaterial.emissiveFactor[2] != 0.0f) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, GLTFTypes.mapColor(glMaterial.emissiveFactor, Color.BLACK)));
        }
        if (glMaterial.emissiveTexture != null) {
            material.set((Attribute)this.getTextureMap(TextureAttribute.Emissive, glMaterial.emissiveTexture));
        }
        if (glMaterial.doubleSided == Boolean.TRUE) {
            material.set((Attribute)IntAttribute.createCullFace(0));
        }
        if (glMaterial.normalTexture != null) {
            material.set((Attribute)this.getTextureMap(TextureAttribute.Normal, glMaterial.normalTexture));
        }
        if (glMaterial.occlusionTexture != null) {
            material.set((Attribute)this.getTextureMap(TextureAttribute.AO, glMaterial.occlusionTexture));
        }
        boolean alphaBlend = false;
        if (!"OPAQUE".equals(glMaterial.alphaMode)) {
            if ("MASK".equals(glMaterial.alphaMode)) {
                float value = glMaterial.alphaCutoff == null ? 0.5f : glMaterial.alphaCutoff.floatValue();
                material.set((Attribute)FloatAttribute.createAlphaTest(value));
                material.set((Attribute)new BlendingAttribute());
            } else if ("BLEND".equals(glMaterial.alphaMode)) {
                material.set((Attribute)new BlendingAttribute());
                alphaBlend = true;
            } else if (glMaterial.alphaMode != null) {
                throw new GLTFIllegalException("unknown alpha mode : " + glMaterial.alphaMode);
            }
        }
        if (glMaterial.pbrMetallicRoughness != null) {
            GLTFpbrMetallicRoughness p = glMaterial.pbrMetallicRoughness;
            if (p.baseColorFactor != null) {
                Color baseColorFactor = GLTFTypes.mapColor(p.baseColorFactor, Color.WHITE);
                material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, baseColorFactor));
            }
            if (p.metallicFactor != 0.0f) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Metallic, p.metallicFactor));
            }
            if (p.roughnessFactor != 1.0f) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Roughness, p.roughnessFactor));
            }
            if (p.metallicRoughnessTexture != null) {
                material.set((Attribute)this.getTextureMap(TextureAttribute.OcclusionMetallicRoughness, p.metallicRoughnessTexture));
            }
            if (p.baseColorTexture != null) {
                material.set((Attribute)this.getTextureMap(TextureAttribute.Diffuse, p.baseColorTexture));
            }
            if (alphaBlend) {
                material.get(BlendingAttribute.class, (int)BlendingAttribute.Type).opacity = 1.0f;
            }
        }
        if (glMaterial.extensions != null) {
            Object ext = glMaterial.extensions.get(KHRMaterialsPBRSpecularGlossiness.class, "KHR_materials_pbrSpecularGlossiness");
            if (ext != null) {
                Gdx.app.error("GLTF", "KHR_materials_pbrSpecularGlossiness extension is deprecated by glTF 2.0 specification and not fully supported.");
                material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, GLTFTypes.mapColor(((KHRMaterialsPBRSpecularGlossiness)ext).diffuseFactor, Color.WHITE)));
                material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, GLTFTypes.mapColor(((KHRMaterialsPBRSpecularGlossiness)ext).specularFactor, Color.WHITE)));
                material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, MathUtils.lerp((float)1.0f, (float)100.0f, (float)((KHRMaterialsPBRSpecularGlossiness)ext).glossinessFactor)));
                if (((KHRMaterialsPBRSpecularGlossiness)ext).diffuseTexture != null) {
                    material.set((Attribute)this.getTextureMap(TextureAttribute.Diffuse, ((KHRMaterialsPBRSpecularGlossiness)ext).diffuseTexture));
                }
                if (((KHRMaterialsPBRSpecularGlossiness)ext).specularGlossinessTexture != null) {
                    material.set((Attribute)this.getTextureMap(TextureAttribute.Specular, ((KHRMaterialsPBRSpecularGlossiness)ext).specularGlossinessTexture));
                }
            }
            ext = glMaterial.extensions.get(KHRMaterialsUnlit.class, "KHR_materials_unlit");
            ext = glMaterial.extensions.get(KHRMaterialsTransmission.class, "KHR_materials_transmission");
            if (ext != null) {
                material.set(PBRFloatAttribute.createTransmissionFactor(((KHRMaterialsTransmission)ext).transmissionFactor));
                if (((KHRMaterialsTransmission)ext).transmissionTexture != null) {
                    material.set((Attribute)this.getTextureMapPBR(PBRTextureAttribute.TransmissionTexture, ((KHRMaterialsTransmission)ext).transmissionTexture));
                }
            }
            if ((ext = glMaterial.extensions.get(KHRMaterialsVolume.class, "KHR_materials_volume")) != null) {
                material.set((Attribute)new PBRVolumeAttribute(((KHRMaterialsVolume)ext).thicknessFactor, ((KHRMaterialsVolume)ext).attenuationDistance == null ? 0.0f : ((KHRMaterialsVolume)ext).attenuationDistance.floatValue(), GLTFTypes.mapColor(((KHRMaterialsVolume)ext).attenuationColor, Color.WHITE)));
            }
            ext = glMaterial.extensions.get(KHRMaterialsIOR.class, "KHR_materials_ior");
            ext = glMaterial.extensions.get(KHRMaterialsSpecular.class, "KHR_materials_specular");
            if (ext != null) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, ((KHRMaterialsSpecular)ext).specularColorFactor[0], ((KHRMaterialsSpecular)ext).specularColorFactor[1], ((KHRMaterialsSpecular)ext).specularColorFactor[2], 1.0f));
                if (((KHRMaterialsSpecular)ext).specularTexture != null) {
                    material.set((Attribute)this.getTextureMap(TextureAttribute.Specular, ((KHRMaterialsSpecular)ext).specularTexture));
                } else if (((KHRMaterialsSpecular)ext).specularColorTexture != null) {
                    material.set((Attribute)this.getTextureMap(TextureAttribute.Specular, ((KHRMaterialsSpecular)ext).specularColorTexture));
                }
            }
            if ((ext = glMaterial.extensions.get(KHRMaterialsIridescence.class, "KHR_materials_iridescence")) != null) {
                material.set((Attribute)new PBRIridescenceAttribute(((KHRMaterialsIridescence)ext).iridescenceFactor, ((KHRMaterialsIridescence)ext).iridescenceIor, ((KHRMaterialsIridescence)ext).iridescenceThicknessMinimum, ((KHRMaterialsIridescence)ext).iridescenceThicknessMaximum));
                if (((KHRMaterialsIridescence)ext).iridescenceTexture != null) {
                    material.set((Attribute)this.getTextureMapPBR(PBRTextureAttribute.IridescenceTexture, ((KHRMaterialsIridescence)ext).iridescenceTexture));
                }
                if (((KHRMaterialsIridescence)ext).iridescenceThicknessTexture != null) {
                    material.set((Attribute)this.getTextureMapPBR(PBRTextureAttribute.IridescenceThicknessTexture, ((KHRMaterialsIridescence)ext).iridescenceThicknessTexture));
                }
            }
            if ((ext = glMaterial.extensions.get(KHRMaterialsEmissiveStrength.class, "KHR_materials_emissive_strength")) != null) {
                material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, ((KHRMaterialsEmissiveStrength)ext).emissiveStrength));
            }
        }
        return material;
    }

    protected TextureAttribute getTextureMap(int type, GLTFTextureInfo glMap) {
        KHRTextureTransform ext;
        TextureDescriptor<Texture> textureDescriptor = this.textureResolver.getTexture(glMap);
        TextureAttribute attribute = new TextureAttribute(type, textureDescriptor);
        attribute.uvIndex = glMap.texCoord;
        if (glMap.extensions != null && (ext = glMap.extensions.get(KHRTextureTransform.class, "KHR_texture_transform")) != null) {
            attribute.offsetU = ext.offset[0];
            attribute.offsetV = ext.offset[1];
            attribute.scaleU = ext.scale[0];
            attribute.scaleV = ext.scale[1];
            if (ext.texCoord != null) {
                attribute.uvIndex = ext.texCoord;
            }
        }
        return attribute;
    }

    protected PBRTextureAttribute getTextureMapPBR(int type, GLTFTextureInfo glMap) {
        KHRTextureTransform ext;
        TextureDescriptor<Texture> textureDescriptor = this.textureResolver.getTexture(glMap);
        PBRTextureAttribute attribute = new PBRTextureAttribute(type, textureDescriptor);
        attribute.uvIndex = glMap.texCoord;
        if (glMap.extensions != null && (ext = glMap.extensions.get(KHRTextureTransform.class, "KHR_texture_transform")) != null) {
            attribute.offsetU = ext.offset[0];
            attribute.offsetV = ext.offset[1];
            attribute.scaleU = ext.scale[0];
            attribute.scaleV = ext.scale[1];
            attribute.rotationUV = ext.rotation;
            if (ext.texCoord != null) {
                attribute.uvIndex = ext.texCoord;
            }
        }
        return attribute;
    }
}

