/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.scene;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import gaiasky.util.gdx.model.IntNode;
import gaiasky.util.gdx.model.IntNodePart;
import gaiasky.util.gdx.model.gltf.data.scene.GLTFNode;
import gaiasky.util.gdx.model.gltf.data.scene.GLTFSkin;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFIllegalException;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataResolver;
import gaiasky.util.gdx.model.gltf.loaders.shared.scene.NodeResolver;
import java.nio.FloatBuffer;
import net.jafama.FastMath;

public class SkinLoader {
    private int maxBones;

    public void load(Array<GLTFSkin> glSkins, Array<GLTFNode> glNodes, NodeResolver nodeResolver, DataResolver dataResolver) {
        if (glNodes != null) {
            for (int i = 0; i < glNodes.size; ++i) {
                GLTFNode glNode = (GLTFNode)glNodes.get(i);
                if (glNode.skin == null) continue;
                GLTFSkin glSkin = (GLTFSkin)glSkins.get(glNode.skin.intValue());
                this.load(glSkin, glNode, nodeResolver.get(i), nodeResolver, dataResolver);
            }
        }
    }

    private void load(GLTFSkin glSkin, GLTFNode glNode, IntNode node, NodeResolver nodeResolver, DataResolver dataResolver) {
        int i;
        Array ibms = new Array();
        Array joints = new Array();
        int bonesCount = glSkin.joints.size;
        this.maxBones = FastMath.max((int)this.maxBones, (int)bonesCount);
        FloatBuffer floatBuffer = dataResolver.getBufferFloat(glSkin.inverseBindMatrices);
        for (i = 0; i < bonesCount; ++i) {
            float[] matrixData = new float[16];
            floatBuffer.get(matrixData);
            ibms.add((Object)new Matrix4(matrixData));
        }
        joints.addAll(glSkin.joints);
        if (ibms.size > 0) {
            for (i = 0; i < node.parts.size; ++i) {
                IntNodePart nodePart = (IntNodePart)node.parts.get(i);
                if (nodePart.bones != null) {
                    IntNodePart newNodPart = new IntNodePart();
                    newNodPart.material = nodePart.material;
                    newNodPart.meshPart = nodePart.meshPart;
                    nodePart = newNodPart;
                    node.parts.set(i, (Object)nodePart);
                }
                nodePart.bones = new Matrix4[ibms.size];
                nodePart.invBoneBindTransforms = new ArrayMap();
                for (int n = 0; n < joints.size; ++n) {
                    nodePart.bones[n] = new Matrix4().idt();
                    int nodeIndex = (Integer)joints.get(n);
                    IntNode key = nodeResolver.get(nodeIndex);
                    if (key == null) {
                        throw new GLTFIllegalException("node not found for bone: " + nodeIndex);
                    }
                    nodePart.invBoneBindTransforms.put((Object)key, (Object)((Matrix4)ibms.get(n)));
                }
            }
        }
    }

    public int getMaxBones() {
        return this.maxBones;
    }
}

