/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.texture;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFImage;
import gaiasky.util.gdx.model.gltf.loaders.shared.data.DataFileResolver;

public class ImageResolver
implements Disposable {
    private final Array<Pixmap> pixmaps = new Array();
    private final DataFileResolver dataFileResolver;

    public ImageResolver(DataFileResolver dataFileResolver) {
        this.dataFileResolver = dataFileResolver;
    }

    public void load(Array<GLTFImage> glImages) {
        if (glImages != null) {
            for (int i = 0; i < glImages.size; ++i) {
                GLTFImage glImage = (GLTFImage)glImages.get(i);
                Pixmap pixmap = this.dataFileResolver.load(glImage);
                this.pixmaps.add((Object)pixmap);
            }
        }
    }

    public Pixmap get(int index) {
        return (Pixmap)this.pixmaps.get(index);
    }

    public void dispose() {
        for (Pixmap pixmap : this.pixmaps) {
            pixmap.dispose();
        }
        this.pixmaps.clear();
    }

    public void clear() {
        this.pixmaps.clear();
    }

    public Array<Pixmap> getPixmaps(Array<Pixmap> array) {
        array.addAll(this.pixmaps);
        return array;
    }
}

