/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.loaders.shared.texture;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectMap;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFSampler;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFTexture;
import gaiasky.util.gdx.model.gltf.data.texture.GLTFTextureInfo;
import gaiasky.util.gdx.model.gltf.loaders.exceptions.GLTFRuntimeException;
import gaiasky.util.gdx.model.gltf.loaders.shared.GLTFTypes;
import gaiasky.util.gdx.model.gltf.loaders.shared.texture.ImageResolver;

public class TextureResolver
implements Disposable {
    protected final ObjectMap<Integer, Texture> texturesSimple = new ObjectMap();
    protected final ObjectMap<Integer, Texture> texturesMipmap = new ObjectMap();
    protected Array<GLTFTexture> glTextures;
    protected Array<GLTFSampler> glSamplers;

    public void loadTextures(Array<GLTFTexture> glTextures, Array<GLTFSampler> glSamplers, ImageResolver imageResolver) {
        this.glTextures = glTextures;
        this.glSamplers = glSamplers;
        if (glTextures != null) {
            for (int i = 0; i < glTextures.size; ++i) {
                ObjectMap<Integer, Texture> textureMap;
                GLTFSampler sampler;
                GLTFTexture glTexture = (GLTFTexture)glTextures.get(i);
                boolean useMipMaps = false;
                if (glTexture.sampler != null && GLTFTypes.isMipMapFilter(sampler = (GLTFSampler)glSamplers.get(glTexture.sampler.intValue()))) {
                    useMipMaps = true;
                }
                ObjectMap<Integer, Texture> objectMap = textureMap = useMipMaps ? this.texturesMipmap : this.texturesSimple;
                if (textureMap.containsKey((Object)glTexture.source)) continue;
                Pixmap pixmap = imageResolver.get(glTexture.source);
                Texture texture = new Texture(pixmap, useMipMaps);
                textureMap.put((Object)glTexture.source, (Object)texture);
            }
        }
    }

    public TextureDescriptor<Texture> getTexture(GLTFTextureInfo glMap) {
        boolean useMipMaps;
        GLTFTexture glTexture = (GLTFTexture)this.glTextures.get(glMap.index.intValue());
        TextureDescriptor textureDescriptor = new TextureDescriptor();
        if (glTexture.sampler != null) {
            GLTFSampler glSampler = (GLTFSampler)this.glSamplers.get(glTexture.sampler.intValue());
            GLTFTypes.mapTextureSampler((TextureDescriptor<Texture>)textureDescriptor, glSampler);
            useMipMaps = GLTFTypes.isMipMapFilter(glSampler);
        } else {
            textureDescriptor.minFilter = Texture.TextureFilter.Linear;
            textureDescriptor.magFilter = Texture.TextureFilter.Linear;
            textureDescriptor.uWrap = Texture.TextureWrap.Repeat;
            textureDescriptor.vWrap = Texture.TextureWrap.Repeat;
            useMipMaps = false;
        }
        ObjectMap<Integer, Texture> textureMap = useMipMaps ? this.texturesMipmap : this.texturesSimple;
        Texture texture = (Texture)textureMap.get((Object)glTexture.source);
        if (texture == null) {
            throw new GLTFRuntimeException("texture not loaded");
        }
        textureDescriptor.texture = texture;
        return textureDescriptor;
    }

    public void dispose() {
        for (ObjectMap.Entry e : this.texturesSimple) {
            ((Texture)e.value).dispose();
        }
        this.texturesSimple.clear();
        for (ObjectMap.Entry e : this.texturesMipmap) {
            ((Texture)e.value).dispose();
        }
        this.texturesMipmap.clear();
    }

    public Array<Texture> getTextures(Array<Texture> textures) {
        for (ObjectMap.Entry e : this.texturesSimple) {
            textures.add((Object)((Texture)e.value));
        }
        for (ObjectMap.Entry e : this.texturesMipmap) {
            textures.add((Object)((Texture)e.value));
        }
        return textures;
    }
}

