/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.animation;

import com.badlogic.gdx.utils.Array;
import gaiasky.util.gdx.model.IntAnimation;
import gaiasky.util.gdx.model.IntAnimationController;
import gaiasky.util.gdx.model.gltf.scene3d.animation.AnimationControllerHack;
import gaiasky.util.gdx.model.gltf.scene3d.scene.Scene;

public class AnimationsPlayer {
    private final Scene scene;
    private final Array<IntAnimationController> controllers = new Array();

    public AnimationsPlayer(Scene scene) {
        this.scene = scene;
    }

    public void addAnimations(Array<IntAnimationController.AnimationDesc> animations) {
        for (IntAnimationController.AnimationDesc animation : animations) {
            this.addAnimation(animation);
        }
    }

    public void addAnimation(IntAnimationController.AnimationDesc animation) {
        AnimationControllerHack c = new AnimationControllerHack(this.scene.modelInstance);
        c.calculateTransforms = false;
        c.setAnimationDesc(animation);
        this.controllers.add((Object)c);
    }

    public void removeAnimation(IntAnimation animation) {
        for (int i = this.controllers.size - 1; i >= 0; --i) {
            if (((IntAnimationController)this.controllers.get((int)i)).current == null || ((IntAnimationController)this.controllers.get((int)i)).current.animation != animation) continue;
            this.controllers.removeIndex(i);
        }
    }

    public void clearAnimations() {
        this.controllers.clear();
        if (this.scene.animationController != null) {
            this.scene.animationController.setAnimation((String)null);
        }
    }

    public void playAll() {
        this.playAll(false);
    }

    public void loopAll() {
        this.playAll(true);
    }

    public void playAll(boolean loop) {
        this.clearAnimations();
        int n = this.scene.modelInstance.animations.size;
        for (int i = 0; i < n; ++i) {
            AnimationControllerHack c = new AnimationControllerHack(this.scene.modelInstance);
            c.calculateTransforms = false;
            c.setAnimation((IntAnimation)this.scene.modelInstance.animations.get(i), loop ? -1 : 1);
            this.controllers.add((Object)c);
        }
    }

    public void stopAll() {
        this.clearAnimations();
    }

    public void update(float delta) {
        if (this.controllers.size > 0) {
            for (IntAnimationController controller : this.controllers) {
                controller.update(delta);
            }
            this.scene.modelInstance.calculateTransforms();
        } else if (this.scene.animationController != null) {
            this.scene.animationController.update(delta);
        }
    }
}

