/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.attributes;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class ClippingPlaneAttribute
extends Attribute {
    public static final String TypeAlias = "clippingPlane";
    public static final int Type = ClippingPlaneAttribute.register("clippingPlane");
    public final Plane plane;

    public ClippingPlaneAttribute(Plane plane) {
        super(Type);
        this.plane = plane;
    }

    public ClippingPlaneAttribute(Vector3 normal, float d) {
        super(Type);
        this.plane = new Plane(normal, d);
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        ClippingPlaneAttribute other = (ClippingPlaneAttribute)o;
        Vector3 normal = this.plane.normal;
        Vector3 otherNormal = other.plane.normal;
        if (!MathUtils.isEqual((float)normal.x, (float)otherNormal.x)) {
            return normal.x < otherNormal.x ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)normal.y, (float)otherNormal.y)) {
            return normal.y < otherNormal.y ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)normal.z, (float)otherNormal.z)) {
            return normal.z < otherNormal.z ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.plane.d, (float)other.plane.d)) {
            return this.plane.d < other.plane.d ? -1 : 1;
        }
        return 0;
    }

    @Override
    public Attribute copy() {
        return new ClippingPlaneAttribute(this.plane.normal, this.plane.d);
    }
}

