/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.attributes;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class FogAttribute
extends Attribute {
    public static final String FogEquationAlias = "fogEquation";
    public static final int FogEquation = FogAttribute.register("fogEquation");
    public final Vector3 value = new Vector3();

    public static FogAttribute createFog(float near, float far, float exponent) {
        return new FogAttribute(FogEquation).set(near, far, exponent);
    }

    public FogAttribute(int index) {
        super(index);
    }

    public Attribute set(Vector3 value) {
        this.value.set(value);
        return this;
    }

    public FogAttribute set(float near, float far, float exponent) {
        this.value.set(near, far, exponent);
        return this;
    }

    @Override
    public Attribute copy() {
        return new FogAttribute(this.index).set(this.value);
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        FogAttribute other = (FogAttribute)o;
        if (!MathUtils.isEqual((float)this.value.x, (float)other.value.x)) {
            return this.value.x < other.value.x ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.value.y, (float)other.value.y)) {
            return this.value.y < other.value.y ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.value.z, (float)other.value.z)) {
            return this.value.z < other.value.z ? -1 : 1;
        }
        return 0;
    }
}

