/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.attributes;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector3;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class MirrorSourceAttribute
extends Attribute {
    public static final String TypeAlias = "mirrorSource";
    public static final int Type = MirrorSourceAttribute.register("mirrorSource");
    public final TextureDescriptor<Texture> textureDescription = new TextureDescriptor();
    public final Vector3 normal = new Vector3();

    public MirrorSourceAttribute() {
        super(Type);
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        MirrorSourceAttribute other = (MirrorSourceAttribute)o;
        int c = this.textureDescription.compareTo(other.textureDescription);
        if (c != 0) {
            return c;
        }
        Vector3 otherNormal = other.normal;
        if (!MathUtils.isEqual((float)this.normal.x, (float)otherNormal.x)) {
            return this.normal.x < otherNormal.x ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.normal.y, (float)otherNormal.y)) {
            return this.normal.y < otherNormal.y ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.normal.z, (float)otherNormal.z)) {
            return this.normal.z < otherNormal.z ? -1 : 1;
        }
        return 0;
    }

    @Override
    public Attribute copy() {
        return this.set(this.textureDescription, this.normal);
    }

    public MirrorSourceAttribute set(TextureDescriptor<Texture> textureDescription, Vector3 normal) {
        this.textureDescription.set(textureDescription);
        this.normal.set(normal);
        return this;
    }
}

