/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.attributes;

import gaiasky.util.gdx.shader.attribute.Attribute;

public class PBRHDRColorAttribute
extends Attribute {
    public static final String SpecularAlias = "specularColorHDR";
    public static final int Specular = PBRHDRColorAttribute.register("specularColorHDR");
    public float r;
    public float g;
    public float b;

    public PBRHDRColorAttribute(int type, float r, float g, float b) {
        super(type);
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public PBRHDRColorAttribute set(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        return this;
    }

    @Override
    public Attribute copy() {
        return new PBRHDRColorAttribute(this.index, this.r, this.g, this.b);
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        PBRHDRColorAttribute a = (PBRHDRColorAttribute)o;
        int cr = Float.compare(this.r, a.r);
        if (cr != 0) {
            return cr;
        }
        int cg = Float.compare(this.g, a.g);
        if (cg != 0) {
            return cg;
        }
        int cb = Float.compare(this.b, a.b);
        if (cb != 0) {
            return cb;
        }
        return 0;
    }
}

