/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.attributes;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class PBRVolumeAttribute
extends Attribute {
    public static final String Alias = "volume";
    public static final int Type = PBRVolumeAttribute.register("volume");
    public float thicknessFactor = 0.0f;
    public float attenuationDistance = 0.0f;
    public final Color attenuationColor = new Color(Color.WHITE);

    public PBRVolumeAttribute() {
        super(Type);
    }

    public PBRVolumeAttribute(float thicknessFactor, float attenuationDistance, Color attenuationColor) {
        super(Type);
        this.thicknessFactor = thicknessFactor;
        this.attenuationDistance = attenuationDistance;
        this.attenuationColor.set(attenuationColor);
    }

    @Override
    public int compareTo(Attribute o) {
        if (this.index != o.index) {
            return this.index - o.index;
        }
        PBRVolumeAttribute other = (PBRVolumeAttribute)o;
        if (!MathUtils.isEqual((float)this.thicknessFactor, (float)other.thicknessFactor)) {
            return this.thicknessFactor < other.thicknessFactor ? -1 : 1;
        }
        if (!MathUtils.isEqual((float)this.attenuationDistance, (float)other.attenuationDistance)) {
            return this.attenuationDistance < other.attenuationDistance ? -1 : 1;
        }
        return this.attenuationColor.toIntBits() - other.attenuationColor.toIntBits();
    }

    @Override
    public Attribute copy() {
        return new PBRVolumeAttribute(this.thicknessFactor, this.attenuationDistance, this.attenuationColor);
    }
}

