/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.math.Vector3;

public class DirectionalLightEx
extends DirectionalLight {
    public final Color baseColor = new Color(Color.WHITE);
    public float intensity = 1.0f;

    public DirectionalLight set(DirectionalLight copyFrom) {
        if (copyFrom instanceof DirectionalLightEx) {
            return this.set(((DirectionalLightEx)copyFrom).baseColor, copyFrom.direction, ((DirectionalLightEx)copyFrom).intensity);
        }
        return this.set(copyFrom.color, copyFrom.direction, 1.0f);
    }

    public DirectionalLightEx set(Color baseColor, Vector3 direction, float intensity) {
        this.intensity = intensity;
        this.baseColor.set(baseColor);
        this.direction.set(direction);
        this.updateColor();
        return this;
    }

    public DirectionalLightEx set(Color color, Vector3 direction) {
        if (color != null) {
            this.baseColor.set(color);
        }
        if (direction != null) {
            this.direction.set(direction).nor();
        }
        return this;
    }

    public DirectionalLightEx set(float r, float g, float b, Vector3 direction) {
        this.baseColor.set(r, g, b, 1.0f);
        if (direction != null) {
            this.direction.set(direction).nor();
        }
        return this;
    }

    public DirectionalLightEx set(Color color, float dirX, float dirY, float dirZ) {
        if (color != null) {
            this.baseColor.set(color);
        }
        this.direction.set(dirX, dirY, dirZ).nor();
        return this;
    }

    public DirectionalLightEx set(float r, float g, float b, float dirX, float dirY, float dirZ) {
        this.baseColor.set(r, g, b, 1.0f).clamp();
        this.direction.set(dirX, dirY, dirZ).nor();
        return this;
    }

    public void updateColor() {
        this.color.r = this.baseColor.r * this.intensity;
        this.color.g = this.baseColor.g * this.intensity;
        this.color.b = this.baseColor.b * this.intensity;
    }

    public boolean equals(DirectionalLight other) {
        return other instanceof DirectionalLightEx ? this.equals((DirectionalLightEx)other) : false;
    }

    public boolean equals(DirectionalLightEx other) {
        return other != null && (other == this || this.baseColor.equals((Object)other.baseColor) && Float.compare(this.intensity, other.intensity) == 0 && this.direction.equals((Object)other.direction));
    }
}

