/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.math.Vector3;
import net.jafama.FastMath;

public class SpotLightEx
extends SpotLight {
    public Float range;

    public SpotLight set(SpotLight copyFrom) {
        if (copyFrom instanceof SpotLightEx) {
            return this.set(copyFrom.color, copyFrom.position, copyFrom.direction, copyFrom.intensity, copyFrom.cutoffAngle, copyFrom.exponent, ((SpotLightEx)copyFrom).range);
        }
        return this.set(copyFrom.color, copyFrom.position, copyFrom.direction, copyFrom.intensity, copyFrom.cutoffAngle, copyFrom.exponent);
    }

    @Deprecated
    public SpotLightEx set(Color color, Vector3 position, Vector3 direction, float intensity, float cutoffAngle, float exponent, Float range) {
        super.set(color, position, direction, intensity, cutoffAngle, exponent);
        this.range = range;
        return this;
    }

    public SpotLightEx setRad(Color color, Vector3 position, Vector3 direction, float intensity, float outerConeAngleRad, float innerConeAngleRad, Float range) {
        if (color != null) {
            this.color.set(color);
        }
        if (position != null) {
            this.position.set(position);
        }
        if (direction != null) {
            this.direction.set(direction).nor();
        }
        this.intensity = intensity;
        this.setConeRad(outerConeAngleRad, innerConeAngleRad);
        this.range = range;
        return this;
    }

    public SpotLightEx setDeg(Color color, Vector3 position, Vector3 direction, float intensity, float outerConeAngleDeg, float innerConeAngleDeg, Float range) {
        return this.setRad(color, position, direction, intensity, outerConeAngleDeg * ((float)Math.PI / 180), innerConeAngleDeg * ((float)Math.PI / 180), range);
    }

    public SpotLightEx setConeRad(float outerConeAngleRad, float innerConeAngleRad) {
        float lightAngleOffset;
        float cosOuterAngle = (float)Math.cos(outerConeAngleRad);
        float cosInnerAngle = (float)Math.cos(innerConeAngleRad);
        float lightAngleScale = 1.0f / FastMath.max((float)0.001f, (float)(cosInnerAngle - cosOuterAngle));
        this.cutoffAngle = lightAngleOffset = -cosOuterAngle * lightAngleScale;
        this.exponent = lightAngleScale;
        return this;
    }

    public SpotLightEx setConeDeg(float outerConeAngleDeg, float innerConeAngleDeg) {
        return this.setConeRad(outerConeAngleDeg * ((float)Math.PI / 180), innerConeAngleDeg * ((float)Math.PI / 180));
    }
}

