/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.scene.camera.ICamera;
import gaiasky.util.Constants;
import gaiasky.util.DoubleArray;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.CascadeShadowMapAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.lights.DirectionalShadowLight;
import gaiasky.util.math.BoundingBoxDouble;
import gaiasky.util.math.FrustumDouble;
import gaiasky.util.math.Matrix4D;
import gaiasky.util.math.Vector3D;
import net.jafama.FastMath;

public class CascadeShadowMap
implements Disposable {
    public final Array<DirectionalShadowLight> lights;
    public final CascadeShadowMapAttribute attribute;
    protected final int cascadeCount;
    protected final DoubleArray splitRates;
    private final Vector3D[] splitPoints;
    private final Matrix4D lightMatrix = new Matrix4D();
    private final BoundingBoxDouble box = new BoundingBoxDouble();
    private final Vector3D center = new Vector3D();
    private final Vector3D a = new Vector3D();
    private final Vector3D b = new Vector3D();
    private final Vector3D dir = new Vector3D();
    private final Vector3D up = new Vector3D();
    private final Vector3D tmp = new Vector3D();
    private final Vector3D tmp2 = new Vector3D();
    protected Matrix4D projection;
    protected Matrix4D view;
    protected Matrix4D combined;
    private final Matrix4D invProjectionView = new Matrix4D();
    protected FrustumDouble frustum;
    public double CAM_NEAR_CSM;
    public double CAM_FAR_CSM;

    public CascadeShadowMap(int cascadeCount) {
        this.cascadeCount = cascadeCount;
        this.attribute = new CascadeShadowMapAttribute(this);
        this.lights = new Array(cascadeCount);
        this.splitRates = new DoubleArray(cascadeCount + 2);
        this.splitPoints = new Vector3D[8];
        for (int i = 0; i < this.splitPoints.length; ++i) {
            this.splitPoints[i] = new Vector3D();
        }
        this.projection = new Matrix4D();
        this.view = new Matrix4D();
        this.combined = new Matrix4D();
        this.frustum = new FrustumDouble();
        this.CAM_NEAR_CSM = 1000.0 * Constants.M_TO_U;
        this.CAM_FAR_CSM = Constants.AU_TO_U;
    }

    public void dispose() {
        for (DirectionalShadowLight light : this.lights) {
            light.dispose();
        }
        this.lights.clear();
    }

    public double getSplitDistance(int layer) {
        if (layer < 0 || layer > this.cascadeCount) {
            return 1.0;
        }
        return this.splitRates.get(layer + 1);
    }

    public void setCascades(ICamera sceneCamera, DirectionalShadowLight baseLight, double lightDepthFactor, double splitDivisor) {
        this.splitRates.clear();
        double rate = 1.0;
        for (int i = 0; i < this.cascadeCount + 1; ++i) {
            this.splitRates.add(rate);
            rate /= splitDivisor;
        }
        this.splitRates.add(0.0);
        this.splitRates.reverse();
        this.setCascades(sceneCamera, baseLight, lightDepthFactor, this.splitRates);
    }

    public void setCascades(ICamera sceneCamera, DirectionalShadowLight base, double lightDepthFactor, DoubleArray splitRates) {
        if (splitRates.size != this.cascadeCount + 2) {
            throw new IllegalArgumentException("Invalid splitRates, expected " + (this.cascadeCount + 2) + " items.");
        }
        this.updateCSM(sceneCamera.getCamera(), this.tmp2.set(0.0, 0.0, 0.0), sceneCamera.getDirection(), sceneCamera.getUp());
        this.syncExtraCascades(base);
        for (int i = 0; i < this.cascadeCount + 1; ++i) {
            DirectionalShadowLight light;
            double splitNear = splitRates.get(i);
            double splitFar = splitRates.get(i + 1);
            DirectionalShadowLight directionalShadowLight = light = i < this.cascadeCount ? (DirectionalShadowLight)((Object)this.lights.get(i)) : base;
            if (light != base) {
                light.direction.set(base.direction);
                light.getCamera().up.set(base.getCamera().up);
            }
            this.setCascades(light, splitNear, splitFar, lightDepthFactor);
        }
    }

    private void setCascades(DirectionalShadowLight shadowLight, double splitNear, double splitFar, double lightDepthFactor) {
        for (int i = 0; i < 4; ++i) {
            this.a.set(this.frustum.planePoints[i]);
            this.b.set(this.frustum.planePoints[i + 4]);
            this.splitPoints[i].set(this.a).lerp(this.b, splitNear);
            this.splitPoints[i + 4].set(this.a).lerp(this.b, splitFar);
        }
        this.dir.set(shadowLight.direction);
        this.up.set(shadowLight.getCamera().up);
        this.lightMatrix.setToLookAt(this.dir, this.up);
        this.box.inf();
        for (Vector3D splitPoint : this.splitPoints) {
            Vector3D v = splitPoint.mul(this.lightMatrix);
            this.box.ext(v);
        }
        double halfFrustumDepth = this.box.getDepth() / 2.0;
        double lightDepth = FastMath.max((double)this.box.getDepth(), (double)(this.box.getDepth() * lightDepthFactor));
        this.box.getCenter(this.center);
        this.center.mul(this.lightMatrix.tra());
        this.center.mulAdd(this.dir, halfFrustumDepth - lightDepth / 2.0);
        shadowLight.setCenter(this.center);
        shadowLight.setViewport(this.box.getWidth(), this.box.getHeight(), 0.0, lightDepth);
    }

    protected void syncExtraCascades(DirectionalShadowLight base) {
        int w = base.getFrameBuffer().getWidth();
        int h = base.getFrameBuffer().getHeight();
        for (int i = 0; i < this.cascadeCount; ++i) {
            DirectionalShadowLight light;
            if (i < this.lights.size) {
                light = (DirectionalShadowLight)((Object)this.lights.get(i));
                if (light.getFrameBuffer().getWidth() != w || light.getFrameBuffer().getHeight() != h) {
                    light.dispose();
                    light = this.createLight(w, h);
                    this.lights.set(i, (Object)light);
                }
            } else {
                light = this.createLight(w, h);
                this.lights.add((Object)light);
            }
            light.direction.set(base.direction);
            light.getCamera().up.set(base.getCamera().up);
        }
    }

    protected DirectionalShadowLight createLight(int width, int height) {
        return new DirectionalShadowLight(width, height);
    }

    public void updateCSM(PerspectiveCamera cam, Vector3D position, Vector3D direction, Vector3D up) {
        double aspect = cam.viewportWidth / cam.viewportHeight;
        this.projection.setToProjection(this.CAM_NEAR_CSM, this.CAM_FAR_CSM, cam.fieldOfView, aspect);
        this.view.setToLookAt(position, this.tmp.set(position).add(direction), up);
        this.combined.set(this.projection);
        Matrix4D.mul(this.combined.val, this.view.val);
        this.invProjectionView.set(this.combined);
        Matrix4D.inv(this.invProjectionView.val);
        this.frustum.update(this.invProjectionView);
    }
}

