/*
 * Decompiled with CFR 0.152.
 */
package gaiasky.util.gdx.model.gltf.scene3d.scene;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.ClippingPlaneAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.attributes.MirrorSourceAttribute;
import gaiasky.util.gdx.model.gltf.scene3d.scene.SceneSkybox;
import gaiasky.util.gdx.shader.Environment;
import gaiasky.util.gdx.shader.attribute.Attribute;

public class MirrorSource
implements Disposable {
    protected FrameBuffer fbo;
    private int width;
    private int height;
    private final Vector3 originalCameraPosition = new Vector3();
    private final Vector3 originalCameraDirection = new Vector3();
    private final Vector3 originalCameraUp = new Vector3();
    private final Vector3 planeOrigin = new Vector3();
    private final Vector3 planeToCamera = new Vector3();
    public boolean clipScene = true;
    protected final MirrorSourceAttribute mirrorAttribute = new MirrorSourceAttribute();
    private final ClippingPlaneAttribute clippingPlane = new ClippingPlaneAttribute(Vector3.Y, 0.0f);
    private Camera camera;
    private Environment environment;
    private SceneSkybox skyBox;

    public MirrorSource() {
        this.mirrorAttribute.textureDescription.minFilter = Texture.TextureFilter.MipMap;
        this.mirrorAttribute.textureDescription.magFilter = Texture.TextureFilter.Linear;
        this.mirrorAttribute.normal.set(this.clippingPlane.plane.normal);
    }

    protected FrameBuffer createFrameBuffer(int width, int height) {
        return new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setPlane(float nx, float ny, float nz, float d) {
        this.clippingPlane.plane.normal.set(nx, ny, nz).nor();
        this.clippingPlane.plane.d = d;
        this.mirrorAttribute.normal.set(this.clippingPlane.plane.normal);
    }

    public MirrorSource set(float nx, float ny, float nz, float d, boolean clipScene) {
        this.setPlane(nx, ny, nz, d);
        this.clipScene = clipScene;
        return this;
    }

    public void begin(Camera camera, Environment environment, SceneSkybox skyBox) {
        this.camera = camera;
        this.environment = environment;
        this.skyBox = skyBox;
        this.setupCamera(camera, this.clippingPlane.plane);
        if (skyBox != null) {
            skyBox.update(camera, 0.0f);
        }
        if (this.clipScene) {
            environment.set((Attribute)this.clippingPlane);
        }
        this.ensureFrameBufferSize(this.width, this.height);
        this.fbo.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16640);
    }

    public void end() {
        this.fbo.end();
        Texture texture = (Texture)this.fbo.getColorBufferTexture();
        texture.bind();
        Gdx.gl.glGenerateMipmap(texture.glTarget);
        this.mirrorAttribute.textureDescription.texture = this.fbo.getColorBufferTexture();
        this.restoreCamera(this.camera);
        this.environment.set((Attribute)this.mirrorAttribute);
        this.environment.remove(ClippingPlaneAttribute.Type);
        if (this.skyBox != null) {
            this.skyBox.update(this.camera, 0.0f);
        }
        this.camera = null;
        this.environment = null;
        this.skyBox = null;
    }

    private void setupCamera(Camera camera, Plane plane) {
        this.originalCameraPosition.set(camera.position);
        this.originalCameraDirection.set(camera.direction);
        this.originalCameraUp.set(camera.up);
        this.planeOrigin.set(this.clippingPlane.plane.normal).scl(this.clippingPlane.plane.d);
        this.planeToCamera.set(camera.position).sub(this.planeOrigin);
        camera.position.sub(this.planeToCamera);
        this.reflect(this.planeToCamera, this.clippingPlane.plane.normal);
        camera.position.add(this.planeToCamera);
        this.reflect(camera.direction, this.clippingPlane.plane.normal);
        this.reflect(camera.up, this.clippingPlane.plane.normal);
        camera.update();
    }

    private void reflect(Vector3 vector, Vector3 normal) {
        vector.mulAdd(normal, -2.0f * vector.dot(normal));
    }

    private void restoreCamera(Camera camera) {
        camera.position.set(this.originalCameraPosition);
        camera.direction.set(this.originalCameraDirection);
        camera.up.set(this.originalCameraUp);
        camera.update();
    }

    private void ensureFrameBufferSize(int width, int height) {
        if (width <= 0) {
            width = Gdx.graphics.getBackBufferWidth();
        }
        if (height <= 0) {
            height = Gdx.graphics.getBackBufferHeight();
        }
        if (this.fbo == null || this.fbo.getWidth() != width || this.fbo.getHeight() != height) {
            if (this.fbo != null) {
                this.fbo.dispose();
            }
            this.fbo = this.createFrameBuffer(width, height);
        }
    }

    public void dispose() {
        if (this.fbo != null) {
            this.fbo.dispose();
        }
    }
}

